/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.kodoku;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import stepsword.mahoutsukai.capability.kodoku.IKodokuMahou;
import stepsword.mahoutsukai.capability.kodoku.KodokuMahou;
import stepsword.mahoutsukai.capability.kodoku.KodokuMahouProvider;
import stepsword.mahoutsukai.capability.kodoku.KodokuMahouStorage;
import stepsword.mahoutsukai.entity.kodoku.KodokuEntity;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class KodokuItem
extends ItemBase {
    public KodokuItem() {
        super("kodoku");
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new KodokuMahouProvider();
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag ret = super.getShareTag(stack);
        if (ret == null) {
            IKodokuMahou mahou = Utils.getKodokuMahou(stack);
            return (CompoundTag)KodokuMahouStorage.writeNBT(mahou);
        }
        return ret;
    }

    public void readShareTag(ItemStack stack, CompoundTag nbtt) {
        if (nbtt != null) {
            IKodokuMahou kodokuMahou = Utils.getKodokuMahou(stack);
            KodokuMahou serverKodokuMahou = new KodokuMahou();
            KodokuMahouStorage.readNBT(serverKodokuMahou, (Tag)nbtt);
            if (kodokuMahou != null) {
                kodokuMahou.setKodoku(serverKodokuMahou.getKodoku());
            }
        }
        super.readShareTag(stack, nbtt);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IKodokuMahou kodokuMahou;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        Item item = stack.m_41720_();
        if (item instanceof KodokuItem && (kodokuMahou = Utils.getKodokuMahou(stack)) != null) {
            String kodoku = "" + kodokuMahou.getKodoku();
            tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)"mahoutsukai.kodoku").getString() + ": " + kodoku)));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level worldIn = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Direction facing = context.m_43719_();
        if (!worldIn.f_46443_) {
            KodokuItem.setKodoku(player.m_21205_(), KodokuItem.getKodoku(player.m_21205_()));
            KodokuEntity entity = new KodokuEntity(worldIn);
            Vec3 place = EffectUtil.fromBlockPos(pos.m_121945_(facing));
            entity.m_19890_(place.f_82479_ + 0.5 + Math.random() * 0.3, place.f_82480_, place.f_82481_ + 0.5 + Math.random() * 0.3, (float)(Math.random() * 360.0), 0.0f);
            entity.kodoku = KodokuItem.getKodoku(player.m_21120_(hand));
            worldIn.m_7967_((Entity)entity);
            player.m_21120_(hand).m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (!target.f_19853_.f_46443_) {
            int kodoku = KodokuItem.getKodoku(playerIn.m_21120_(hand));
            boolean hasworm = false;
            for (int i = 0; i < target.m_20197_().size(); ++i) {
                if (!(target.m_20197_().get(i) instanceof KodokuEntity)) continue;
                hasworm = true;
            }
            if (kodoku <= 0 && !(target instanceof KodokuEntity) && !hasworm) {
                KodokuEntity entity = new KodokuEntity(target.f_19853_);
                entity.m_19890_(target.m_20185_() - (double)(target.m_6972_(null).f_20377_ / 2.0f), target.m_20186_() + (double)target.m_20192_(), target.m_20189_(), target.f_19857_, target.f_19858_ + 90.0f);
                target.f_19853_.m_7967_((Entity)entity);
                entity.m_7998_((Entity)target, true);
                playerIn.m_21120_(hand).m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public static int getKodoku(ItemStack stack) {
        IKodokuMahou mahou = Utils.getKodokuMahou(stack);
        if (mahou != null) {
            return mahou.getKodoku();
        }
        return 0;
    }

    public static void setKodoku(ItemStack stack, int k) {
        IKodokuMahou mahou = Utils.getKodokuMahou(stack);
        if (mahou != null) {
            mahou.setKodoku(k);
        }
        stack.m_41751_((CompoundTag)KodokuMahouStorage.writeNBT(mahou));
    }

    public boolean m_41468_() {
        return true;
    }
}

