/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.lance;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import stepsword.jousting.item.ItemLance;
import stepsword.mahoutsukai.capability.lance.ILanceMahou;
import stepsword.mahoutsukai.capability.lance.LanceMahou;
import stepsword.mahoutsukai.capability.lance.LanceMahouProvider;
import stepsword.mahoutsukai.capability.lance.LanceMahouStorage;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.entity.mahoujin.RhongomyniadEntity;
import stepsword.mahoutsukai.item.MagicalItemRender;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.spells.projection.PowerConsolidation.Caliburn;
import stepsword.mahoutsukai.render.item.RhongomyniadRenderer;
import stepsword.mahoutsukai.util.FakeSkeleton;
import stepsword.mahoutsukai.util.Utils;

public class Rhongomyniad
extends ItemLance {
    public static final UUID speedlance = UUID.fromString("91AEAA56-377B-4498-936B-2E8F20090635");
    public static final String MT_ATTACK_DAMAGE = "mahoutsukai_rhongomyniad_attack";
    public static final String MT_WEIGHT = "mahoutsukai_rhongomyniad_weight";

    public Rhongomyniad() {
        super("rhongomyniad", ModItems.MAHOUTSUKAI_CREATIVE_TAB, () -> 1200, () -> 10.0, () -> 2.0);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new LanceMahouProvider();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        if (player.m_20163_() && handIn == InteractionHand.MAIN_HAND && !worldIn.f_46443_) {
            BlockHitResult result = Rhongomyniad.m_41435_((Level)worldIn, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (result != null && result.m_82425_() != null) {
                ItemStack r = player.m_21205_().m_41777_();
                RhongomyniadEntity rhongomyniad = new RhongomyniadEntity(worldIn, player, 1.0f, r);
                BlockPos p = result.m_82425_().m_121945_(result.m_82434_());
                rhongomyniad.m_6034_((double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5);
                worldIn.m_7967_((Entity)rhongomyniad);
                player.m_21205_().m_41774_(1);
            }
            return InteractionResultHolder.m_19090_((Object)player.m_21205_());
        }
        return super.m_7203_(worldIn, player, handIn);
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.POWER_CONSOLIDATION_DURABILITY;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (stack.m_41720_() instanceof Rhongomyniad && player.m_20202_() != null && player.m_20202_() instanceof LivingEntity) {
            LivingEntity riding = (LivingEntity)player.m_20202_();
            if (!player.f_19853_.m_6443_(LivingEntity.class, player.m_20191_().m_82400_((double)MTConfig.RHONGOMYNIAD_RANGE), b -> Caliburn.specialTarget(b)).isEmpty()) {
                Rhongomyniad.addspeed(riding, true);
            }
        }
        super.onUsingTick(stack, player, count);
    }

    public static float simulateHit(ItemStack s, Level world) {
        float ret = 3.0f;
        int health = 5000000;
        if (s != null) {
            ItemStack s1 = s.m_41777_();
            FakeSkeleton fake_target = new FakeSkeleton(world);
            fake_target.h = 5000000.0f;
            SafeFakePlayer fake_player = new SafeFakePlayer((ServerLevel)world, "faker");
            fake_player.m_21008_(InteractionHand.MAIN_HAND, s1);
            fake_player.m_21204_().m_22178_(s1.m_41638_(EquipmentSlot.MAINHAND));
            ((Player)fake_player).f_20922_ = 1000;
            if (s1.m_41720_() instanceof ItemLance) {
                ((ItemLance)s1.m_41720_()).attackTargetEntityWithCurrentItem((Entity)fake_target, (Player)fake_player);
            }
            ret = (float)health - fake_target.h;
        }
        return ret;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity player, int timeLeft) {
        if (player.m_20202_() instanceof LivingEntity) {
            Rhongomyniad.addspeed((LivingEntity)player.m_20202_(), false);
        }
        super.m_5551_(stack, worldIn, player, timeLeft);
    }

    public static void addspeed(LivingEntity living, boolean add) {
        AttributeModifier a = new AttributeModifier(speedlance, "rhongomyniad_speed", MTConfig.RHONGOMYNIAD_SPEED_FACTOR, AttributeModifier.Operation.MULTIPLY_TOTAL);
        AttributeInstance attr = living.m_21051_(Attributes.f_22279_);
        if (attr != null) {
            boolean hasSpeed = attr.m_22109_(a);
            if (add) {
                if (!hasSpeed) {
                    attr.m_22118_(a);
                }
            } else if (hasSpeed) {
                attr.m_22130_(a);
            }
        }
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag ret = super.getShareTag(stack);
        if (ret == null) {
            ILanceMahou mahou = Utils.getLanceMahou(stack);
            return (CompoundTag)LanceMahouStorage.writeNBT(mahou);
        }
        return ret;
    }

    public static void setattacktonbt(ItemStack stack, Level world) {
        if (stack != null && !world.f_46443_) {
            ILanceMahou mahou;
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            if ((mahou = Utils.getLanceMahou(stack)) != null) {
                nbt.m_128350_(MT_ATTACK_DAMAGE, mahou.getAttackDamage());
                nbt.m_128350_(MT_WEIGHT, mahou.getWeight());
            }
            stack.m_41751_(nbt);
        }
    }

    public static void getattackfromnbt(ItemStack stack) {
        if (stack != null && stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            ILanceMahou mahou = Utils.getLanceMahou(stack);
            if (mahou != null) {
                if (nbt != null && nbt.m_128441_(MT_ATTACK_DAMAGE)) {
                    mahou.setAttackDamage(Math.max(nbt.m_128457_(MT_ATTACK_DAMAGE), mahou.getAttackDamage()));
                }
                if (nbt != null && nbt.m_128441_(MT_WEIGHT)) {
                    mahou.setWeight(Math.max(nbt.m_128457_(MT_WEIGHT), mahou.getWeight()));
                }
            }
        }
    }

    public void readShareTag(ItemStack stack, CompoundTag nbtt) {
        if (nbtt != null) {
            ILanceMahou lanceMahou = Utils.getLanceMahou(stack);
            LanceMahou serverLanceMahou = new LanceMahou();
            LanceMahouStorage.readNBT(serverLanceMahou, (Tag)nbtt);
            if (lanceMahou != null) {
                lanceMahou.setAttackDamage(serverLanceMahou.getAttackDamage());
                lanceMahou.setWeight(serverLanceMahou.getWeight());
            }
        }
        super.readShareTag(stack, nbtt);
    }

    public double getAttackDamage(ItemStack stack) {
        ILanceMahou mahou;
        Rhongomyniad.getattackfromnbt(stack);
        double damage = 1.0;
        if (stack != null && (mahou = Utils.getLanceMahou(stack)) != null) {
            damage += (double)mahou.getAttackDamage();
        }
        return damage;
    }

    public double getWeight(ItemStack stack) {
        ILanceMahou mahou;
        Rhongomyniad.getattackfromnbt(stack);
        double weight = 2.0;
        if (stack != null && (mahou = Utils.getLanceMahou(stack)) != null) {
            weight = mahou.getWeight();
        }
        return weight;
    }

    public Object getRenderPropertiesInternal() {
        return new MagicalItemRender(RhongomyniadRenderer::new);
    }
}

