/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class BlackFirePacket {
    int entityids;
    boolean onFire;

    public BlackFirePacket() {
    }

    public BlackFirePacket(int e, boolean b) {
        this.entityids = e;
        this.onFire = b;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityids = buf.readInt();
        this.onFire = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityids);
        buf.writeBoolean(this.onFire);
    }

    public static void encode(BlackFirePacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static BlackFirePacket decode(FriendlyByteBuf buf) {
        BlackFirePacket msg = new BlackFirePacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(BlackFirePacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.updateFire(message);
        context.get().setPacketHandled(true);
    }
}

