/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.secret;

import java.util.HashSet;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.util.Utils;

public class GeasEffect {
    public static String BREAK = "==MAHOU==";

    public static boolean geasEffect(Player caster) {
        Entity e = Utils.selectEntityNearCursor(caster, MTConfig.GLOBAL_LOOK_RANGE, caster.f_19853_, a -> Utils.getPredicate(Utils.MAHOU_SELECTION.SCROLL_GEAS, a, caster), Utils.nearAllowed(Utils.MAHOU_SELECTION.SCROLL_GEAS));
        if (e instanceof LivingEntity) {
            return GeasEffect.addGeas(caster, (LivingEntity)e);
        }
        if (e instanceof ItemEntity) {
            return GeasEffect.addGeas(caster, (ItemEntity)e);
        }
        MutableComponent tt = Component.m_237115_((String)"mahoutsukai.geas.geasa");
        tt.m_7220_((Component)Component.m_237113_((String)(" " + GeasEffect.getGeasString(caster))));
        if (caster instanceof ServerPlayer) {
            caster.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.AQUA + tt.getString())), false);
        }
        return false;
    }

    public static boolean geasItem(EntityItemPickupEvent event) {
        return GeasEffect.hasGeas(event.getEntity(), event.getItem().m_32055_());
    }

    public static boolean geasLivingHurt(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        Entity e = event.getSource().m_7639_();
        if (e instanceof Player) {
            return GeasEffect.hasGeas((Player)e, target);
        }
        return false;
    }

    public static boolean geasAttackEntity(AttackEntityEvent event) {
        Entity target = event.getTarget();
        Player e = event.getEntity();
        if (e instanceof Player && target instanceof LivingEntity && GeasEffect.hasGeas(e, (LivingEntity)target)) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    public static boolean addGeas(Player player, LivingEntity target) {
        String message;
        Object geas;
        boolean r = true;
        if (target instanceof Player) {
            geas = target.m_5446_().getString() + BREAK + "minecraft:player";
            message = target.m_5446_().getString();
        } else {
            geas = Utils.getRegistryName((Entity)target);
            message = target.m_5446_().getString();
            if (target.m_7770_() != null && !player.m_20163_()) {
                message = target.m_7770_().getString();
                geas = target.m_7770_().getString() + BREAK + (String)geas;
            }
        }
        r = GeasEffect.add(player, message, ChatFormatting.m_126649_((String)geas));
        return r;
    }

    public static boolean add(Player player, String message, String geas) {
        boolean r = true;
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            String added = "mahoutsukai.geas.added";
            if (geasList.contains(geas)) {
                added = "mahoutsukai.geas.removed";
                geasList.remove(geas);
                r = false;
            } else {
                geasList.add(geas);
            }
            MutableComponent tt = Component.m_237115_((String)added);
            tt.m_7220_((Component)Component.m_237113_((String)(" " + message)));
            if (player instanceof ServerPlayer) {
                ((ServerPlayer)player).m_5661_((Component)tt, true);
            }
        }
        return r;
    }

    public static boolean addGeas(Player player, ItemEntity item) {
        boolean r = true;
        String s = "Item:" + item.m_32055_().m_41720_().m_7626_(item.m_32055_()).getString();
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            r = GeasEffect.add(player, s, ChatFormatting.m_126649_((String)s));
        }
        return r;
    }

    public static boolean hasGeas(Player player, ItemStack item) {
        String s = "Item:" + item.m_41720_().m_7626_(item).getString();
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            for (String g : geasList) {
                if (!g.equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasGeas(Player player, LivingEntity target) {
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            String nameDisplay = "";
            if (target.m_7770_() != null) {
                nameDisplay = target.m_7770_().getString();
            }
            if (target instanceof Player) {
                nameDisplay = target.m_5446_().getString();
            }
            String nameType = Utils.getRegistryName((Entity)target);
            for (String g : geasList) {
                String[] lst;
                if (!(g.contains(BREAK) ? (lst = g.split(BREAK)).length >= 2 && lst[0].equals(nameDisplay) && lst[1].equals(nameType) : nameType.equals(g))) continue;
                return true;
            }
        }
        return false;
    }

    public static String getGeasString(Player player) {
        Object geasa = "";
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            for (String g : geasList) {
                String[] lst = g.split(BREAK);
                if (!((String)geasa).equals("")) {
                    geasa = (String)geasa + ", ";
                }
                if (lst.length > 1) {
                    geasa = (String)geasa + GeasEffect.regToName(lst[1]);
                    geasa = (String)geasa + " - " + lst[0];
                    continue;
                }
                geasa = (String)geasa + GeasEffect.regToName(lst[0]);
            }
        }
        return geasa;
    }

    public static int getUniqueGeasCount(Player player) {
        int geasa = 0;
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            HashSet<String> geasList = mahou.getGeas();
            if (geasList == null) {
                geasList = new HashSet();
                mahou.setGeas(geasList);
            }
            for (String g : geasList) {
                String[] lst = g.split(BREAK);
                if (lst.length != 1 || lst[0].startsWith("Item:")) continue;
                ++geasa;
            }
        }
        return geasa;
    }

    public static String regToName(String res) {
        if (!res.startsWith("Item:")) {
            ResourceLocation loc = new ResourceLocation(res);
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(loc);
            if (type != null) {
                return type.m_20676_().getString();
            }
            return res;
        }
        return res;
    }
}

