/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.particles.laserparticle;

import com.direwolf20.mininggadgets.client.particles.ModParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class LaserParticleData
implements ParticleOptions {
    public final float size;
    public final float maxAgeMul;
    public final boolean depthTest;
    public final BlockState state;
    public static final ParticleOptions.Deserializer<LaserParticleData> DESERIALIZER = new ParticleOptions.Deserializer<LaserParticleData>(){

        @Nonnull
        public LaserParticleData fromCommand(@Nonnull ParticleType<LaserParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            BlockState state = BlockStateParser.m_234700_((Registry)Registry.f_122824_, (StringReader)reader, (boolean)false).f_234748_();
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            float mam = reader.readFloat();
            boolean depth = true;
            if (reader.canRead()) {
                reader.expect(' ');
                depth = reader.readBoolean();
            }
            return new LaserParticleData(state, size, mam, depth);
        }

        public LaserParticleData fromNetwork(@Nonnull ParticleType<LaserParticleData> type, FriendlyByteBuf buf) {
            return new LaserParticleData((BlockState)Block.f_49791_.m_7942_(buf.m_130242_()), buf.readFloat(), buf.readFloat(), buf.readBoolean());
        }
    };

    public static LaserParticleData laserparticle(BlockState state, float size, float maxAgeMul) {
        return LaserParticleData.laserparticle(state, size, maxAgeMul, true);
    }

    public static LaserParticleData laserparticle(BlockState state, float size, float maxAgeMul, boolean depthTest) {
        return new LaserParticleData(state, size, maxAgeMul, depthTest);
    }

    private LaserParticleData(BlockState state, float size, float maxAgeMul, boolean depthTest) {
        this.size = size;
        this.maxAgeMul = maxAgeMul;
        this.depthTest = depthTest;
        this.state = state;
    }

    @Nonnull
    public ParticleType<LaserParticleData> m_6012_() {
        return (ParticleType)ModParticles.LASERPARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.m_130130_(Block.f_49791_.m_7447_((Object)this.state));
        buf.writeFloat(this.size);
        buf.writeFloat(this.maxAgeMul);
        buf.writeBoolean(this.depthTest);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %s", Registry.f_122829_.m_7981_(this.m_6012_()), Float.valueOf(this.size), Float.valueOf(this.maxAgeMul), this.depthTest);
    }
}

