/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.renderer;

import com.direwolf20.mininggadgets.client.renderer.MyRenderType;
import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import com.direwolf20.mininggadgets.common.items.gadget.MiningCollect;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.util.VectorHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;

public class BlockOverlayRender {
    public static void render(RenderLevelStageEvent event, ItemStack item) {
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        int range = MiningProperties.getBeamRange(item);
        BlockHitResult lookingAt = VectorHelper.getLookingAt((Player)mc.f_91074_, ClipContext.Fluid.NONE, range);
        if (mc.f_91073_.m_8055_(VectorHelper.getLookingAt((Player)mc.f_91074_, item, range).m_82425_()) == Blocks.f_50016_.m_49966_()) {
            return;
        }
        List<BlockPos> coords = MiningCollect.collect((Player)mc.f_91074_, lookingAt, (Level)mc.f_91073_, MiningProperties.getRange(item));
        Vec3 view = mc.f_91063_.m_109153_().m_90583_();
        PoseStack matrix = event.getPoseStack();
        matrix.m_85836_();
        matrix.m_85837_(-view.m_7096_(), -view.m_7098_(), -view.m_7094_());
        VertexConsumer builder = buffer.m_6299_(MyRenderType.BlockOverlay);
        coords.forEach(e -> {
            if (mc.f_91073_.m_8055_(e).m_60734_() != ModBlocks.RENDER_BLOCK.get()) {
                matrix.m_85836_();
                matrix.m_85837_((double)e.m_123341_(), (double)e.m_123342_(), (double)e.m_123343_());
                matrix.m_85837_((double)-0.005f, (double)-0.005f, (double)-0.005f);
                matrix.m_85841_(1.01f, 1.01f, 1.01f);
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
                Matrix4f positionMatrix = matrix.m_85850_().m_85861_();
                BlockOverlayRender.render(positionMatrix, builder, e, Color.GREEN);
                matrix.m_85849_();
            }
        });
        matrix.m_85849_();
        RenderSystem.m_69465_();
        buffer.m_109912_(MyRenderType.BlockOverlay);
    }

    public static void render(Matrix4f matrix, VertexConsumer builder, BlockPos pos, Color color) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = 0.125f;
        float startX = 0.0f;
        float startY = 0.0f;
        float startZ = -1.0f;
        float endX = 1.0f;
        float endY = 1.0f;
        float endZ = 0.0f;
        builder.m_85982_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_85982_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
    }
}

