/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.screens;

import com.direwolf20.mininggadgets.client.screens.ModScreens;
import com.direwolf20.mininggadgets.client.screens.widget.ToggleButton;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.network.PacketHandler;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeFreezeDelay;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeMiningSize;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeRange;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeVolume;
import com.direwolf20.mininggadgets.common.network.packets.PacketOpenFilterContainer;
import com.direwolf20.mininggadgets.common.network.packets.PacketToggleFilters;
import com.direwolf20.mininggadgets.common.network.packets.PacketTogglePrecision;
import com.direwolf20.mininggadgets.common.network.packets.PacketUpdateUpgrade;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ForgeSlider;

public class MiningSettingScreen
extends Screen {
    private ItemStack gadget;
    private int beamRange;
    private int freezeDelay;
    private float volume;
    private int currentSize = 1;
    private boolean isWhitelist = true;
    private boolean isPrecision = true;
    private ForgeSlider rangeSlider;
    private ForgeSlider volumeSlider;
    private ForgeSlider freezeDelaySlider;
    private List<Upgrade> toggleableList = new ArrayList<Upgrade>();
    private HashMap<Upgrade, ToggleButton> upgradeButtons = new HashMap();
    private boolean containsFreeze = false;

    public MiningSettingScreen(ItemStack gadget) {
        super((Component)Component.m_237113_((String)"title"));
        this.gadget = gadget;
        this.beamRange = MiningProperties.getBeamRange(gadget);
        this.volume = MiningProperties.getVolume(gadget);
        this.freezeDelay = MiningProperties.getFreezeDelay(gadget);
    }

    protected void m_7856_() {
        ArrayList<Object> leftWidgets = new ArrayList<Object>();
        int baseX = this.f_96543_ / 2;
        int baseY = this.f_96544_ / 2;
        this.toggleableList.clear();
        this.toggleableList = UpgradeTools.getUpgrades(this.gadget).stream().filter(Upgrade::isToggleable).collect(Collectors.toList());
        this.containsFreeze = UpgradeTools.containsUpgradeFromList(this.toggleableList, Upgrade.FREEZING);
        boolean containsVoid = UpgradeTools.containsUpgradeFromList(this.toggleableList, Upgrade.VOID_JUNK);
        this.isWhitelist = MiningProperties.getWhiteList(this.gadget);
        this.isPrecision = MiningProperties.getPrecisionMode(this.gadget);
        int top = baseY - (this.containsFreeze ? 80 : 60);
        int index = 0;
        int x = baseX + 10;
        int y = top + (containsVoid ? 45 : 20);
        for (Upgrade upgrade : this.toggleableList) {
            ToggleButton btn = new ToggleButton(x + index * 30, y, UpgradeTools.getName(upgrade), new ResourceLocation("mininggadgets", "textures/item/upgrade_" + upgrade.getName() + ".png"), send -> this.toggleUpgrade(upgrade, (boolean)send));
            this.m_142416_((GuiEventListener)btn);
            this.upgradeButtons.put(upgrade, btn);
            if (++index % 4 != 0) continue;
            index = 0;
            y += 35;
        }
        if (containsVoid) {
            this.m_142416_((GuiEventListener)new Button(baseX + 10, top + 20, 95, 20, (Component)MiningSettingScreen.getTrans("tooltip.screen.edit_filters", new Object[0]), button -> PacketHandler.sendToServer(new PacketOpenFilterContainer())));
            this.m_142416_((GuiEventListener)new WhitelistButton(baseX + 10 + 95, top + 20, 20, 20, this.isWhitelist, button -> {
                this.isWhitelist = !this.isWhitelist;
                ((WhitelistButton)button).setWhitelist(this.isWhitelist);
                PacketHandler.sendToServer(new PacketToggleFilters());
            }));
        }
        this.currentSize = MiningProperties.getRange(this.gadget);
        Button sizeButton = new Button(baseX - 135, 0, 125, 20, (Component)Component.m_237110_((String)"mininggadgets.tooltip.screen.size", (Object[])new Object[]{this.currentSize}), button -> {
            this.currentSize = this.currentSize == 1 ? 3 : 1;
            button.m_93666_((Component)MiningSettingScreen.getTrans("tooltip.screen.size", this.currentSize));
            PacketHandler.sendToServer(new PacketChangeMiningSize());
        });
        leftWidgets.add(sizeButton);
        this.rangeSlider = new ForgeSlider(baseX - 135, 0, 125, 20, (Component)MiningSettingScreen.getTrans("tooltip.screen.range", new Object[0]).m_130946_(": "), (Component)Component.m_237119_(), 1.0, MiningProperties.getBeamMaxRange(this.gadget), this.beamRange, true){

            protected void m_5697_() {
                MiningSettingScreen.this.beamRange = this.getValueInt();
            }
        };
        leftWidgets.add(this.rangeSlider);
        leftWidgets.add(new Button(baseX - 135, 0, 125, 20, (Component)MiningSettingScreen.getTrans("tooltip.screen.visuals_menu", new Object[0]), button -> ModScreens.openVisualSettingsScreen(this.gadget)));
        leftWidgets.add(new Button(baseX - 135, 0, 125, 20, (Component)MiningSettingScreen.getTrans("tooltip.screen.precision_mode", this.isPrecision), button -> {
            this.isPrecision = !this.isPrecision;
            button.m_93666_((Component)MiningSettingScreen.getTrans("tooltip.screen.precision_mode", this.isPrecision));
            PacketHandler.sendToServer(new PacketTogglePrecision());
        }));
        this.volumeSlider = new ForgeSlider(baseX - 135, 0, 125, 20, (Component)MiningSettingScreen.getTrans("tooltip.screen.volume", new Object[0]).m_130946_(": "), (Component)Component.m_237113_((String)"%"), 0.0, 100.0, this.volume * 100.0f, true){

            protected void m_5697_() {
                MiningSettingScreen.this.volume = (float)(this.getValue() / 100.0);
            }
        };
        leftWidgets.add(this.volumeSlider);
        if (this.containsFreeze) {
            this.freezeDelaySlider = new ForgeSlider(baseX - 135, 0, 125, 20, (Component)MiningSettingScreen.getTrans("tooltip.screen.freeze_delay", new Object[0]).m_130946_(": "), (Component)Component.m_237113_((String)" ").m_7220_((Component)MiningSettingScreen.getTrans("tooltip.screen.ticks", new Object[0])), 0.0, 10.0, MiningProperties.getFreezeDelay(this.gadget), true){

                protected void m_5697_() {
                    MiningSettingScreen.this.freezeDelay = this.getValueInt();
                }
            };
            leftWidgets.add(this.freezeDelaySlider);
        }
        if (!UpgradeTools.containsActiveUpgrade(this.gadget, Upgrade.THREE_BY_THREE)) {
            sizeButton.f_93623_ = false;
        }
        for (int i = 0; i < leftWidgets.size(); ++i) {
            ((AbstractWidget)leftWidgets.get((int)i)).f_93621_ = top + 20 + i * 25;
            this.m_142416_((GuiEventListener)((AbstractWidget)leftWidgets.get(i)));
        }
    }

    private boolean toggleUpgrade(Upgrade upgrade, boolean update) {
        if (update) {
            this.updateButtons(upgrade);
            PacketHandler.sendToServer(new PacketUpdateUpgrade(upgrade.getName()));
        }
        return upgrade.isEnabled();
    }

    private void updateButtons(Upgrade upgrade) {
        for (Map.Entry<Upgrade, ToggleButton> btn : this.upgradeButtons.entrySet()) {
            Upgrade btnUpgrade = btn.getKey();
            if ((!btnUpgrade.lazyIs(Upgrade.FORTUNE_1) || !btn.getValue().isEnabled() || !upgrade.lazyIs(Upgrade.SILK)) && (!btnUpgrade.lazyIs(Upgrade.SILK) || !btn.getValue().isEnabled() || !upgrade.lazyIs(Upgrade.FORTUNE_1))) continue;
            this.upgradeButtons.get((Object)btn.getKey()).setEnabled(false);
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        int top = this.f_96544_ / 2 - (this.containsFreeze ? 80 : 60);
        MiningSettingScreen.m_93243_((PoseStack)stack, (Font)this.getMinecraft().f_91062_, (Component)MiningSettingScreen.getTrans("tooltip.screen.mining_gadget", new Object[0]), (int)(this.f_96543_ / 2 - 135), (int)top, (int)Color.WHITE.getRGB());
        MiningSettingScreen.m_93243_((PoseStack)stack, (Font)this.getMinecraft().f_91062_, (Component)MiningSettingScreen.getTrans("tooltip.screen.toggle_upgrades", new Object[0]), (int)(this.f_96543_ / 2 + 10), (int)top, (int)Color.WHITE.getRGB());
        if (this.toggleableList.size() == 0) {
            MiningSettingScreen.m_93243_((PoseStack)stack, (Font)this.getMinecraft().f_91062_, (Component)MiningSettingScreen.getTrans("tooltip.screen.no_upgrades", new Object[0]), (int)(this.f_96543_ / 2 + 10), (int)(top + 20), (int)Color.GRAY.getRGB());
        }
        this.m_6702_().forEach(e -> {
            if (!(e instanceof ToggleButton || e instanceof WhitelistButton || e.equals(this.freezeDelaySlider))) {
                return;
            }
            if (e instanceof WhitelistButton) {
                if (e.m_5953_((double)mouseX, (double)mouseY)) {
                    this.m_96602_(stack, (Component)(this.isWhitelist ? MiningSettingScreen.getTrans("tooltip.screen.whitelist", new Object[0]) : MiningSettingScreen.getTrans("tooltip.screen.blacklist", new Object[0])), mouseX, mouseY);
                }
            } else if (e.equals(this.freezeDelaySlider)) {
                if (e.m_5953_((double)mouseX, (double)mouseY)) {
                    assert (e instanceof ForgeSlider);
                    List helpText = Arrays.stream(MiningSettingScreen.getTrans("tooltip.screen.delay_explain", new Object[0]).getString().split("\n")).map(Component::m_237113_).collect(Collectors.toList());
                    this.m_96617_(stack, Language.m_128107_().m_128112_(helpText), ((ForgeSlider)e).f_93620_ - 8, ((ForgeSlider)e).f_93621_ + 40);
                }
            } else {
                assert (e instanceof ToggleButton);
                ToggleButton btn = (ToggleButton)((Object)e);
                if (btn.m_5953_(mouseX, mouseY)) {
                    this.m_96617_(stack, btn.getTooltip(), mouseX, mouseY);
                }
            }
        });
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7861_() {
        PacketHandler.sendToServer(new PacketChangeRange(this.beamRange));
        PacketHandler.sendToServer(new PacketChangeVolume(this.volume));
        PacketHandler.sendToServer(new PacketChangeFreezeDelay(this.freezeDelay));
        super.m_7861_();
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256 || this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    private static MutableComponent getTrans(String key, Object ... args) {
        return Component.m_237110_((String)("mininggadgets." + key), (Object[])args);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.rangeSlider.m_5953_(mouseX, mouseY)) {
            this.rangeSlider.m_93611_((double)(this.rangeSlider.getValueInt() + (delta > 0.0 ? 1 : -1)));
            this.beamRange = this.rangeSlider.getValueInt();
        }
        if (this.freezeDelaySlider != null && this.freezeDelaySlider.m_5953_(mouseX, mouseY)) {
            this.freezeDelaySlider.m_93611_((double)(this.freezeDelaySlider.getValueInt() + (delta > 0.0 ? 1 : -1)));
            this.freezeDelay = this.freezeDelaySlider.getValueInt();
        }
        if (this.volumeSlider.m_5953_(mouseX, mouseY)) {
            this.volumeSlider.m_93611_((double)(this.volumeSlider.getValueInt() + (delta > 0.0 ? 1 : -1)));
            this.volume = this.volumeSlider.getValueInt();
        }
        return false;
    }

    public static final class WhitelistButton
    extends Button {
        private boolean isWhitelist;

        public WhitelistButton(int widthIn, int heightIn, int width, int height, boolean isWhitelist, Button.OnPress onPress) {
            super(widthIn, heightIn, width, height, (Component)Component.m_237119_(), onPress);
            this.isWhitelist = isWhitelist;
        }

        public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
            WhitelistButton.m_93172_((PoseStack)stack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-5723992);
            WhitelistButton.m_93172_((PoseStack)stack, (int)(this.f_93620_ + 2), (int)(this.f_93621_ + 2), (int)(this.f_93620_ + this.f_93618_ - 2), (int)(this.f_93621_ + this.f_93619_ - 2), (int)(this.isWhitelist ? -1 : -16777216));
        }

        public void setWhitelist(boolean whitelist) {
            this.isWhitelist = whitelist;
        }
    }
}

