/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.network.packets;

import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketChangeColor {
    private final short red;
    private final short green;
    private final short blue;
    private final short red_inner;
    private final short green_inner;
    private final short blue_inner;

    public PacketChangeColor(int red, int green, int blue, int red_inner, int green_inner, int blue_inner) {
        this.red = (short)red;
        this.green = (short)green;
        this.blue = (short)blue;
        this.red_inner = (short)red_inner;
        this.green_inner = (short)green_inner;
        this.blue_inner = (short)blue_inner;
    }

    public static void encode(PacketChangeColor msg, FriendlyByteBuf buffer) {
        buffer.writeShort((int)msg.red);
        buffer.writeShort((int)msg.green);
        buffer.writeShort((int)msg.blue);
        buffer.writeShort((int)msg.red_inner);
        buffer.writeShort((int)msg.green_inner);
        buffer.writeShort((int)msg.blue_inner);
    }

    public static PacketChangeColor decode(FriendlyByteBuf buffer) {
        return new PacketChangeColor(buffer.readShort(), buffer.readShort(), buffer.readShort(), buffer.readShort(), buffer.readShort(), buffer.readShort());
    }

    public static class Handler {
        public static void handle(PacketChangeColor msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                ItemStack stack = MiningGadget.getGadget((Player)player);
                MiningProperties.setColor(stack, msg.red, "colorRed");
                MiningProperties.setColor(stack, msg.green, "colorGreen");
                MiningProperties.setColor(stack, msg.blue, "colorBlue");
                MiningProperties.setColor(stack, msg.red_inner, "colorRedInner");
                MiningProperties.setColor(stack, msg.green_inner, "colorGreenInner");
                MiningProperties.setColor(stack, msg.blue_inner, "colorBlueInner");
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

