/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class TransformingBiMap<KFrom, VFrom, KTo, VTo>
implements BiMap<KTo, VTo> {
    private final BiMap<KFrom, VFrom> delegate;
    private final Function<KFrom, KTo> keyFwd;
    private final Function<KTo, KFrom> keyBack;
    private final Function<VFrom, VTo> valueFwd;
    private final Function<VTo, VFrom> valueBack;

    public TransformingBiMap(BiMap<KFrom, VFrom> map, Function<KFrom, KTo> keyFwd, Function<KTo, KFrom> keyBack, Function<VFrom, VTo> valueFwd, Function<VTo, VFrom> valueBack) {
        this.delegate = map;
        this.keyFwd = keyFwd;
        this.keyBack = keyBack;
        this.valueFwd = valueFwd;
        this.valueBack = valueBack;
    }

    private KFrom keyBack(KTo key) {
        return key == null ? null : (KFrom)this.keyBack.apply(key);
    }

    private KTo keyFwd(KFrom key) {
        return key == null ? null : (KTo)this.keyFwd.apply(key);
    }

    private VFrom valueBack(VTo value) {
        return value == null ? null : (VFrom)this.valueBack.apply(value);
    }

    private VTo valueFwd(VFrom value) {
        return value == null ? null : (VTo)this.valueFwd.apply(value);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(Object o) {
        return this.delegate.containsKey(this.keyBack(o));
    }

    public boolean containsValue(Object o) {
        return false;
    }

    public VTo get(Object o) {
        return this.valueFwd(this.delegate.get(this.keyBack(o)));
    }

    public VTo put(KTo key, VTo value) {
        return this.valueFwd(this.delegate.put(this.keyBack(key), this.valueBack(value)));
    }

    public VTo remove(Object o) {
        return this.valueFwd(this.delegate.remove(this.keyBack(o)));
    }

    public VTo forcePut(KTo key, VTo value) {
        return this.valueFwd(this.delegate.forcePut(this.keyBack(key), this.valueBack(value)));
    }

    public void putAll(Map<? extends KTo, ? extends VTo> map) {
        map.forEach((key, value) -> this.delegate.put(this.keyBack(key), this.valueBack(value)));
    }

    public void clear() {
        this.delegate.clear();
    }

    @NotNull
    public Set<KTo> keySet() {
        return new TransformingSet<KFrom, KTo>(this.delegate.keySet(), this.keyFwd, this.keyBack);
    }

    public Set<VTo> values() {
        return new TransformingSet<VFrom, VTo>(this.delegate.values(), this.valueFwd, this.valueBack);
    }

    @NotNull
    public Set<Map.Entry<KTo, VTo>> entrySet() {
        return new TransformingSet<Map.Entry, Map.Entry>(this.delegate.entrySet(), entry -> new AbstractMap.SimpleImmutableEntry<KTo, VTo>(this.keyFwd(entry.getKey()), this.valueFwd(entry.getValue())), entry -> new AbstractMap.SimpleImmutableEntry<KFrom, VFrom>(this.keyBack(entry.getKey()), this.valueBack(entry.getValue())));
    }

    public BiMap<VTo, KTo> inverse() {
        return new TransformingBiMap<VFrom, KFrom, VTo, KTo>(this.delegate.inverse(), this.valueFwd, this.valueBack, this.keyFwd, this.keyBack);
    }

    static class TransformingSet<TypeFrom, TypeTo>
    implements Set<TypeTo> {
        private final Set<TypeFrom> delegate;
        private final Function<TypeFrom, TypeTo> forward;
        private final Function<TypeTo, TypeFrom> reverse;

        public TransformingSet(Set<TypeFrom> set, Function<TypeFrom, TypeTo> forward, Function<TypeTo, TypeFrom> reverse) {
            this.delegate = set;
            this.forward = forward;
            this.reverse = reverse;
        }

        private TypeTo forward(TypeFrom t) {
            return t == null ? null : (TypeTo)this.forward.apply(t);
        }

        private TypeFrom reverse(TypeTo t) {
            return t == null ? null : (TypeFrom)this.reverse.apply(t);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(this.reverse(o));
        }

        @Override
        @NotNull
        public Iterator<TypeTo> iterator() {
            return Iterators.transform(this.delegate.iterator(), this::forward);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            Object[] array = this.delegate.toArray();
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.forward(array[i]);
            }
            return array;
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] ts) {
            if (ts.length >= this.delegate.size()) {
                Object[] setContents = this.toArray();
                System.arraycopy(setContents, 0, ts, 0, Math.min(setContents.length, ts.length));
                if (ts.length > setContents.length) {
                    ts[setContents.length] = null;
                }
                return ts;
            }
            T[] realArray = Arrays.copyOf(ts, this.delegate.size());
            Iterator<TypeTo> iterator = this.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                realArray[i++] = iterator.next();
            }
            return realArray;
        }

        @Override
        public boolean add(TypeTo typeFrom) {
            return this.delegate.add(this.reverse(typeFrom));
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(this.reverse(o));
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> collection) {
            return this.delegate.containsAll(Collections2.transform(collection, obj -> this.reverse(obj)));
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends TypeTo> collection) {
            return this.delegate.addAll(Collections2.transform(collection, this::reverse));
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> collection) {
            return this.delegate.retainAll(Collections2.transform(collection, obj -> this.reverse(obj)));
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> collection) {
            return this.delegate.removeAll(Collections2.transform(collection, obj -> this.reverse(obj)));
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }
    }
}

