/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.page;

import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.BookTextHolder;
import com.klikli_dev.modonomicon.book.RenderedBookTextHolder;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.util.BookGsonHelper;
import com.klikli_dev.modonomicon.util.EntityUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class BookEntityPage
extends BookPage {
    protected BookTextHolder entityName;
    protected BookTextHolder text;
    protected String entityId;
    protected float scale = 1.0f;
    protected float offset = 0.0f;
    protected boolean rotate = true;
    protected float defaultRotation = -45.0f;

    public BookEntityPage(BookTextHolder entityName, BookTextHolder text, String entityId, float scale, float offset, boolean rotate, float defaultRotation, String anchor) {
        super(anchor);
        this.entityName = entityName;
        this.text = text;
        this.entityId = entityId;
        this.scale = scale;
        this.offset = offset;
        this.rotate = rotate;
        this.defaultRotation = defaultRotation;
    }

    public static BookEntityPage fromJson(JsonObject json) {
        BookTextHolder entityName = BookGsonHelper.getAsBookTextHolder(json, "name", BookTextHolder.EMPTY);
        BookTextHolder text = BookGsonHelper.getAsBookTextHolder(json, "text", BookTextHolder.EMPTY);
        String entityId = GsonHelper.m_13906_((JsonObject)json, (String)"entity_id");
        float scale = GsonHelper.m_13820_((JsonObject)json, (String)"scale", (float)1.0f);
        float offset = GsonHelper.m_13820_((JsonObject)json, (String)"offset", (float)0.0f);
        boolean rotate = GsonHelper.m_13855_((JsonObject)json, (String)"rotate", (boolean)true);
        float defaultRotation = GsonHelper.m_13820_((JsonObject)json, (String)"default_rotation", (float)-45.0f);
        String anchor = GsonHelper.m_13851_((JsonObject)json, (String)"anchor", (String)"");
        return new BookEntityPage(entityName, text, entityId, scale, offset, rotate, defaultRotation, anchor);
    }

    public static BookEntityPage fromNetwork(FriendlyByteBuf buffer) {
        BookTextHolder entityName = BookTextHolder.fromNetwork(buffer);
        BookTextHolder text = BookTextHolder.fromNetwork(buffer);
        String entityId = buffer.m_130277_();
        float scale = buffer.readFloat();
        float offset = buffer.readFloat();
        boolean rotate = buffer.readBoolean();
        float defaultRotation = buffer.readFloat();
        String anchor = buffer.m_130277_();
        return new BookEntityPage(entityName, text, entityId, scale, offset, rotate, defaultRotation, anchor);
    }

    public String getEntityId() {
        return this.entityId;
    }

    public float getScale() {
        return this.scale;
    }

    public float getOffset() {
        return this.offset;
    }

    public boolean doesRotate() {
        return this.rotate;
    }

    public float getDefaultRotation() {
        return this.defaultRotation;
    }

    public BookTextHolder getEntityName() {
        return this.entityName;
    }

    public BookTextHolder getText() {
        return this.text;
    }

    @Override
    public ResourceLocation getType() {
        return ModonomiconConstants.Data.Page.ENTITY;
    }

    @Override
    public void build(BookEntry parentEntry, int pageNum) {
        super.build(parentEntry, pageNum);
        if (this.entityName.isEmpty()) {
            this.entityName = new BookTextHolder((Component)Component.m_237115_((String)EntityUtil.getEntityName(this.entityId)).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
    }

    @Override
    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        super.prerenderMarkdown(textRenderer);
        if (!this.entityName.hasComponent()) {
            this.entityName = new BookTextHolder((Component)Component.m_237115_((String)this.entityName.getKey()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(this.getParentEntry().getBook().getDefaultTitleColor())));
        }
        if (!this.text.hasComponent()) {
            this.text = new RenderedBookTextHolder(this.text, textRenderer.render(this.text.getString()));
        }
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        this.entityName.toNetwork(buffer);
        this.text.toNetwork(buffer);
        buffer.m_130070_(this.entityId);
        buffer.writeFloat(this.scale);
        buffer.writeFloat(this.offset);
        buffer.writeBoolean(this.rotate);
        buffer.writeFloat(this.defaultRotation);
        buffer.m_130070_(this.anchor);
    }

    @Override
    public boolean matchesQuery(String query) {
        return this.entityName.getString().toLowerCase().contains(query) || this.text.getString().toLowerCase().contains(query);
    }
}

