/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class HexidecrubrometerBlock
extends Block {
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final EnumProperty<AttachFace> READING_FACE = BlockStateProperties.f_61376_;
    public static final EnumProperty<Direction> ROTATION = BlockStateProperties.f_61374_;

    public HexidecrubrometerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_(READING_FACE, (Comparable)AttachFace.WALL)).m_61124_(ROTATION, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWER, READING_FACE, ROTATION});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction attachDirection = context.m_7820_();
        Direction horizontalDirectionAwayFromPlayer = context.m_8125_();
        AttachFace attachFace = attachDirection == Direction.DOWN ? AttachFace.FLOOR : (attachDirection == Direction.UP ? AttachFace.CEILING : AttachFace.WALL);
        Direction readingDirection = HexidecrubrometerBlock.getReadingDirection(attachFace, horizontalDirectionAwayFromPlayer);
        int power = HexidecrubrometerBlock.getInputValue(world, pos, readingDirection);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(READING_FACE, (Comparable)attachFace)).m_61124_(ROTATION, (Comparable)horizontalDirectionAwayFromPlayer.m_122424_())).m_61124_((Property)POWER, (Comparable)Integer.valueOf(power));
    }

    @Deprecated
    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.m_60734_() != this) {
            int oldPower = (Integer)state.m_61143_((Property)POWER);
            int newPower = HexidecrubrometerBlock.getInputValue(worldIn, pos, state);
            if (newPower != oldPower) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(newPower)));
            }
        }
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        if (!world.m_5776_() && pos.m_121945_(HexidecrubrometerBlock.getReadingDirection(state)).equals((Object)neighbor)) {
            state.m_60690_((Level)world, pos, world.m_8055_(neighbor).m_60734_(), neighbor, false);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        int oldValue;
        int newValue = HexidecrubrometerBlock.getInputValue(world, pos, state);
        if (newValue != (oldValue = ((Integer)state.m_61143_((Property)POWER)).intValue())) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(newValue)));
        }
    }

    public static int getInputValue(Level world, BlockPos pos, BlockState state) {
        Direction direction = HexidecrubrometerBlock.getReadingDirection(state);
        return HexidecrubrometerBlock.getInputValue(world, pos, direction);
    }

    public static int getInputValue(Level world, BlockPos pos, Direction direction) {
        BlockPos neighborPos = pos.m_121945_(direction);
        BlockState neighborState = world.m_8055_(neighborPos);
        int comparatorPower = neighborState.m_60674_(world, neighborPos);
        int canonicalRedstonePower = world.m_46681_(neighborPos, direction);
        int redstonePower = canonicalRedstonePower > 0 ? canonicalRedstonePower : (neighborState.m_60734_() instanceof RedStoneWireBlock ? (Integer)neighborState.m_61143_((Property)BlockStateProperties.f_61426_) : 0);
        return Math.max(redstonePower, comparatorPower);
    }

    public static Direction getReadingDirection(BlockState state) {
        AttachFace face = (AttachFace)state.m_61143_(READING_FACE);
        Direction directionAwayFromDisplay = ((Direction)state.m_61143_(ROTATION)).m_122424_();
        return HexidecrubrometerBlock.getReadingDirection(face, directionAwayFromDisplay);
    }

    public static Direction getReadingDirection(AttachFace attachFace, Direction directionAwayFromDisplay) {
        switch (attachFace) {
            case CEILING: {
                return Direction.UP;
            }
            case FLOOR: {
                return Direction.DOWN;
            }
            case WALL: {
                return directionAwayFromDisplay;
            }
        }
        return Direction.DOWN;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != null && side.m_122424_() == HexidecrubrometerBlock.getReadingDirection(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_(ROTATION, (Comparable)rot.m_55954_((Direction)state.m_61143_(ROTATION)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_(ROTATION, (Comparable)mirror.m_54848_((Direction)state.m_61143_(ROTATION)));
    }
}

