/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import commoble.morered.client.ClientConfig;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.lwjgl.system.MemoryStack;

public class BlockPreviewRenderer
extends ModelBlockRenderer {
    private static BlockPreviewRenderer INSTANCE;

    public static BlockPreviewRenderer getInstance(ModelBlockRenderer baseRenderer) {
        if (INSTANCE == null || BlockPreviewRenderer.INSTANCE.f_110995_ != baseRenderer.f_110995_) {
            INSTANCE = new BlockPreviewRenderer(baseRenderer);
        }
        return INSTANCE;
    }

    public BlockPreviewRenderer(ModelBlockRenderer baseRenderer) {
        super(baseRenderer.f_110995_);
    }

    public static void renderBlockPreview(BlockPos pos, BlockState state, Level level, Vec3 currentRenderPos, PoseStack matrix, MultiBufferSource renderTypeBuffer) {
        matrix.m_85836_();
        double offsetX = (double)pos.m_123341_() - currentRenderPos.m_7096_();
        double offsetY = (double)pos.m_123342_() - currentRenderPos.m_7098_();
        double offsetZ = (double)pos.m_123343_() - currentRenderPos.m_7094_();
        matrix.m_85837_(offsetX, offsetY, offsetZ);
        BlockRenderDispatcher blockDispatcher = Minecraft.m_91087_().m_91289_();
        BlockPreviewRenderer renderer = BlockPreviewRenderer.getInstance(blockDispatcher.m_110937_());
        renderer.tesselateBlock((BlockAndTintGetter)level, blockDispatcher.m_110910_(state), state, pos, matrix, renderTypeBuffer.m_6299_(Sheets.m_110792_()), false, level.f_46441_, state.m_60726_(pos), OverlayTexture.f_118083_, ModelData.EMPTY, RenderType.m_110466_());
        matrix.m_85849_();
    }

    public void m_111023_(BlockAndTintGetter level, BlockState state, BlockPos pos, VertexConsumer buffer, PoseStack.Pose matrixEntry, BakedQuad quadIn, float tintA, float tintB, float tintC, float tintD, int brightness0, int brightness1, int brightness2, int brightness3, int combinedOverlayIn) {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (quadIn.m_111304_()) {
            int i = this.f_110995_.m_92577_(state, level, pos, quadIn.m_111305_());
            r = (float)(i >> 16 & 0xFF) / 255.0f;
            g = (float)(i >> 8 & 0xFF) / 255.0f;
            b = (float)(i & 0xFF) / 255.0f;
        }
        if (quadIn.m_111307_()) {
            float shade = level.m_7717_(quadIn.m_111306_(), true);
            r *= shade;
            g *= shade;
            b *= shade;
        }
        BlockPreviewRenderer.addTransparentQuad(matrixEntry, quadIn, new float[]{tintA, tintB, tintC, tintD}, r, g, b, new int[]{brightness0, brightness1, brightness2, brightness3}, combinedOverlayIn, true, buffer);
    }

    public static void addTransparentQuad(PoseStack.Pose matrixEntry, BakedQuad quad, float[] colorMuls, float r, float g, float b, int[] vertexLights, int combinedOverlayIn, boolean mulColor, VertexConsumer buffer) {
        int[] vertexData = quad.m_111303_();
        Vec3i faceVector3i = quad.m_111306_().m_122436_();
        Vector3f faceVector = new Vector3f((float)faceVector3i.m_123341_(), (float)faceVector3i.m_123342_(), (float)faceVector3i.m_123343_());
        Matrix4f matrix = matrixEntry.m_85861_();
        faceVector.m_122249_(matrixEntry.m_85864_());
        int vertexDataEntries = vertexData.length / 8;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int vertexIndex = 0; vertexIndex < vertexDataEntries; ++vertexIndex) {
                ((Buffer)intbuffer).clear();
                intbuffer.put(vertexData, vertexIndex * 8, 8);
                float x = bytebuffer.getFloat(0);
                float y = bytebuffer.getFloat(4);
                float z = bytebuffer.getFloat(8);
                float red = colorMuls[vertexIndex] * r;
                float green = colorMuls[vertexIndex] * g;
                float blue = colorMuls[vertexIndex] * b;
                if (mulColor) {
                    float redMultiplier = (float)(bytebuffer.get(12) & 0xFF) / 255.0f;
                    float greenMultiplier = (float)(bytebuffer.get(13) & 0xFF) / 255.0f;
                    float blueMultiplier = (float)(bytebuffer.get(14) & 0xFF) / 255.0f;
                    red = redMultiplier * red;
                    green = greenMultiplier * green;
                    blue = blueMultiplier * blue;
                }
                float alpha = ((Double)ClientConfig.INSTANCE.previewPlacementOpacity().get()).floatValue();
                int light = buffer.applyBakedLighting(vertexLights[vertexIndex], bytebuffer);
                float texU = bytebuffer.getFloat(16);
                float texV = bytebuffer.getFloat(20);
                Vector4f posVector = new Vector4f(x, y, z, 1.0f);
                posVector.m_123607_(matrix);
                buffer.applyBakedNormals(faceVector, bytebuffer, matrixEntry.m_85864_());
                buffer.m_5954_(posVector.m_123601_(), posVector.m_123615_(), posVector.m_123616_(), red, green, blue, alpha, texU, texV, combinedOverlayIn, light, faceVector.m_122239_(), faceVector.m_122260_(), faceVector.m_122269_());
            }
        }
    }
}

