/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import commoble.morered.MoreRed;
import commoble.morered.client.BlockPreviewRenderer;
import commoble.morered.client.BundledCablePostRenderer;
import commoble.morered.client.ClientConfig;
import commoble.morered.client.ClientProxy;
import commoble.morered.client.ColorHandlers;
import commoble.morered.client.GatecraftingScreen;
import commoble.morered.client.TintRotatingModelLoader;
import commoble.morered.client.WirePartModelLoader;
import commoble.morered.client.WirePostRenderer;
import commoble.morered.mixin.MultiPlayerGameModeAccess;
import commoble.morered.plate_blocks.LatchBlock;
import commoble.morered.plate_blocks.LogicFunctionPlateBlock;
import commoble.morered.plate_blocks.PlateBlock;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.util.BlockStateUtil;
import commoble.morered.wire_post.WirePostBlock;
import commoble.morered.wire_post.WirePostPlateBlock;
import commoble.morered.wires.AbstractWireBlock;
import commoble.morered.wires.ColoredCableBlock;
import commoble.morered.wires.RedAlloyWireBlock;
import commoble.morered.wires.VoxelCache;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;

public class ClientEvents {
    public static void addClientListeners(ModLoadingContext modContext, FMLJavaModLoadingContext fmlContext, IEventBus modBus, IEventBus forgeBus) {
        ClientConfig.initClientConfig();
        modBus.addListener(ClientEvents::onClientSetup);
        modBus.addListener(ClientEvents::onRegisterModelLoaders);
        modBus.addListener(ClientEvents::onRegisterBlockColors);
        modBus.addListener(ClientEvents::onRegisterItemColors);
        modBus.addListener(ClientEvents::onRegisterRenderers);
        modBus.addListener(ClientEvents::onModelBakingCompleted);
        forgeBus.addListener(ClientEvents::onClientLogIn);
        forgeBus.addListener(ClientEvents::onClientLogOut);
        forgeBus.addListener(ClientEvents::onHighlightBlock);
        forgeBus.addListener(ClientEvents::onInteract);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        MoreRed.instance().logicPlates.values().forEach(rob -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)rob.get()), (RenderType)RenderType.m_110463_()));
        MoreRed.instance().bitwiseLogicPlates.values().forEach(rob -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)rob.get()), (RenderType)RenderType.m_110463_()));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)MoreRed.instance().latchBlock.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)MoreRed.instance().redwirePostPlateBlock.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)MoreRed.instance().redwirePostRelayPlateBlock.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)MoreRed.instance().bundledCableRelayPlateBlock.get()), (RenderType)RenderType.m_110463_());
        event.enqueueWork(ClientEvents::afterClientSetup);
    }

    static void afterClientSetup() {
        MenuScreens.m_96206_((MenuType)((MenuType)MoreRed.instance().gatecraftingMenuType.get()), GatecraftingScreen::new);
    }

    public static void onRegisterModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("wire_parts", (IGeometryLoader)WirePartModelLoader.INSTANCE);
        event.register("rotate_tints", (IGeometryLoader)TintRotatingModelLoader.INSTANCE);
    }

    public static void onRegisterBlockColors(RegisterColorHandlersEvent.Block event) {
        MoreRed.instance().logicPlates.values().forEach(rob -> event.register(ColorHandlers::getLogicFunctionBlockTint, new Block[]{(Block)rob.get()}));
        event.register(ColorHandlers::getLatchBlockTint, new Block[]{(Block)MoreRed.instance().latchBlock.get()});
        event.register(ColorHandlers::getRedwirePostBlockTint, new Block[]{(Block)MoreRed.instance().redwirePostBlock.get()});
        event.register(ColorHandlers::getRedwirePostBlockTint, new Block[]{(Block)MoreRed.instance().redwirePostPlateBlock.get()});
        event.register(ColorHandlers::getRedwirePostBlockTint, new Block[]{(Block)MoreRed.instance().redwirePostRelayPlateBlock.get()});
        event.register(ColorHandlers::getRedAlloyWireBlockTint, new Block[]{(Block)MoreRed.instance().redAlloyWireBlock.get()});
    }

    public static void onRegisterItemColors(RegisterColorHandlersEvent.Item event) {
        MoreRed.instance().logicPlates.values().forEach(rob -> event.register(ColorHandlers::getLogicFunctionBlockItemTint, new ItemLike[]{((LogicFunctionPlateBlock)((Object)((Object)rob.get()))).m_5456_()}));
        event.register(ColorHandlers::getLatchItemTint, new ItemLike[]{((LatchBlock)((Object)MoreRed.instance().latchBlock.get())).m_5456_()});
        event.register(ColorHandlers::getRedwirePostItemTint, new ItemLike[]{((WirePostBlock)((Object)MoreRed.instance().redwirePostBlock.get())).m_5456_()});
        event.register(ColorHandlers::getRedwirePostItemTint, new ItemLike[]{((WirePostPlateBlock)((Object)MoreRed.instance().redwirePostPlateBlock.get())).m_5456_()});
        event.register(ColorHandlers::getRedwirePostItemTint, new ItemLike[]{((WirePostPlateBlock)((Object)MoreRed.instance().redwirePostRelayPlateBlock.get())).m_5456_()});
        event.register(ColorHandlers::getRedAlloyWireItemTint, new ItemLike[]{((RedAlloyWireBlock)((Object)MoreRed.instance().redAlloyWireBlock.get())).m_5456_()});
    }

    private static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)MoreRed.instance().redwirePostBeType.get(), WirePostRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)MoreRed.instance().bundledCablePostBeType.get(), BundledCablePostRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)MoreRed.instance().bundledCableRelayPlateBeType.get(), BundledCablePostRenderer::new);
    }

    @Deprecated
    private static void onModelBakingCompleted(ModelEvent.BakingCompleted event) {
        Map models = event.getModels();
        Consumer<RegistryObject> modelCheeser = rob -> {
            for (BlockState state : ((Block)rob.get()).m_49965_().m_61056_()) {
                ModelResourceLocation mrl = BlockModelShaper.m_110895_((BlockState)state);
                BakedModel model = (BakedModel)models.get(mrl);
                if (model == null) continue;
                models.put(mrl, new WirePartModelLoader.MultipartWireModel(model));
            }
        };
        modelCheeser.accept(MoreRed.instance().redAlloyWireBlock);
        modelCheeser.accept(MoreRed.instance().bundledNetworkCableBlock);
        for (RegistryObject<ColoredCableBlock> rob2 : MoreRed.instance().networkCableBlocks) {
            modelCheeser.accept(rob2);
        }
    }

    private static void onClientLogIn(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientProxy.clear();
        VoxelCache.clearClientCache();
    }

    private static void onClientLogOut(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientProxy.clear();
        VoxelCache.clearClientCache();
    }

    private static void onHighlightBlock(RenderHighlightEvent.Block event) {
        BlockItem blockItem;
        Block block;
        InteractionHand hand;
        Item item;
        LocalPlayer player;
        if (((Boolean)ClientConfig.INSTANCE.showPlacementPreview().get()).booleanValue() && (player = Minecraft.m_91087_().f_91074_) != null && player.f_19853_ != null && (item = player.m_21120_((hand = player.m_7655_()) == null ? InteractionHand.MAIN_HAND : hand).m_41720_()) instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof PlateBlock) {
            Level world = player.f_19853_;
            BlockHitResult rayTrace = event.getTarget();
            Direction directionAwayFromTargetedBlock = rayTrace.m_82434_();
            BlockPos placePos = rayTrace.m_82425_().m_121945_(directionAwayFromTargetedBlock);
            BlockState existingState = world.m_8055_(placePos);
            if (existingState.m_60795_() || existingState.m_60767_().m_76336_()) {
                Vec3 hitVec = rayTrace.m_82450_();
                Direction attachmentDirection = directionAwayFromTargetedBlock.m_122424_();
                Vec3 relativeHitVec = hitVec.m_82546_(Vec3.m_82528_((Vec3i)placePos));
                Direction outputDirection = BlockStateUtil.getOutputDirectionFromRelativeHitVec(relativeHitVec, attachmentDirection);
                BlockStateUtil.getRotationIndexForDirection(attachmentDirection, outputDirection);
                BlockState state = PlateBlockStateProperties.getStateForPlacedGatePlate(block.m_49966_(), placePos, attachmentDirection, relativeHitVec);
                BlockPreviewRenderer.renderBlockPreview(placePos, state, world, event.getCamera().m_90583_(), event.getPoseStack(), event.getMultiBufferSource());
            }
        }
    }

    public static void onInteract(InputEvent.InteractionKeyMappingTriggered event) {
        BlockHitResult blockResult;
        BlockPos pos;
        BlockState state;
        Block block;
        Minecraft mc = Minecraft.m_91087_();
        HitResult rayTraceResult = mc.f_91077_;
        ClientLevel world = mc.f_91073_;
        LocalPlayer player = mc.f_91074_;
        if (rayTraceResult != null && rayTraceResult.m_82450_() != null && world != null && event.isAttack() && player != null && rayTraceResult.m_6662_() == HitResult.Type.BLOCK && (block = (state = world.m_8055_(pos = (blockResult = (BlockHitResult)rayTraceResult).m_82425_())).m_60734_()) instanceof AbstractWireBlock) {
            event.setCanceled(true);
            AbstractWireBlock wireBlock = (AbstractWireBlock)block;
            MultiPlayerGameMode controller = mc.f_91072_;
            MultiPlayerGameModeAccess controllerAccess = (MultiPlayerGameModeAccess)controller;
            GameType gameType = controller.m_105295_();
            if (player.m_36187_((Level)world, pos, gameType)) {
                return;
            }
            if (!world.m_6857_().m_61937_(pos)) {
                return;
            }
            Direction faceToBreak = wireBlock.getInteriorFaceToBreak(state, pos, (Player)player, blockResult, mc.m_91296_());
            if (faceToBreak == null) {
                return;
            }
            Direction hitNormal = faceToBreak.m_122424_();
            if (gameType.m_46408_()) {
                Minecraft.m_91087_().m_91403_().m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, pos, hitNormal));
                if (!ForgeHooks.onLeftClickBlock((Player)player, (BlockPos)pos, (Direction)hitNormal).isCanceled()) {
                    ClientEvents.destroyClickedWireBlock(wireBlock, state, world, pos, player, controllerAccess, faceToBreak);
                }
                controllerAccess.setDestroyDelay(5);
            } else if (!controller.m_105296_() || !controllerAccess.callSameDestroyTarget(pos)) {
                if (controller.m_105296_()) {
                    Minecraft.m_91087_().m_91403_().m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, controllerAccess.getDestroyBlockPos(), blockResult.m_82434_()));
                }
                PlayerInteractEvent.LeftClickBlock leftClickBlockEvent = ForgeHooks.onLeftClickBlock((Player)player, (BlockPos)pos, (Direction)hitNormal);
                Minecraft.m_91087_().m_91403_().m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, pos, hitNormal));
                if (!leftClickBlockEvent.isCanceled() && leftClickBlockEvent.getUseItem() != Event.Result.DENY) {
                    ClientEvents.destroyClickedWireBlock(wireBlock, state, world, pos, player, controllerAccess, faceToBreak);
                }
            }
        }
    }

    private static void destroyClickedWireBlock(AbstractWireBlock block, BlockState state, ClientLevel world, BlockPos pos, LocalPlayer player, MultiPlayerGameModeAccess controllerAccess, Direction interiorSide) {
        ItemStack heldItemStack = player.m_21205_();
        if (heldItemStack.onBlockStartBreak(pos, (Player)player)) {
            return;
        }
        if (!heldItemStack.m_41720_().m_6777_(state, (Level)world, pos, (Player)player)) {
            return;
        }
        controllerAccess.setIsDestroying(false);
        block.destroyClickedSegment(state, (Level)world, pos, (Player)player, interiorSide, false);
        controllerAccess.setDestroyProgress(0.0f);
        controllerAccess.setDestroyTicks(0.0f);
    }
}

