/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.multipiston;

import com.google.common.primitives.Ints;
import com.ldtteam.multipiston.ModTileEntities;
import com.ldtteam.structurize.api.util.IRotatableBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityMultiPiston
extends BlockEntity
implements IRotatableBlockEntity {
    public static final String TAG_INPUT = "input";
    public static final String TAG_RANGE = "range";
    public static final String TAG_DIRECTION = "direction";
    public static final String TAG_LENGTH = "length";
    public static final String TAG_PROGRESS = "progress";
    public static final String TAG_OUTPUT_DIRECTION = "outputDirection";
    public static final String TAG_SPEED = "speed";
    public static final double VOLUME = 0.5;
    public static final double PITCH = 0.8;
    private static final int MAX_RANGE = 10;
    private static final int MAX_SPEED = 3;
    private static final int MIN_SPEED = 1;
    public static final int DEFAULT_RANGE = 3;
    public static final int DEFAULT_SPEED = 2;
    private boolean on = false;
    private Direction input = Direction.UP;
    private Direction output = Direction.DOWN;
    private int range = 3;
    private Direction currentDirection;
    private int progress = 0;
    private int ticksPassed = 0;
    private int speed = 2;

    public TileEntityMultiPiston(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.multipiston.get(), pos, state);
    }

    public void handleRedstone(boolean signal) {
        if (this.speed == 0) {
            this.speed = 2;
        }
        if (signal != this.on && this.progress == this.range) {
            this.on = signal;
            this.currentDirection = signal ? this.output : this.input;
            this.progress = 0;
        }
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.currentDirection == null && this.progress < this.range) {
            this.progress = this.range;
        }
        if (this.progress < this.range) {
            if (this.ticksPassed % (20 / this.speed) == 0) {
                this.handleTick();
                this.ticksPassed = 1;
            }
            ++this.ticksPassed;
        }
    }

    public void handleTick() {
        Direction currentOutPutDirection;
        Direction direction = currentOutPutDirection = this.currentDirection == this.input ? this.output : this.input;
        if (this.progress < this.range) {
            BlockState blockToMove = this.f_58857_.m_8055_(this.f_58858_.m_5484_(this.currentDirection, 1));
            if (blockToMove.m_60734_() == Blocks.f_50016_ || blockToMove.m_60811_() == PushReaction.IGNORE || blockToMove.m_60811_() == PushReaction.DESTROY || blockToMove.m_60811_() == PushReaction.BLOCK || blockToMove.m_60734_() instanceof EntityBlock && !ForgeRegistries.BLOCKS.getKey((Object)blockToMove.m_60734_()).m_135827_().equals("domum_ornamentum") || blockToMove.m_60734_() == Blocks.f_50752_) {
                ++this.progress;
                return;
            }
            for (int i = 0; i < Math.min(this.range, 10); ++i) {
                BlockEntity blockEntity;
                BlockPos posToGoFrom;
                int blockToGoTo = i - 1 - this.progress + (i - 1 - this.progress >= 0 ? 1 : 0);
                int blockToGoFrom = i + 1 - this.progress - (i + 1 - this.progress <= 0 ? 1 : 0);
                BlockPos posToGo = blockToGoTo > 0 ? this.f_58858_.m_5484_(this.currentDirection, blockToGoTo) : this.f_58858_.m_5484_(currentOutPutDirection, Math.abs(blockToGoTo));
                BlockPos blockPos = posToGoFrom = blockToGoFrom > 0 ? this.f_58858_.m_5484_(this.currentDirection, blockToGoFrom) : this.f_58858_.m_5484_(currentOutPutDirection, Math.abs(blockToGoFrom));
                if (!this.f_58857_.m_46859_(posToGo) && !this.f_58857_.m_8055_(posToGo).m_60767_().m_76332_()) continue;
                BlockState tempState = this.f_58857_.m_8055_(posToGoFrom);
                if (blockToMove.m_60734_() != tempState.m_60734_() || !this.f_58857_.m_46805_(posToGoFrom) || !this.f_58857_.m_46805_(posToGo)) continue;
                this.pushEntitiesIfNecessary(posToGo, this.f_58858_);
                tempState = Block.m_49931_((BlockState)tempState, (LevelAccessor)this.f_58857_, (BlockPos)posToGo);
                this.f_58857_.m_7731_(posToGo, tempState, 67);
                if (tempState.m_60734_() instanceof BucketPickup) {
                    ((BucketPickup)tempState.m_60734_()).m_142598_((LevelAccessor)this.f_58857_, posToGo, tempState);
                }
                this.f_58857_.m_46586_(posToGo, tempState.m_60734_(), posToGo);
                if (tempState.m_60734_() instanceof EntityBlock && (blockEntity = this.f_58857_.m_7702_(posToGoFrom)) != null) {
                    CompoundTag tag = blockEntity.m_187481_();
                    BlockEntity resultEntity = this.f_58857_.m_7702_(posToGo);
                    if (resultEntity != null) {
                        resultEntity.m_142466_(tag);
                    }
                }
                this.f_58857_.m_7471_(posToGoFrom, false);
            }
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12312_, SoundSource.BLOCKS, 0.5f, 0.8f);
            ++this.progress;
        }
    }

    private void pushEntitiesIfNecessary(BlockPos posToGo, BlockPos pos) {
        List entities = this.f_58857_.m_45976_(Entity.class, new AABB(posToGo));
        BlockPos vector = posToGo.m_121996_((Vec3i)pos);
        BlockPos posTo = posToGo.m_121945_(Direction.m_122372_((float)vector.m_123341_(), (float)vector.m_123342_(), (float)vector.m_123343_()));
        for (Entity entity : entities) {
            entity.m_6021_((double)posTo.m_123341_() + 0.5, (double)posTo.m_123342_() + 0.5, (double)posTo.m_123343_() + 0.5);
        }
    }

    public void rotate(Rotation rotationIn) {
        if (this.output != Direction.UP && this.output != Direction.DOWN) {
            this.output = rotationIn.m_55954_(this.output);
        }
        if (this.input != Direction.UP && this.input != Direction.DOWN) {
            this.input = rotationIn.m_55954_(this.input);
        }
    }

    public void mirror(Mirror mirrorIn) {
        if (this.output != Direction.UP && this.output != Direction.DOWN) {
            this.output = mirrorIn.m_54848_(this.output);
        }
        if (this.input != Direction.UP && this.input != Direction.DOWN) {
            this.input = mirrorIn.m_54848_(this.input);
        }
    }

    public boolean isOn() {
        return this.on;
    }

    public Direction getInput() {
        return this.input;
    }

    public Direction getOutput() {
        return this.output;
    }

    public void setInput(Direction direction) {
        this.input = direction;
    }

    public void setOutput(Direction output) {
        this.output = output;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = Math.min(range, 10);
        this.progress = range;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = Ints.constrainToRange((int)speed, (int)1, (int)3);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.range = compound.m_128451_(TAG_RANGE);
        this.progress = compound.m_128451_(TAG_PROGRESS);
        this.input = Direction.values()[compound.m_128451_(TAG_DIRECTION)];
        this.on = compound.m_128471_(TAG_INPUT);
        this.output = compound.m_128431_().contains(TAG_OUTPUT_DIRECTION) ? Direction.values()[compound.m_128451_(TAG_OUTPUT_DIRECTION)] : this.input.m_122424_();
        this.speed = compound.m_128451_(TAG_SPEED);
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_(TAG_RANGE, this.range);
        compound.m_128405_(TAG_PROGRESS, this.progress);
        compound.m_128405_(TAG_DIRECTION, this.input.ordinal());
        compound.m_128379_(TAG_INPUT, this.on);
        if (this.output != null) {
            compound.m_128405_(TAG_OUTPUT_DIRECTION, this.output.ordinal());
        }
        compound.m_128405_(TAG_SPEED, this.speed);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }
}

