/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.starfish_studios.naturalist.entity.ai.goal.FlyingWanderGoal;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.NaturalistRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Butterfly
extends Animal
implements IAnimatable,
FlyingAnimal {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final EntityDataAccessor<Boolean> HAS_NECTAR = SynchedEntityData.m_135353_(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int numCropsGrownSincePollination;

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public Butterfly(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, pLevel){

            public boolean m_6342_(BlockPos pPos) {
                return !this.f_26495_.m_8055_(pPos.m_7495_()).m_60795_();
            }
        };
        navigation.m_26440_(false);
        navigation.m_7008_(false);
        navigation.m_26443_(true);
        return navigation;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_NECTAR, (Object)false);
    }

    public boolean hasNectar() {
        return (Boolean)this.f_19804_.m_135370_(HAS_NECTAR);
    }

    void setHasNectar(boolean hasNectar) {
        this.f_19804_.m_135381_(HAS_NECTAR, (Object)hasNectar);
    }

    public float m_5610_(BlockPos pPos, LevelReader pLevel) {
        return pLevel.m_8055_(pPos).m_60795_() ? 10.0f : 0.0f;
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_204117_(ItemTags.f_13149_);
    }

    int getCropsGrownSincePollination() {
        return this.numCropsGrownSincePollination;
    }

    private void resetNumCropsGrownSincePollination() {
        this.numCropsGrownSincePollination = 0;
    }

    void incrementNumCropsGrownSincePollination() {
        ++this.numCropsGrownSincePollination;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_((TagKey)ItemTags.f_13149_), false));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new ButterflyGrowCropGoal(this, 1.0, 16, 4));
        this.f_21345_.m_25352_(5, (Goal)new ButterflyPollinateGoal(this, 1.0, 16, 4));
        this.f_21345_.m_25352_(6, (Goal)new FlyingWanderGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(7, (Goal)new FloatGoal((Mob)this));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getCropsGrownSincePollination() >= 10) {
            this.resetNumCropsGrownSincePollination();
            this.setHasNectar(false);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasNectar() && this.getCropsGrownSincePollination() < 10 && this.f_19796_.m_188501_() < 0.05f) {
            for (int i = 0; i < this.f_19796_.m_188503_(2) + 1; ++i) {
                this.spawnFluidParticle(this.f_19853_, this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5), (ParticleOptions)ParticleTypes.f_123782_);
            }
        }
    }

    private void spawnFluidParticle(Level level, double x1, double x2, double z1, double z2, double y, ParticleOptions particleOptions) {
        level.m_7106_(particleOptions, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)x1, (double)x2), y, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)z1, (double)z2), 0.0, 0.0, 0.0);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)NaturalistEntityTypes.CATERPILLAR.get().m_20615_((Level)level);
    }

    public boolean m_6162_() {
        return false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_29443_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("butterfly.fly"));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(5.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_142039_() {
        return this.m_29443_() && this.f_19797_ % Mth.m_14167_((float)1.4959966f) == 0;
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.5f;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
    }

    static class ButterflyGrowCropGoal
    extends MoveToBlockGoal {
        private final Butterfly butterfly;

        public ButterflyGrowCropGoal(Butterfly pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((PathfinderMob)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.butterfly = pMob;
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            CropBlock cropBlock;
            BlockState state = pLevel.m_8055_(pPos);
            Block block = state.m_60734_();
            return block instanceof CropBlock && (Integer)state.m_61143_((Property)(cropBlock = (CropBlock)block).m_7959_()) < cropBlock.m_7419_();
        }

        public void m_8037_() {
            BlockPos blockpos = this.m_6669_();
            if (!blockpos.m_203195_((Position)this.f_25598_.m_20182_(), this.m_8052_())) {
                ++this.f_25601_;
                if (this.m_8064_()) {
                    this.f_25598_.m_21573_().m_26519_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, this.f_25599_);
                }
            } else {
                this.onReachedTarget();
            }
        }

        protected void onReachedTarget() {
            BlockState state = this.butterfly.f_19853_.m_8055_(this.f_25602_);
            Block block = state.m_60734_();
            if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                cropBlock.m_52263_(this.butterfly.f_19853_, this.f_25602_, state);
                this.butterfly.incrementNumCropsGrownSincePollination();
                this.m_8041_();
            }
        }

        public boolean m_8036_() {
            return this.butterfly.hasNectar() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.butterfly.hasNectar() && super.m_8045_();
        }
    }

    static class ButterflyPollinateGoal
    extends MoveToBlockGoal {
        protected int ticksWaited;
        private final Butterfly butterfly;

        public ButterflyPollinateGoal(Butterfly pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((PathfinderMob)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.butterfly = pMob;
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            return pLevel.m_8055_(pPos).m_204336_(BlockTags.f_13041_) || pLevel.m_8055_(pPos).m_60713_(NaturalistRegistry.CATTAIL.get());
        }

        public void m_8037_() {
            if (this.m_25625_()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            }
            super.m_8037_();
        }

        protected void onReachedTarget() {
            BlockState state = this.butterfly.f_19853_.m_8055_(this.f_25602_);
            if (state.m_204336_(BlockTags.f_13041_)) {
                this.butterfly.setHasNectar(true);
                this.m_8041_();
            }
        }

        public boolean m_8036_() {
            return !this.butterfly.hasNectar() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.butterfly.hasNectar() && super.m_8045_();
        }

        public void m_8056_() {
            this.ticksWaited = 0;
            super.m_8056_();
        }
    }
}

