/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.starfish_studios.naturalist.entity.HidingAnimal;
import com.starfish_studios.naturalist.entity.ai.goal.HideGoal;
import com.starfish_studios.naturalist.registry.NaturalistRegistry;
import com.starfish_studios.naturalist.registry.NaturalistSoundEvents;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.SoundKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Snail
extends Animal
implements IAnimatable,
Bucketable,
HidingAnimal {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(Snail.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Snail(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, (double)0.06f);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, new HideGoal<Snail>(this));
        this.f_21345_.m_25352_(1, (Goal)new SnailStrollGoal((PathfinderMob)this, 1.0, 0.0f));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }

    public boolean m_6898_(ItemStack pStack) {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        for (Player player : this.f_19853_.m_45976_(Player.class, this.m_20191_())) {
            if (player.m_20096_() || EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44967_, (LivingEntity)player) != 0 || this.m_8077_()) continue;
            this.m_6469_(DamageSource.m_19344_((Player)player), 5.0f);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_27497_(pCompound.m_128471_("FromBucket"));
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        return Snail.bucketMobPickup(pPlayer, pHand, this).orElse(super.m_6071_(pPlayer, pHand));
    }

    static <T extends LivingEntity> Optional<InteractionResult> bucketMobPickup(Player player, InteractionHand hand, T entity) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42446_ && entity.m_6084_()) {
            entity.m_5496_(((Bucketable)entity).m_142623_(), 1.0f, 1.0f);
            ItemStack bucketStack = ((Bucketable)entity).m_28282_();
            ((Bucketable)entity).m_6872_(bucketStack);
            ItemStack resultStack = ItemUtils.m_41817_((ItemStack)stack, (Player)player, (ItemStack)bucketStack, (boolean)false);
            player.m_21008_(hand, resultStack);
            Level level = entity.f_19853_;
            if (!level.f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucketStack);
            }
            entity.m_146870_();
            return Optional.of(InteractionResult.m_19078_((boolean)level.f_46443_));
        }
        return Optional.empty();
    }

    public void m_6872_(ItemStack stack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)stack);
    }

    public void m_142278_(CompoundTag tag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)NaturalistRegistry.SNAIL_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return NaturalistSoundEvents.BUCKET_FILL_SNAIL.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return NaturalistSoundEvents.SNAIL_CRUSH.get();
    }

    @Override
    public boolean canHide() {
        List players = this.f_19853_.m_45955_(TargetingConditions.m_148353_().m_26883_(5.0).m_26888_(EntitySelector.f_20406_::test), (LivingEntity)this, this.m_20191_().m_82377_(5.0, 3.0, 5.0));
        return !players.isEmpty();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.canHide()) {
            event.getController().setAnimation(new AnimationBuilder().loop("snail.retreat"));
        } else {
            event.getController().setAnimation(new AnimationBuilder().loop("snail.move"));
        }
        return PlayState.CONTINUE;
    }

    private void soundListener(SoundKeyframeEvent<Snail> event) {
        Snail snail = (Snail)event.getEntity();
        if (snail.f_19853_.f_46443_) {
            if (event.sound.equals("forward")) {
                snail.f_19853_.m_7785_(snail.m_20185_(), snail.m_20186_(), snail.m_20189_(), NaturalistSoundEvents.SNAIL_FORWARD.get(), snail.m_5720_(), 0.5f, 1.0f, false);
            }
            if (event.sound.equals("back")) {
                snail.f_19853_.m_7785_(snail.m_20185_(), snail.m_20186_(), snail.m_20189_(), NaturalistSoundEvents.SNAIL_BACK.get(), snail.m_5720_(), 0.5f, 1.0f, false);
            }
        }
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(10.0);
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate);
        controller.registerSoundListener(this::soundListener);
        data.addAnimationController(controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class SnailStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        public SnailStrollGoal(PathfinderMob pMob, double pSpeedModifier, float pProbability) {
            super(pMob, pSpeedModifier, pProbability);
            this.f_25731_ = true;
            this.f_25730_ = 1;
        }
    }
}

