/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.block;

import com.starfish_studios.naturalist.entity.Butterfly;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChrysalisBlock
extends HorizontalDirectionalBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    protected static final VoxelShape[] EAST_AABB = new VoxelShape[]{Block.m_49796_((double)11.0, (double)7.0, (double)6.0, (double)15.0, (double)12.0, (double)10.0), Block.m_49796_((double)9.0, (double)5.0, (double)5.0, (double)15.0, (double)12.0, (double)11.0), Block.m_49796_((double)7.0, (double)3.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0), Block.m_49796_((double)7.0, (double)3.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0)};
    protected static final VoxelShape[] WEST_AABB = new VoxelShape[]{Block.m_49796_((double)1.0, (double)7.0, (double)6.0, (double)5.0, (double)12.0, (double)10.0), Block.m_49796_((double)1.0, (double)5.0, (double)5.0, (double)7.0, (double)12.0, (double)11.0), Block.m_49796_((double)1.0, (double)3.0, (double)4.0, (double)9.0, (double)12.0, (double)12.0), Block.m_49796_((double)1.0, (double)3.0, (double)4.0, (double)9.0, (double)12.0, (double)12.0)};
    protected static final VoxelShape[] NORTH_AABB = new VoxelShape[]{Block.m_49796_((double)6.0, (double)7.0, (double)1.0, (double)10.0, (double)12.0, (double)5.0), Block.m_49796_((double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)12.0, (double)7.0), Block.m_49796_((double)4.0, (double)3.0, (double)1.0, (double)12.0, (double)12.0, (double)9.0), Block.m_49796_((double)4.0, (double)3.0, (double)1.0, (double)12.0, (double)12.0, (double)9.0)};
    protected static final VoxelShape[] SOUTH_AABB = new VoxelShape[]{Block.m_49796_((double)6.0, (double)7.0, (double)11.0, (double)10.0, (double)12.0, (double)15.0), Block.m_49796_((double)5.0, (double)5.0, (double)9.0, (double)11.0, (double)12.0, (double)15.0), Block.m_49796_((double)4.0, (double)3.0, (double)7.0, (double)12.0, (double)12.0, (double)15.0), Block.m_49796_((double)4.0, (double)3.0, (double)7.0, (double)12.0, (double)12.0, (double)15.0)};

    public ChrysalisBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_6724_(BlockState pState) {
        return true;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int age = (Integer)pState.m_61143_((Property)AGE);
        if (age < 3) {
            if (pLevel.f_46441_.m_188503_(5) == 0) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            }
        } else {
            pLevel.m_7471_(pPos, false);
            pLevel.m_5594_(null, pPos, SoundEvents.f_12630_, SoundSource.BLOCKS, 0.7f, 0.9f + pRandom.m_188501_() * 0.2f);
            pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
            Butterfly butterfly = (Butterfly)NaturalistEntityTypes.BUTTERFLY.get().m_20615_((Level)pLevel);
            assert (butterfly != null);
            butterfly.setVariant(Butterfly.Variant.getTypeById(pRandom.m_188503_(5)));
            butterfly.m_7678_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 0.0f, 0.0f);
            pLevel.m_7967_((Entity)butterfly);
        }
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState facingState = pLevel.m_8055_(pPos.m_121945_((Direction)pState.m_61143_((Property)f_54117_)));
        return facingState.m_204336_(BlockTags.f_13106_);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int age = (Integer)pState.m_61143_((Property)AGE);
        switch ((Direction)pState.m_61143_((Property)f_54117_)) {
            case SOUTH: {
                return SOUTH_AABB[age];
            }
            default: {
                return NORTH_AABB[age];
            }
            case WEST: {
                return WEST_AABB[age];
            }
            case EAST: 
        }
        return EAST_AABB[age];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState state = this.m_49966_();
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        for (Direction direction : pContext.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(state = (BlockState)state.m_61124_((Property)f_54117_, (Comparable)direction)).m_60710_((LevelReader)level, pos)) continue;
            return state;
        }
        return null;
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing == pState.m_61143_((Property)f_54117_) && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, AGE});
    }
}

