/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.entity.Elephant;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class ElephantModel
extends AnimatedGeoModel<Elephant> {
    public ResourceLocation getModelResource(Elephant elephant) {
        return new ResourceLocation("naturalist", "geo/elephant.geo.json");
    }

    public ResourceLocation getTextureResource(Elephant elephant) {
        return new ResourceLocation("naturalist", "textures/entity/elephant.png");
    }

    public ResourceLocation getAnimationResource(Elephant elephant) {
        return new ResourceLocation("naturalist", "animations/elephant.animation.json");
    }

    public void setLivingAnimations(Elephant elephant, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)elephant, uniqueID, customPredicate);
        if (customPredicate == null) {
            return;
        }
        List extraDataOfType = customPredicate.getExtraDataOfType(EntityModelData.class);
        IBone head = this.getAnimationProcessor().getBone("head");
        IBone bigTusks = this.getAnimationProcessor().getBone("tusks");
        IBone smallTusks = this.getAnimationProcessor().getBone("baby_tusks");
        IBone babyTrunk = this.getAnimationProcessor().getBone("trunk4");
        if (elephant.m_6162_()) {
            head.setScaleX(1.5f);
            head.setScaleY(1.5f);
            head.setScaleZ(1.5f);
        } else {
            head.setScaleX(1.0f);
            head.setScaleY(1.0f);
            head.setScaleZ(1.0f);
        }
        bigTusks.setHidden(elephant.m_6162_());
        smallTusks.setHidden(elephant.m_6162_());
        smallTusks.setHidden(!elephant.m_6162_());
        babyTrunk.setHidden(elephant.m_6162_());
        head.setRotationY(((EntityModelData)extraDataOfType.get((int)0)).netHeadYaw * ((float)Math.PI / 180));
    }
}

