/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.entity.Lizard;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class LizardModel
extends AnimatedGeoModel<Lizard> {
    public static final ResourceLocation[] TEXTURE_LOCATIONS = new ResourceLocation[]{new ResourceLocation("naturalist", "textures/entity/lizard/green.png"), new ResourceLocation("naturalist", "textures/entity/lizard/brown.png"), new ResourceLocation("naturalist", "textures/entity/lizard/beardie.png"), new ResourceLocation("naturalist", "textures/entity/lizard/leopard_gecko.png")};

    public ResourceLocation getModelResource(Lizard lizard) {
        return new ResourceLocation("naturalist", "geo/lizard.geo.json");
    }

    public ResourceLocation getTextureResource(Lizard lizard) {
        return TEXTURE_LOCATIONS[lizard.getVariant()];
    }

    public ResourceLocation getAnimationResource(Lizard lizard) {
        return new ResourceLocation("naturalist", "animations/lizard.animation.json");
    }

    public void setLivingAnimations(Lizard lizard, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)lizard, uniqueID, customPredicate);
        if (customPredicate == null) {
            return;
        }
        List extraDataOfType = customPredicate.getExtraDataOfType(EntityModelData.class);
        IBone head = this.getAnimationProcessor().getBone("head");
        IBone tail = this.getAnimationProcessor().getBone("tail");
        head.setRotationX(((EntityModelData)extraDataOfType.get((int)0)).headPitch * ((float)Math.PI / 180));
        head.setRotationY(((EntityModelData)extraDataOfType.get((int)0)).netHeadYaw * ((float)Math.PI / 180));
        tail.setHidden(!lizard.hasTail());
    }
}

