/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.mojang.logging.LogUtils;
import com.starfish_studios.naturalist.entity.Catchable;
import com.starfish_studios.naturalist.entity.ai.goal.FlyingWanderGoal;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.NaturalistRegistry;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Butterfly
extends Animal
implements IAnimatable,
FlyingAnimal,
Catchable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final EntityDataAccessor<Boolean> HAS_NECTAR = SynchedEntityData.m_135353_(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_HAND = SynchedEntityData.m_135353_(Butterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int numCropsGrownSincePollination;

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public Butterfly(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, pLevel){

            public boolean m_6342_(BlockPos pPos) {
                return !this.f_26495_.m_8055_(pPos.m_7495_()).m_60795_();
            }
        };
        navigation.m_26440_(false);
        navigation.m_7008_(false);
        navigation.m_26443_(true);
        return navigation;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)1);
        this.f_19804_.m_135372_(FROM_HAND, (Object)false);
        this.f_19804_.m_135372_(HAS_NECTAR, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant().getId());
        compound.m_128379_("FromHand", this.fromHand());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(Variant.BY_ID[compound.m_128451_("Variant")]);
        this.setFromHand(compound.m_128471_("FromHand"));
    }

    public Variant getVariant() {
        return Variant.BY_ID[(Integer)this.f_19804_.m_135370_(DATA_VARIANT)];
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)variant.getId());
    }

    @Override
    public boolean fromHand() {
        return (Boolean)this.f_19804_.m_135370_(FROM_HAND);
    }

    @Override
    public void setFromHand(boolean fromHand) {
        this.f_19804_.m_135381_(FROM_HAND, (Object)fromHand);
    }

    public boolean hasNectar() {
        return (Boolean)this.f_19804_.m_135370_(HAS_NECTAR);
    }

    void setHasNectar(boolean hasNectar) {
        this.f_19804_.m_135381_(HAS_NECTAR, (Object)hasNectar);
    }

    public float m_5610_(BlockPos pPos, LevelReader pLevel) {
        return pLevel.m_8055_(pPos).m_60795_() ? 10.0f : 0.0f;
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_204117_(ItemTags.f_13149_);
    }

    int getCropsGrownSincePollination() {
        return this.numCropsGrownSincePollination;
    }

    private void resetNumCropsGrownSincePollination() {
        this.numCropsGrownSincePollination = 0;
    }

    void incrementNumCropsGrownSincePollination() {
        ++this.numCropsGrownSincePollination;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_((TagKey)ItemTags.f_13149_), false));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new ButterflyGrowCropGoal(this, 1.0, 16, 4));
        this.f_21345_.m_25352_(5, (Goal)new ButterflyPollinateGoal(this, 1.0, 16, 4));
        this.f_21345_.m_25352_(6, (Goal)new FlyingWanderGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(7, (Goal)new FloatGoal((Mob)this));
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        boolean bl = false;
        if (reason == MobSpawnType.BUCKET) {
            return spawnData;
        }
        RandomSource randomSource = level.m_213780_();
        if (spawnData instanceof ButterflyGroupData) {
            if (((ButterflyGroupData)((Object)spawnData)).m_146777_() >= 2) {
                bl = true;
            }
        } else {
            spawnData = new ButterflyGroupData(Variant.getCommonSpawnVariant(randomSource), Variant.getCommonSpawnVariant(randomSource));
        }
        this.setVariant(((ButterflyGroupData)((Object)spawnData)).getVariant(randomSource));
        if (bl) {
            this.m_146762_(-24000);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return Catchable.catchAnimal(player, hand, this, true).orElse(super.m_6071_(player, hand));
    }

    @Override
    public void saveToHandTag(ItemStack stack) {
        Catchable.saveDefaultDataToHandTag((Mob)this, stack);
        CompoundTag compoundTag = stack.m_41784_();
        compoundTag.m_128405_("Variant", this.getVariant().getId());
        compoundTag.m_128405_("Age", this.m_146764_());
    }

    @Override
    public void loadFromHandTag(CompoundTag tag) {
        Catchable.loadDefaultDataFromHandTag((Mob)this, tag);
        int i = tag.m_128451_("Variant");
        if (i >= 0 && i < Variant.BY_ID.length) {
            this.setVariant(Variant.BY_ID[i]);
        } else {
            LOGGER.error("Invalid variant: {}", (Object)i);
        }
        if (tag.m_128441_("Age")) {
            this.m_146762_(tag.m_128451_("Age"));
        }
        if (tag.m_128441_("HuntingCooldown")) {
            this.m_6274_().m_21882_(MemoryModuleType.f_148201_, (Object)true, tag.m_128454_("HuntingCooldown"));
        }
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.fromHand();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.fromHand() && !this.m_8077_();
    }

    @Override
    public ItemStack getCaughtItemStack() {
        return new ItemStack((ItemLike)NaturalistRegistry.BUTTERFLY.get());
    }

    @Override
    public SoundEvent getPickupSound() {
        return null;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getCropsGrownSincePollination() >= 10) {
            this.resetNumCropsGrownSincePollination();
            this.setHasNectar(false);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasNectar() && this.getCropsGrownSincePollination() < 10 && this.f_19796_.m_188501_() < 0.05f) {
            for (int i = 0; i < this.f_19796_.m_188503_(2) + 1; ++i) {
                this.spawnFluidParticle(this.f_19853_, this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5), (ParticleOptions)ParticleTypes.f_123782_);
            }
        }
    }

    private void spawnFluidParticle(Level level, double x1, double x2, double z1, double z2, double y, ParticleOptions particleOptions) {
        level.m_7106_(particleOptions, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)x1, (double)x2), y, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)z1, (double)z2), 0.0, 0.0, 0.0);
    }

    @javax.annotation.Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)NaturalistEntityTypes.CATERPILLAR.get().m_20615_((Level)level);
    }

    public boolean m_6162_() {
        return false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_29443_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("butterfly.fly"));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(5.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_142039_() {
        return this.m_29443_() && this.f_19797_ % Mth.m_14167_((float)1.4959966f) == 0;
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.5f;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
    }

    public static enum Variant {
        CABBAGE_WHITE(0, "cabbage_white", true),
        MONARCH(1, "monarch", true),
        CLOUDED_YELLOW(2, "clouded_yellow", true),
        SWALLOWTAIL(3, "swallowtail", true),
        BLUE_MORPHO(4, "blue_morpho", true);

        public static final Variant[] BY_ID;
        private final int id;
        private final String name;
        private final boolean common;

        private Variant(int j, String string2, boolean bl) {
            this.id = j;
            this.name = string2;
            this.common = bl;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static Variant getTypeById(int id) {
            for (Variant type : Variant.values()) {
                if (type.id != id) continue;
                return type;
            }
            return MONARCH;
        }

        public static Variant getCommonSpawnVariant(RandomSource random) {
            return Variant.getSpawnVariant(random, true);
        }

        private static Variant getSpawnVariant(RandomSource random, boolean common) {
            Variant[] variants = (Variant[])Arrays.stream(BY_ID).filter(variant -> variant.common == common).toArray(Variant[]::new);
            return (Variant)((Object)Util.m_214670_((Object[])variants, (RandomSource)random));
        }

        static {
            BY_ID = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }

    static class ButterflyGrowCropGoal
    extends MoveToBlockGoal {
        private final Butterfly butterfly;

        public ButterflyGrowCropGoal(Butterfly pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((PathfinderMob)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.butterfly = pMob;
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            CropBlock cropBlock;
            BlockState state = pLevel.m_8055_(pPos);
            Block block = state.m_60734_();
            return block instanceof CropBlock && (Integer)state.m_61143_((Property)(cropBlock = (CropBlock)block).m_7959_()) < cropBlock.m_7419_();
        }

        public void m_8037_() {
            BlockPos blockpos = this.m_6669_();
            if (!blockpos.m_203195_((Position)this.f_25598_.m_20182_(), this.m_8052_())) {
                ++this.f_25601_;
                if (this.m_8064_()) {
                    this.f_25598_.m_21573_().m_26519_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, this.f_25599_);
                }
            } else {
                this.onReachedTarget();
            }
        }

        protected void onReachedTarget() {
            BlockState state = this.butterfly.f_19853_.m_8055_(this.f_25602_);
            Block block = state.m_60734_();
            if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                cropBlock.m_52263_(this.butterfly.f_19853_, this.f_25602_, state);
                this.butterfly.incrementNumCropsGrownSincePollination();
                this.m_8041_();
            }
        }

        public boolean m_8036_() {
            return this.butterfly.hasNectar() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.butterfly.hasNectar() && super.m_8045_();
        }
    }

    static class ButterflyPollinateGoal
    extends MoveToBlockGoal {
        protected int ticksWaited;
        private final Butterfly butterfly;

        public ButterflyPollinateGoal(Butterfly pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((PathfinderMob)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.butterfly = pMob;
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            return pLevel.m_8055_(pPos).m_204336_(BlockTags.f_13041_) || pLevel.m_8055_(pPos).m_60713_(NaturalistRegistry.CATTAIL.get());
        }

        public void m_8037_() {
            if (this.m_25625_()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            }
            super.m_8037_();
        }

        protected void onReachedTarget() {
            BlockState state = this.butterfly.f_19853_.m_8055_(this.f_25602_);
            if (state.m_204336_(BlockTags.f_13041_)) {
                this.butterfly.setHasNectar(true);
                this.m_8041_();
            }
        }

        public boolean m_8036_() {
            return !this.butterfly.hasNectar() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.butterfly.hasNectar() && super.m_8045_();
        }

        public void m_8056_() {
            this.ticksWaited = 0;
            super.m_8056_();
        }
    }

    public static class ButterflyGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Variant[] types;

        public ButterflyGroupData(Variant ... variants) {
            super(false);
            this.types = variants;
        }

        public Variant getVariant(RandomSource random) {
            return this.types[random.m_188503_(this.types.length)];
        }
    }
}

