/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config.spec;

import java.lang.reflect.Field;
import net.roguelogix.phosphophyllite.config.ConfigValue;
import net.roguelogix.phosphophyllite.config.spec.ConfigOptionsDefaults;
import net.roguelogix.phosphophyllite.config.spec.SpecNode;
import net.roguelogix.phosphophyllite.config.spec.SpecObjectNode;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public abstract class SpecValueNode
extends SpecNode {
    public final Field field;
    public final SpecObjectNode parent;

    protected SpecValueNode(SpecObjectNode parent, Field field, ConfigOptionsDefaults defaults) {
        super(field.getName(), field.getAnnotation(ConfigValue.class), defaults);
        field.setAccessible(true);
        this.field = field;
        this.parent = parent;
    }

    protected Object currentValueObject() {
        try {
            return this.field.get(this.parent.object());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeObject(Object object) {
        try {
            this.field.set(this.parent.object(), object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract String defaultValueAsString();

    public abstract String currentValueAsString();

    public abstract void writeFromString(String var1);

    public abstract boolean isValueValid(String var1);

    public abstract String generateComment();
}

