/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.debug;

import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.roguelogix.phosphophyllite.debug.DebugInfo;
import net.roguelogix.phosphophyllite.debug.IDebuggable;
import net.roguelogix.phosphophyllite.registry.RegisterItem;

public class DebugTool
extends Item {
    @RegisterItem(name="debug_tool")
    public static final DebugTool INSTANCE = new DebugTool();

    public DebugTool() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null) {
            BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
            if (blockEntity instanceof IDebuggable) {
                IDebuggable debuggable = (IDebuggable)blockEntity;
                DebugInfo debugInfo = debuggable.getDebugInfo();
                if (debugInfo == null) {
                    String toPrint = "Null debug info returned on " + (context.m_43725_().m_5776_() ? " Client" : " Server");
                    player.m_213846_((Component)Component.m_237113_((String)"Null debug info returned"));
                    System.out.println();
                    return InteractionResult.SUCCESS;
                }
                String toPrint = new DebugInfo(debugInfo.name() + (context.m_43725_().m_5776_() ? " (Client)" : " (Server)"), debugInfo).toString();
                player.m_213846_((Component)Component.m_237113_((String)toPrint));
                System.out.println(toPrint);
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"Non-debuggable block"));
            }
        }
        return InteractionResult.SUCCESS;
    }
}

