/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.BlockLightingHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.HitBoxData;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ParticleHelper;
import shetiphian.core.common.ToolHelper;
import shetiphian.core.common.UseContext;
import shetiphian.platforms.Configuration;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.render.RenderRegistry;
import shetiphian.platforms.common.block.BlockPlatformFloor;
import shetiphian.platforms.common.block.BlockPlatformType;
import shetiphian.platforms.common.block.PropertySubType;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumCovering;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFlat;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFloor;
import shetiphian.platforms.common.tileentity.TileEntityPlatformFrame;
import shetiphian.platforms.common.tileentity.TileEntityPlatformIncline;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRailing;
import shetiphian.platforms.common.tileentity.TileEntityPlatformRoof;

public abstract class BlockPlatformBase
extends Block
implements EntityBlock,
IColored,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected final EnumPlatformType platformType;
    protected static Table<String, Direction, VoxelShape> HITBOXES = HashBasedTable.create();
    private static final Map<String, VoxelShape> BOXCACHE = new HashMap<String, VoxelShape>();
    private static final Material materialPlatform = new Material(MaterialColor.f_76411_, false, false, true, false, false, false, PushReaction.IGNORE);
    private static final Cache<Entity, BlockPos> WALK_CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.SECONDS).build();

    public BlockPlatformBase(EnumPlatformType type) {
        super(BlockBehaviour.Properties.m_60939_((Material)materialPlatform).m_60918_(SoundType.f_56736_).m_60913_(3.0f, 0.5f).m_60977_().m_60955_().m_60953_(BlockLightingHelper::getLightValue));
        this.platformType = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockLightingHelper.LIGHTING, (Comparable)BlockLightingHelper.PackedData.UNKNOWEN));
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED, BlockLightingHelper.LIGHTING});
        if (this.getPropertySubType() != null) {
            builder.m_61104_(new Property[]{this.getPropertySubType()});
        }
    }

    @Nullable
    protected abstract PropertySubType getPropertySubType();

    public EnumPlatformType getPlatformType() {
        return this.platformType;
    }

    public Collection<EnumSubType> getAllowedValues() {
        PropertySubType propertySubType = this.getPropertySubType();
        if (propertySubType == null) {
            return ImmutableSet.of((Object)((Object)EnumSubType.NONE));
        }
        return propertySubType.m_6908_();
    }

    public static EnumSubType getPlatformSubType(BlockState state) {
        BlockPlatformBase block;
        PropertySubType propertySubType;
        Block block2 = state.m_60734_();
        if (block2 instanceof BlockPlatformBase && (propertySubType = (block = (BlockPlatformBase)block2).getPropertySubType()) != null) {
            return (EnumSubType)((Object)state.m_61143_((Property)propertySubType));
        }
        return EnumSubType.NONE;
    }

    public static BlockState getStateWithPlatformSubType(BlockState state, EnumSubType subType) {
        Collection subTypes;
        BlockPlatformBase block;
        PropertySubType propertySubType;
        Block block2;
        if (subType != null && subType != EnumSubType.NONE && (block2 = state.m_60734_()) instanceof BlockPlatformBase && (propertySubType = (block = (BlockPlatformBase)block2).getPropertySubType()) != null && (subTypes = propertySubType.m_6908_()).contains((Object)subType)) {
            return (BlockState)state.m_61124_((Property)propertySubType, (Comparable)((Object)subType));
        }
        return state;
    }

    public static boolean setPlatformSubType(LevelAccessor world, BlockPos pos, EnumSubType subType) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BlockPlatformBase) {
            BlockPlatformBase block2 = (BlockPlatformBase)block;
            BlockState result = BlockPlatformBase.getStateWithPlatformSubType(state, subType);
            if (result != state && Function.setBlock((LevelAccessor)world, (BlockPos)pos, (BlockState)result, (boolean)true)) {
                TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
                if (tile instanceof TileEntityPlatformIncline) {
                    block2.editLinkedRail(result, world, pos, tile, true);
                }
                if (tile instanceof TileEntityPlatformFloor) {
                    block2.editLinkedRail(result, world, pos, tile, false);
                }
                return true;
            }
        }
        return false;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.getPlatformType()) {
            default -> throw new IncompatibleClassChangeError();
            case EnumPlatformType.FLAT -> new TileEntityPlatformFlat(pos, state);
            case EnumPlatformType.FLOOR -> new TileEntityPlatformFloor(pos, state);
            case EnumPlatformType.FRAME -> new TileEntityPlatformFrame(pos, state);
            case EnumPlatformType.RAMP, EnumPlatformType.STAIRS, EnumPlatformType.STEPS -> new TileEntityPlatformIncline(pos, state);
            case EnumPlatformType.SHINGLES, EnumPlatformType.TILES -> new TileEntityPlatformRoof(pos, state);
            case EnumPlatformType.RAIL, EnumPlatformType.RISE -> new TileEntityPlatformRailing(pos, state);
        };
    }

    protected static TileEntityPlatformBase getTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof TileEntityPlatformBase ? (TileEntityPlatformBase)tile : null;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter world, BlockPos pos) {
        float value = state.m_60800_(world, pos);
        TileEntityPlatformBase tile = BlockPlatformBase.getTile(world, pos);
        if (tile != null) {
            try {
                Block block = ((BlockItem)tile.getFrameTextureBlock().m_41720_()).m_40614_();
                value = block.m_49966_().m_60800_(world, pos);
            }
            catch (Exception block) {
                // empty catch block
            }
        }
        int i = ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) ? 30 : 100;
        return player.getDigSpeed(state, pos) / value / (float)i;
    }

    private static void setLighting(BlockState state, Level world, BlockPos pos, TileEntityPlatformBase tile) {
        if (state.m_61143_((Property)BlockLightingHelper.LIGHTING) == BlockLightingHelper.PackedData.UNKNOWEN) {
            BlockPlatformBase.updateLighting(state, world, pos, tile);
        }
    }

    public static void updateLighting(BlockState state, Level world, BlockPos pos, TileEntityPlatformBase tile) {
        if (world != null && !world.m_5776_() && tile != null) {
            BlockLightingHelper.PackedData current = (BlockLightingHelper.PackedData)state.m_61143_((Property)BlockLightingHelper.LIGHTING);
            Optional<Boolean> translucent = TileHelper.isTranslucent(tile);
            if (translucent.isPresent() && (state = BlockLightingHelper.setLighting((BlockState)state, (int)TileHelper.getLightValue(tile), (boolean)translucent.get())).m_61143_((Property)BlockLightingHelper.LIGHTING) != current) {
                world.m_7731_(pos, state, 3);
            }
        }
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return this.platformType.isAddon() || BlockLightingHelper.doesLightPassThrough((BlockState)state);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile != null) {
            return tile.getSoundType();
        }
        return super.m_49962_(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
        EnumPlatformType railType = TileHelper.getRail(BlockPlatformBase.getTile(world, pos));
        String linked = "";
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        String cacheKey = "collision:" + this.platformType.m_7912_() + ":" + subType.name() + ":" + direction.m_122433_();
        if (railType != null) {
            cacheKey = cacheKey + ":" + railType.m_7912_();
        }
        if (!BOXCACHE.containsKey(cacheKey)) {
            VoxelShape result = this.buildShape(subType, direction, railType, linked, true);
            if (result == null) {
                return Shapes.m_83040_();
            }
            BOXCACHE.put(cacheKey, result);
        }
        return BOXCACHE.get(cacheKey);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
        EnumPlatformType railType = TileHelper.getRail(BlockPlatformBase.getTile(world, pos));
        String linked = "";
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        String cacheKey = this.platformType.m_7912_() + ":" + subType.name() + ":" + direction.m_122433_();
        if (railType != null) {
            cacheKey = cacheKey + ":" + railType.m_7912_();
        }
        if (!BOXCACHE.containsKey(cacheKey)) {
            VoxelShape result = this.buildShape(subType, direction, railType, linked, false);
            if (result == null) {
                return Shapes.m_83144_();
            }
            BOXCACHE.put(cacheKey, result);
        }
        return BOXCACHE.get(cacheKey);
    }

    protected static void addHitBoxData(String key, double[][] cordsets) {
        Map map = HitBoxData.build((double[][])cordsets, (boolean)false);
        map.forEach((direction, shape) -> HITBOXES.put((Object)key, direction, shape));
    }

    protected VoxelShape buildShape(EnumSubType subType, Direction direction, EnumPlatformType railType, String linked, boolean collision) {
        return null;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return willHarvest || super.onDestroyedByPlayer(state, world, pos, player, false, fluid);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        TileEntityPlatformBase oTile;
        EnumTorchType torch;
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile instanceof TileEntityPlatformFrame && ((torch = ((TileEntityPlatformFrame)tile).getTorch()) == EnumTorchType.REDSTONE_ON || torch == EnumTorchType.LAMP_ON)) {
            world.m_46672_(pos, (Block)this);
            if (world.m_8055_(pos.m_7494_()).m_60734_() != this) {
                world.m_46672_(pos.m_7494_(), (Block)this);
            }
        }
        if (tile != null && (this.platformType.isIncline() || this.platformType == EnumPlatformType.FLOOR) && tile.hasRail()) {
            world.m_7471_(pos.m_7494_(), false);
        }
        if (tile instanceof TileEntityPlatformRailing && ((TileEntityPlatformRailing)tile).isLinked() && (oTile = BlockPlatformBase.getTile((BlockGetter)world, pos.m_7495_())) != null) {
            oTile.removeRail();
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, BlockEntity tile, ItemStack stack) {
        super.m_6240_(world, player, pos, state, tile, stack);
        world.m_7471_(pos, false);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List drops = super.m_7381_(state, builder);
        BlockEntity tile = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (tile instanceof TileEntityPlatformBase) {
            ((TileEntityPlatformBase)tile).addExtraDrops(drops);
        }
        return drops;
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        if (player == null || !player.m_6144_()) {
            return;
        }
        ItemStack currentItem = player.m_21205_();
        if (currentItem.m_41619_()) {
            return;
        }
        if (!ToolHelper.isWrench((ItemStack)currentItem)) {
            return;
        }
        if (this.platformType == EnumPlatformType.RAIL || this.platformType == EnumPlatformType.RISE) {
            return;
        }
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile == null || !TileHelper.hasRail(tile) && !TileHelper.hasTorch(tile)) {
            return;
        }
        ItemStack stack = null;
        if (this.platformType == EnumPlatformType.FRAME) {
            EnumTorchType torchType = TileHelper.getTorch(tile);
            stack = torchType != null ? torchType.getItemStack() : null;
        } else if (tile.hasRail()) {
            stack = tile.getRailItem();
        }
        if (stack != null) {
            Function.giveItem((Player)player, (ItemStack)stack);
            if (this.platformType == EnumPlatformType.FRAME) {
                TileHelper.removeTorch(tile);
                world.m_46672_(pos, (Block)this);
            } else {
                TileHelper.removeRail(tile);
                if (tile instanceof TileEntityPlatformIncline) {
                    this.editLinkedRail(state, (LevelAccessor)world, pos, tile, true);
                }
                if (tile instanceof TileEntityPlatformFloor) {
                    this.editLinkedRail(state, (LevelAccessor)world, pos, tile, false);
                }
            }
            Function.syncTile((BlockEntity)tile);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_()) {
            TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
            if (tile != null) {
                return this.onBlockActivated(stack, tile, state, world, pos, player, hand, hit);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult onBlockActivated(ItemStack heldItem, TileEntityPlatformBase tile, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (heldItem.m_41720_() instanceof ItemBlockPlatform && ((ItemBlockPlatform)heldItem.m_41720_()).getPlatformType().isAddon() && BlockPlatformBase.canPlaceRailOn(state, (LevelReader)world, pos, tile) && TileHelper.setRail(tile, heldItem)) {
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            if (tile.hasRail()) {
                world.m_5594_(player, pos, tile.getRailSound().m_56777_(), SoundSource.BLOCKS, 1.0f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
                Function.syncTile((BlockEntity)tile);
                if (tile instanceof TileEntityPlatformIncline) {
                    this.editLinkedRail(state, (LevelAccessor)world, pos, tile, true);
                }
                if (tile instanceof TileEntityPlatformFloor) {
                    this.editLinkedRail(state, (LevelAccessor)world, pos, tile, false);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (tile.getCovering() != EnumCovering.NONE && ToolHelper.isShovel((ItemStack)heldItem)) {
            tile.playCoveringSound(player, false);
            this.changeCovering(state, world, pos, tile.getCovering().decrement());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean canPlaceRailOn(BlockState state, LevelReader world, BlockPos pos, TileEntityPlatformBase tile) {
        if (!tile.hasRail() && state.m_60734_() instanceof BlockPlatformBase) {
            EnumPlatformType type = ((BlockPlatformBase)state.m_60734_()).platformType;
            EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
            if (subType.supportsRail(type)) {
                if (tile instanceof TileEntityPlatformIncline && !subType.usesSpecialRail(type)) {
                    return world.m_8055_(pos.m_7494_()).m_60767_().m_76336_();
                }
                return true;
            }
        }
        return false;
    }

    private void editLinkedRail(BlockState state, LevelAccessor world, BlockPos pos, TileEntityPlatformBase tile, boolean isIncline) {
        if (state.m_60734_() instanceof BlockPlatformBase) {
            EnumPlatformType type = ((BlockPlatformBase)state.m_60734_()).platformType;
            EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
            BlockPos posUp = pos.m_7494_();
            BlockState above = world.m_8055_(posUp);
            if (subType.supportsRail(type) && tile.hasRail()) {
                TileEntityPlatformBase oTile;
                BlockState oState;
                if (subType.usesSpecialRail(type)) {
                    TileEntityPlatformRailing railing;
                    TileEntityPlatformBase oTile2 = BlockPlatformBase.getTile((BlockGetter)world, posUp);
                    if (oTile2 instanceof TileEntityPlatformRailing && (railing = (TileEntityPlatformRailing)oTile2).isLinked()) {
                        world.m_7471_(posUp, false);
                    }
                    return;
                }
                if (above.m_60734_() != this && above.m_60767_().m_76336_()) {
                    EnumPlatformType platform = tile.getRailType();
                    if (platform == null) {
                        return;
                    }
                    Function.setBlock((LevelAccessor)world, (BlockPos)posUp, (BlockState)Values.getPlatform(platform).m_49966_(), (boolean)false);
                }
                if ((oState = world.m_8055_(posUp)).m_60734_() instanceof BlockPlatformBase) {
                    oState = BlockPlatformBase.getStateWithPlatformSubType(oState, EnumSubType.byName(subType.getStyleName()));
                    Function.setBlock((LevelAccessor)world, (BlockPos)posUp, (BlockState)((BlockState)oState.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)))), (boolean)true);
                }
                if ((oTile = BlockPlatformBase.getTile((BlockGetter)world, posUp)) instanceof TileEntityPlatformRailing) {
                    TileEntityPlatformRailing railing = (TileEntityPlatformRailing)oTile;
                    oTile.setTextureInfo(tile.getRailItem());
                    if (isIncline) {
                        railing.setLinkedToRamp(true);
                    } else {
                        railing.setLinkedToFloor(true);
                    }
                    oTile.copyCovering(tile);
                }
            } else {
                TileEntityPlatformRailing railing;
                TileEntityPlatformBase oTile = BlockPlatformBase.getTile((BlockGetter)world, posUp);
                if (oTile instanceof TileEntityPlatformRailing && (railing = (TileEntityPlatformRailing)oTile).isLinked()) {
                    world.m_7471_(posUp, false);
                }
            }
        }
    }

    public void changeCovering(BlockState state, Level world, BlockPos pos, EnumCovering covering) {
        if (state.m_60734_() instanceof BlockPlatformBase) {
            TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
            if (((BlockPlatformBase)state.m_60734_()).platformType.isAddon() && tile instanceof TileEntityPlatformRailing && ((TileEntityPlatformRailing)tile).isLinked()) {
                TileEntityPlatformBase oTile;
                state = world.m_8055_(pos = pos.m_7495_());
                if (!(state.m_60734_() instanceof BlockPlatformBase)) {
                    return;
                }
                if (tile.getCovering() == EnumCovering.NONE && (oTile = BlockPlatformBase.getTile((BlockGetter)world, pos)) != null) {
                    oTile.copyCovering(tile);
                }
            }
            if (tile != null) {
                tile.setCovering(covering);
                this.editLinkedRail(state, (LevelAccessor)world, pos, tile, tile instanceof TileEntityPlatformIncline);
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Optional<Boolean> translucent;
        Direction direction = context.m_8125_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
        if (!(this instanceof BlockPlatformType.Singles)) {
            BlockState oState;
            Block block;
            boolean zAxis;
            EnumSubType subType = null;
            Direction face = context.m_43719_();
            boolean bl = zAxis = direction.m_122434_() == Direction.Axis.Z;
            if ((this instanceof BlockPlatformType.Walkways && face.m_122434_() != Direction.Axis.Y || this instanceof BlockPlatformType.Railings) && (block = (oState = context.m_43725_().m_8055_(context.m_8083_().m_121945_(face.m_122424_()))).m_60734_()) instanceof BlockPlatformBase) {
                BlockPlatformBase oBlock = (BlockPlatformBase)block;
                if (oBlock.platformType == this.platformType) {
                    state = (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)oState.m_61143_((Property)FACING)));
                    subType = BlockPlatformBase.getPlatformSubType(oState);
                } else if (face == Direction.UP && this instanceof BlockPlatformType.Railings) {
                    subType = EnumSubType.byName(BlockPlatformBase.getPlatformSubType(oState).getStyleName());
                    if (subType.supportsRail(oBlock.platformType)) {
                        state = (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)oState.m_61143_((Property)FACING)));
                    } else {
                        subType = null;
                    }
                }
            }
            if (subType == null) {
                boolean railOnStep = false;
                if (this instanceof BlockPlatformType.Railings) {
                    double hitX = context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_();
                    double hitZ = context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_();
                    BlockState down = context.m_43725_().m_8055_(context.m_8083_().m_7495_());
                    if (down.m_60734_() instanceof StairBlock) {
                        railOnStep = true;
                        direction = (Direction)down.m_61143_((Property)StairBlock.f_56841_);
                        subType = direction.m_122434_() == Direction.Axis.Z ? (direction == Direction.NORTH ? (hitX > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT) : (hitX > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT)) : (direction == Direction.EAST ? (hitZ > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT) : (hitZ > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT));
                    } else {
                        if (face.m_122434_() == Direction.Axis.Y) {
                            if (hitX <= 0.5 && hitZ < 0.5) {
                                direction = hitX < hitZ ? Direction.NORTH : Direction.EAST;
                            } else if (hitX > 0.5 && hitZ <= 0.5) {
                                direction = 1.0 - hitX < hitZ ? Direction.SOUTH : Direction.EAST;
                            } else if (hitX <= 0.5 && hitZ > 0.5) {
                                direction = hitX < 1.0 - hitZ ? Direction.NORTH : Direction.WEST;
                            } else if (hitX > 0.5 && hitZ >= 0.5) {
                                direction = hitX > hitZ ? Direction.SOUTH : Direction.WEST;
                            }
                        } else {
                            direction = face.m_122428_();
                        }
                        subType = EnumSubType.EDGE;
                    }
                    state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
                } else if (zAxis) {
                    double hitX = context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_();
                    subType = hitX > (double)0.4f && hitX < (double)0.6f ? EnumSubType.MIDDLE : (direction == Direction.SOUTH ? (hitX > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT) : (hitX > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT));
                } else {
                    double hitZ = context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_();
                    if (hitZ > (double)0.4f && hitZ < (double)0.6f) {
                        subType = EnumSubType.MIDDLE;
                    } else if (direction == Direction.WEST) {
                        subType = hitZ > 0.5 ? EnumSubType.RIGHT : EnumSubType.LEFT;
                    } else {
                        EnumSubType enumSubType = subType = hitZ > 0.5 ? EnumSubType.LEFT : EnumSubType.RIGHT;
                    }
                }
                if (!railOnStep && !this.platformType.isInclineOrRoof()) {
                    if (subType == EnumSubType.RIGHT) {
                        state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction.m_122424_());
                        EnumSubType enumSubType = subType = this.platformType.isAddon() ? EnumSubType.EDGE : EnumSubType.EDGE_S;
                    }
                    if (subType == EnumSubType.LEFT) {
                        subType = EnumSubType.EDGE;
                    }
                }
            }
            state = BlockPlatformBase.getStateWithPlatformSubType(state, subType);
        }
        if ((translucent = TileHelper.isTranslucent(context.m_43722_())).isPresent()) {
            state = BlockLightingHelper.setLighting((BlockState)state, (int)TileHelper.getLightValue(context.m_43722_()), (boolean)translucent.get());
        }
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile != null) {
            tile.setTextureInfo(stack);
            Function.syncTile((BlockEntity)tile);
            this.updateBlock(tile, state, world, pos);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityPlatformBase tile;
        if (state.m_60734_() == newState.m_60734_() && (tile = BlockPlatformBase.getTile((BlockGetter)world, pos)) != null) {
            this.updateBlock(tile, newState, world, pos);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        if (world.m_5776_() || !((Boolean)Configuration.DUST_COVERING.isEnvironmentReactive.get()).booleanValue() || !(state.m_60734_() instanceof BlockPlatformBase) || ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return;
        }
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile != null) {
            EnumCovering covering = tile.getCovering();
            if (!covering.isWorldReactive()) {
                return;
            }
            Holder biomeRegistryEntry = world.m_204166_(pos);
            Biome biome = (Biome)biomeRegistryEntry.m_203334_();
            boolean canIncreaseLevel = this.canIncreaseLevel(tile, (Holder<Biome>)biomeRegistryEntry, covering);
            if (world.m_46471_()) {
                switch (biome.m_47530_()) {
                    case NONE: {
                        if (!world.m_46470_() || !canIncreaseLevel || !this.getChance(world.f_46441_, (Integer)Configuration.DUST_COVERING.chanceSandStorm.get()) || !this.isSandBiome((Level)world, pos) || !this.isOutdoors((Level)world, pos, true)) break;
                        this.changeCovering(state, (Level)world, pos, covering.increment());
                        break;
                    }
                    case RAIN: {
                        if (biome.m_198906_(pos)) {
                            int chance = (Integer)Configuration.DUST_COVERING.chanceRainWash.get();
                            if (covering == EnumCovering.NONE || !this.getChance(world.f_46441_, chance - (world.m_46470_() ? chance / 3 : 0)) || !this.isSandBiome((Level)world, pos) || !this.isOutdoors((Level)world, pos, false)) break;
                            this.changeCovering(state, (Level)world, pos, covering.decrement());
                            break;
                        }
                    }
                    case SNOW: {
                        if (!canIncreaseLevel || !this.getChance(world.f_46441_, (Integer)Configuration.DUST_COVERING.chanceSnow.get()) || !this.isOutdoors((Level)world, pos, false)) break;
                        this.changeCovering(state, (Level)world, pos, covering.increment());
                    }
                }
            } else if (canIncreaseLevel && covering == EnumCovering.NONE && this.getChance(world.f_46441_, (Integer)Configuration.DUST_COVERING.chanceSand.get()) && this.isSandBiome((Level)world, pos) && this.isOutdoors((Level)world, pos, true)) {
                this.changeCovering(state, (Level)world, pos, EnumCovering.A1);
            }
        }
        BlockPlatformBase.setLighting(state, (Level)world, pos, tile);
    }

    private boolean canIncreaseLevel(TileEntityPlatformBase tile, Holder<Biome> biomeRegistryEntry, EnumCovering covering) {
        if (covering == EnumCovering.NONE || covering.isWorldReactive() && covering.canIncrement()) {
            Block coveringBlock = tile.getCoveringBlock();
            Block biomeCovering = tile.getBiomeCovering(biomeRegistryEntry);
            if (covering == EnumCovering.NONE && coveringBlock != Blocks.f_50016_ && coveringBlock != biomeCovering) {
                tile.removeCoveringTexture();
                coveringBlock = tile.getCoveringBlock();
            }
            if (coveringBlock == Blocks.f_50016_) {
                return tile.setCoveringTexture(new ItemStack((ItemLike)biomeCovering)) != EnumCovering.NONE;
            }
            return biomeCovering == coveringBlock;
        }
        return false;
    }

    private boolean getChance(RandomSource random, int odds) {
        return odds > 0 && random.m_188503_(odds) == 0;
    }

    private boolean isSandBiome(Level world, BlockPos pos) {
        return BlockPlatformBase.getBiomeTopBlock((Holder<Biome>)world.m_204166_(pos)) instanceof SandBlock;
    }

    public static Block getBiomeTopBlock(Holder<Biome> biome) {
        if (biome.m_203656_(BiomeTags.f_207607_)) {
            return Blocks.f_49993_;
        }
        if (biome.m_203656_(BiomeTags.f_207604_) || biome.m_203656_(Tags.Biomes.IS_SANDY)) {
            return Blocks.f_49992_;
        }
        if (biome.m_203656_(BiomeTags.f_207606_) || biome.m_203656_(Tags.Biomes.IS_UNDERGROUND)) {
            return Blocks.f_49994_;
        }
        if (biome.m_203656_(Tags.Biomes.IS_MUSHROOM)) {
            return Blocks.f_50195_;
        }
        if (biome.m_203656_(Tags.Biomes.IS_SNOWY)) {
            return Blocks.f_50354_;
        }
        if (biome.m_203656_(BiomeTags.f_207612_)) {
            return Blocks.f_50134_;
        }
        if (biome.m_203656_(BiomeTags.f_215818_)) {
            return Blocks.f_50259_;
        }
        return Blocks.f_50440_;
    }

    private boolean isOutdoors(Level world, BlockPos pos, boolean addingSand) {
        if (addingSand) {
            BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
            int layers = 0;
            boolean isRaining = world.m_46471_();
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = -1; y <= 1; ++y) {
                        if (x == 0 && z == 0 && y == 0) continue;
                        mPos.m_122178_(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
                        if (world.m_46859_((BlockPos)mPos)) continue;
                        BlockState state = world.m_8055_((BlockPos)mPos);
                        Block block = state.m_60734_();
                        if (block instanceof BlockPlatformBase) {
                            TileEntityPlatformBase tile;
                            if (y < 0 && !isRaining || (tile = BlockPlatformBase.getTile((BlockGetter)world, (BlockPos)mPos)) == null) continue;
                            layers += Math.max(0, tile.getCovering().getLayer() - 1);
                            continue;
                        }
                        if (!state.m_204336_(BlockTags.f_13029_)) continue;
                        return true;
                    }
                }
            }
            return layers > 3;
        }
        if (world.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_()) <= pos.m_123342_() + 1) {
            return true;
        }
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                mPos.m_122178_(pos.m_123341_() + x, pos.m_123342_(), pos.m_123343_() + z);
                if (world.m_6924_(Heightmap.Types.MOTION_BLOCKING, mPos.m_123341_(), mPos.m_123343_()) > pos.m_123342_() + 1) continue;
                return true;
            }
        }
        return false;
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        BlockPos cached;
        super.m_141947_(world, pos, state, entity);
        if (!(world.m_5776_() || !((Boolean)Configuration.DUST_COVERING.isEntityReactive.get()).booleanValue() || (cached = (BlockPos)WALK_CACHE.getIfPresent((Object)entity)) != null && cached.equals((Object)pos))) {
            EnumCovering covering;
            TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
            EnumCovering enumCovering = covering = tile != null ? tile.getCovering() : EnumCovering.NONE;
            if (covering.isWorldReactive() && covering.canDecrement() && world.m_213780_().m_188503_(4) == 0) {
                this.changeCovering(state, world, pos, covering.decrement());
            }
            WALK_CACHE.put((Object)entity, (Object)pos);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, world, pos, blockIn, fromPos, isMoving);
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile != null) {
            this.updateBlock(tile, state, world, pos);
        }
        BlockPlatformBase.setLighting(state, world, pos, tile);
    }

    protected abstract void updateBlock(TileEntityPlatformBase var1, BlockState var2, Level var3, BlockPos var4);

    protected AABB getShapeBoundingBox(VoxelShape shape) {
        return shape.m_83281_() ? null : shape.m_83215_();
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return this.rotateBlock(state, world, pos, BlockPlatformBase.getTile((BlockGetter)world, pos), rotation);
    }

    public BlockState rotateBlock(BlockState state, LevelAccessor world, BlockPos pos, TileEntityPlatformBase tile, Rotation rotation) {
        if (tile == null || state.m_60734_() != this) {
            return state;
        }
        if (world instanceof Level) {
            ((Level)world).captureBlockSnapshots = false;
        }
        if (tile instanceof TileEntityPlatformRailing && ((TileEntityPlatformRailing)tile).isLinked()) {
            BlockState newStateDown;
            BlockPos posDown = pos.m_7495_();
            BlockState stateDown = world.m_8055_(posDown);
            if ((stateDown.m_60734_() instanceof BlockPlatformFloor || stateDown.m_60734_() instanceof BlockPlatformType.Inclines) && stateDown != (newStateDown = stateDown.rotate(world, posDown, rotation))) {
                Function.setBlock((LevelAccessor)world, (BlockPos)posDown, (BlockState)newStateDown, (boolean)true);
            }
            return world.m_8055_(pos);
        }
        if (tile instanceof TileEntityPlatformRoof) {
            ((TileEntityPlatformRoof)tile).preRotateFacing = (Direction)state.m_61143_((Property)FACING);
        }
        if (this.platformType == EnumPlatformType.FRAME && rotation == Rotation.NONE) {
            rotation = Rotation.CLOCKWISE_90;
        }
        if (rotation != Rotation.NONE) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            direction = switch (rotation) {
                case Rotation.CLOCKWISE_90 -> direction.m_122427_();
                case Rotation.COUNTERCLOCKWISE_90 -> direction.m_122428_();
                case Rotation.CLOCKWISE_180 -> direction.m_122424_();
                default -> direction;
            };
            BlockState rotatedState = (BlockState)state.m_61124_((Property)FACING, (Comparable)direction);
            if (tile.hasRail() && (tile instanceof TileEntityPlatformIncline || tile instanceof TileEntityPlatformFloor)) {
                this.editLinkedRail(rotatedState, world, pos, tile, tile instanceof TileEntityPlatformIncline);
            }
            return rotatedState;
        }
        EnumSubType subType = BlockPlatformBase.getPlatformSubType(state);
        PropertySubType propertySubType = this.getPropertySubType();
        if (propertySubType == null) {
            return state;
        }
        Collection subTypes = propertySubType.m_6908_();
        EnumSubType newType = null;
        EnumSubType[] types = subTypes.toArray(new EnumSubType[0]);
        int current = 100;
        for (int index = 0; index < types.length; ++index) {
            if (types[index] == subType) {
                current = index;
            }
            if (current >= index) continue;
            newType = types[index];
            break;
        }
        if (newType == null && current > 0) {
            newType = types[0];
        }
        if (newType != null && BlockPlatformBase.setPlatformSubType(world, pos, newType)) {
            return world.m_8055_(pos);
        }
        return state;
    }

    public boolean addLandingEffects(BlockState state, ServerLevel world, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        BlockState particles;
        ItemStack stack;
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile != null && !(stack = tile.getCoverTextureBlock()).m_41619_() && stack.m_41720_() instanceof BlockItem && !(particles = UseContext.getBlockPlacementStateFor((ItemStack)stack, (Level)world)).m_60795_()) {
            return ParticleHelper.addLandingEffects((ServerLevel)world, (Entity)entity, (int)numberOfParticles, (BlockState)particles);
        }
        return false;
    }

    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockState particles;
        ItemStack stack;
        TileEntityPlatformBase tile = BlockPlatformBase.getTile((BlockGetter)world, pos);
        if (tile != null && !(stack = tile.getCoverTextureBlock()).m_41619_() && stack.m_41720_() instanceof BlockItem && !(particles = UseContext.getBlockPlacementStateFor((ItemStack)stack, (Level)world)).m_60795_()) {
            return ParticleHelper.addRunningEffects((Level)world, (BlockPos)pos, (Entity)entity, (BlockState)particles);
        }
        return false;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityPlatformBase tile;
        if ((index > 0 && index < 5 || index == 9) && data.world != null && data.pos != null && (tile = BlockPlatformBase.getTile((BlockGetter)data.world, data.pos)) != null) {
            if (index == 9) {
                return tile.getTint(4);
            }
            if (this.platformType.isAddon()) {
                index -= 2;
            }
            return tile.getTint(index - 1);
        }
        return 0xFFFFFF;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile(world, pos);
        if (tile != null) {
            return ItemBlockPlatform.createStack(this, tile.getFrameTextureBlock(), tile.getCoverTextureBlock());
        }
        return new ItemStack((ItemLike)this);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        TileEntityPlatformBase tile = BlockPlatformBase.getTile(world, pos);
        if (tile != null) {
            if (player.m_6144_() && TileHelper.hasRail(tile)) {
                return tile.getRailItem();
            }
            return ItemBlockPlatform.createStack(this, tile.getFrameTextureBlock(), tile.getCoverTextureBlock());
        }
        return new ItemStack((ItemLike)this);
    }
}

