/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.Function;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.block.PropertySubType;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class BlockPlatformFloor
extends BlockPlatformBase {
    public static final PropertySubType SUBTYPE = PropertySubType.create("subtype", EnumSubType.getWalkwayValues());

    public BlockPlatformFloor() {
        super(EnumPlatformType.FLOOR);
    }

    @Override
    public PropertySubType getPropertySubType() {
        return SUBTYPE;
    }

    @Override
    protected VoxelShape buildShape(EnumSubType subType, Direction direction, EnumPlatformType railType, String linked, boolean collision) {
        if (!HITBOXES.isEmpty()) {
            VoxelShape[] parts = new VoxelShape[2];
            parts[0] = (VoxelShape)HITBOXES.get((Object)("floor_" + (collision ? "collide" : "select")), (Object)direction);
            return Shapes.m_83124_((VoxelShape)Shapes.m_83040_(), (VoxelShape[])((VoxelShape[])Arrays.stream(parts).filter(Objects::nonNull).toArray(VoxelShape[]::new)));
        }
        return null;
    }

    @Override
    protected void updateBlock(TileEntityPlatformBase tile, BlockState state, Level world, BlockPos pos) {
        AABB aabbDown;
        BlockState stateDown;
        Block blockDown;
        int altSupport = world.m_46859_(pos.m_7495_()) ? 2 : ((blockDown = (stateDown = world.m_8055_(pos.m_7495_())).m_60734_()) instanceof FenceBlock ? 1 : ((aabbDown = this.getShapeBoundingBox(stateDown.m_60808_((BlockGetter)world, pos.m_7495_()))) != null && aabbDown.f_82292_ >= 1.0 ? (aabbDown.f_82288_ > 0.0625 || aabbDown.f_82290_ > 0.0625 || aabbDown.f_82291_ < 0.9375 || aabbDown.f_82293_ < 0.9375 ? 1 : 0) : 2));
        TileHelper.setAltSupport((BlockEntity)tile, altSupport);
        Function.syncTile((BlockEntity)tile);
    }

    static {
        BlockPlatformFloor.addHitBoxData("floor_select", new double[][]{{0.0, 0.0, 0.0, 16.0, 16.0, 16.0}});
        BlockPlatformFloor.addHitBoxData("floor_collide", new double[][]{{0.0, 0.0, 0.0, 16.0, 16.0, 16.0}});
    }
}

