/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.init;

import cy.jdkdigital.productivebees.common.fluid.HoneyFluid;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="productivebees", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"productivebees");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"productivebees");
    public static final Material MATERIAL_HONEY = new Material.Builder(MaterialColor.f_76373_).m_76354_().m_76353_().m_76356_().m_76350_().m_76359_();
    public static final RegistryObject<ForgeFlowingFluid> HONEY = ModFluids.createFluid("honey", HoneyFluid.Source::new);
    public static final RegistryObject<ForgeFlowingFluid> HONEY_FLOWING = ModFluids.createFluid("flowing_honey", HoneyFluid.Flowing::new);
    public static RegistryObject<FluidType> HONEY_FLUID_TYPE = FLUID_TYPES.register("honey", () -> new FluidType(FluidType.Properties.create().canExtinguish(true).supportsBoating(true).motionScale(0.007)){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return HoneyFluid.STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return HoneyFluid.FLOWING;
                }

                public ResourceLocation getOverlayTexture() {
                    return HoneyFluid.OVERLAY;
                }

                public int getTintColor() {
                    return -14058;
                }
            });
        }
    });

    private static <B extends Fluid> RegistryObject<B> createFluid(String name, Supplier<? extends B> supplier) {
        return FLUIDS.register(name, supplier);
    }
}

