/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.rebornstorage.items;

import com.refinedmods.refinedstorage.api.network.item.INetworkItem;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemManager;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import com.refinedmods.refinedstorage.item.NetworkItem;
import java.util.List;
import java.util.function.Supplier;
import net.gigabit101.rebornstorage.grid.crafting.WirelessCraftingGridNetworkItem;
import net.gigabit101.rebornstorage.grid.fluid.WirelessFluidGridNetworkItemExt;
import net.gigabit101.rebornstorage.grid.monitor.WirelessCraftingMonitorNetworkItemExt;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemWirelessGrid
extends NetworkItem {
    Type type;

    public ItemWirelessGrid(Item.Properties item, Type type, Supplier<Integer> energyCapacity) {
        super(item, type == Type.CREATIVE, energyCapacity);
        this.type = type;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_6047_()) {
            ItemStack stack = player.m_21120_(hand);
            MODE current = this.getMode(stack);
            switch (current) {
                case CRAFTING: {
                    this.setMode(stack, MODE.FLUID);
                    player.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "MODE: " + MODE.FLUID.name())), true);
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                case FLUID: {
                    this.setMode(stack, MODE.MONITOR);
                    player.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "MODE: " + MODE.MONITOR.name())), true);
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                case MONITOR: {
                    this.setMode(stack, MODE.CRAFTING);
                    player.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "MODE: " + MODE.CRAFTING.name())), true);
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
            }
        }
        return super.m_7203_(level, player, hand);
    }

    public Type getType() {
        return this.type;
    }

    public void setMode(ItemStack stack, MODE mode) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("mode", mode.name());
    }

    public MODE getMode(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41784_();
        if (compoundTag.m_128441_("mode")) {
            return MODE.valueOf(compoundTag.m_128461_("mode"));
        }
        return MODE.CRAFTING;
    }

    @NotNull
    public INetworkItem provide(INetworkItemManager iNetworkItemManager, Player player, ItemStack itemStack, PlayerSlot playerSlot) {
        switch (this.getMode(itemStack)) {
            case CRAFTING: {
                return new WirelessCraftingGridNetworkItem(iNetworkItemManager, player, itemStack, playerSlot);
            }
            case FLUID: {
                return new WirelessFluidGridNetworkItemExt(iNetworkItemManager, player, itemStack, playerSlot);
            }
            case MONITOR: {
                return new WirelessCraftingMonitorNetworkItemExt(iNetworkItemManager, player, itemStack, playerSlot);
            }
        }
        return new WirelessCraftingGridNetworkItem(iNetworkItemManager, player, itemStack, playerSlot);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        try {
            tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "MODE: " + this.getMode(stack))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum Type {
        NORMAL,
        CREATIVE;

    }

    public static enum MODE {
        CRAFTING,
        FLUID,
        MONITOR;

    }
}

