/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.calculator;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.refinedmods.refinedstorage.api.autocrafting.task.CalculationResultType;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICalculationResult;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingRequestInfo;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.util.IStackList;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.CraftingPatternInputs;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.CraftingTask;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.calculator.CalculationResult;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.calculator.CraftingCalculatorException;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.calculator.PossibleInputs;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.CraftingNode;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.Node;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.NodeList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.ProcessingNode;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.preview.CraftingPreviewElementFactory;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.preview.CraftingPreviewInfo;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class CraftingCalculator {
    private final INetwork network;
    private final ICraftingRequestInfo requested;
    private final int quantity;
    private final ICraftingPattern pattern;
    private final Set<ICraftingPattern> patternsUsed = new HashSet<ICraftingPattern>();
    private final CraftingPreviewInfo craftingPreviewInfo = new CraftingPreviewInfo();
    private final NodeList nodes = new NodeList();
    private final IStackList<ItemStack> toExtractInitial = API.instance().createItemStackList();
    private final IStackList<FluidStack> toExtractInitialFluids = API.instance().createFluidStackList();
    private long calculationStarted = -1L;

    public CraftingCalculator(INetwork network, ICraftingRequestInfo requested, int quantity, ICraftingPattern pattern) {
        this.network = network;
        this.requested = requested;
        this.quantity = quantity;
        this.pattern = pattern;
    }

    public ICalculationResult calculate() {
        this.calculationStarted = System.currentTimeMillis();
        IStackList<ItemStack> results = API.instance().createItemStackList();
        IStackList<FluidStack> fluidResults = API.instance().createFluidStackList();
        IStackList<ItemStack> storageSource = this.network.getItemStorageCache().getList().copy();
        IStackList<FluidStack> fluidStorageSource = this.network.getFluidStorageCache().getList().copy();
        int qtyPerCraft = this.getQuantityPerCraft(this.requested.getItem(), this.requested.getFluid(), this.pattern);
        int qty = (this.quantity - 1) / qtyPerCraft + 1;
        try {
            this.calculateInternal(qty, storageSource, fluidStorageSource, results, fluidResults, this.pattern, true);
        }
        catch (CraftingCalculatorException e) {
            return new CalculationResult(e.getType(), e.getRecursedPattern());
        }
        if (this.requested.getItem() != null) {
            this.craftingPreviewInfo.getToCraft().add(ItemHandlerHelper.copyStackWithSize((ItemStack)this.requested.getItem(), (int)(qty * qtyPerCraft)));
        } else if (this.requested.getFluid() != null) {
            this.craftingPreviewInfo.getToCraftFluids().add(StackUtils.copy(this.requested.getFluid(), qty * qtyPerCraft));
        }
        List<ICraftingPreviewElement> previewElements = new CraftingPreviewElementFactory().getElements(this.craftingPreviewInfo);
        if (this.craftingPreviewInfo.hasMissing()) {
            return new CalculationResult(CalculationResultType.MISSING, previewElements, null);
        }
        return new CalculationResult(CalculationResultType.OK, previewElements, new CraftingTask(this.network, this.requested, this.quantity, this.pattern, this.nodes, this.toExtractInitial, this.toExtractInitialFluids));
    }

    private void calculateInternal(int qty, IStackList<ItemStack> storageSource, IStackList<FluidStack> fluidStorageSource, IStackList<ItemStack> results, IStackList<FluidStack> fluidResults, ICraftingPattern pattern, boolean root) throws CraftingCalculatorException {
        if (System.currentTimeMillis() - this.calculationStarted > (long)RS.SERVER_CONFIG.getAutocrafting().getCalculationTimeoutMs()) {
            throw new CraftingCalculatorException(CalculationResultType.TOO_COMPLEX, null);
        }
        if (!this.patternsUsed.add(pattern)) {
            throw new CraftingCalculatorException(CalculationResultType.RECURSIVE, pattern);
        }
        IStackList<ItemStack> itemsToExtract = API.instance().createItemStackList();
        IStackList<FluidStack> fluidsToExtract = API.instance().createFluidStackList();
        CraftingPatternInputs inputs = new CraftingPatternInputs(pattern);
        Node node = this.nodes.createOrAddToExistingNode(pattern, root, inputs.getRecipe(), qty);
        this.calculateForItems(qty, storageSource, fluidStorageSource, results, fluidResults, itemsToExtract, inputs, node);
        if (node instanceof CraftingNode) {
            ItemStack output = pattern.getOutput(inputs.getRecipe());
            results.add(output, output.m_41613_() * qty);
            for (ItemStack byproduct : pattern.getByproducts(inputs.getRecipe())) {
                results.add(byproduct, byproduct.m_41613_() * qty);
            }
        } else if (node instanceof ProcessingNode) {
            ProcessingNode processing = (ProcessingNode)node;
            this.calculateForFluids(qty, storageSource, fluidStorageSource, results, fluidResults, inputs, fluidsToExtract, processing);
            for (ItemStack output : pattern.getOutputs()) {
                results.add(output, output.m_41613_() * qty);
            }
            for (ItemStack output : pattern.getFluidOutputs()) {
                fluidResults.add((FluidStack)output, output.getAmount() * qty);
            }
        }
        this.patternsUsed.remove(pattern);
    }

    private void calculateForItems(int qty, IStackList<ItemStack> storageSource, IStackList<FluidStack> fluidStorageSource, IStackList<ItemStack> results, IStackList<FluidStack> fluidResults, IStackList<ItemStack> itemsToExtract, CraftingPatternInputs inputs, Node node) throws CraftingCalculatorException {
        int ingredientNumber = -1;
        for (CraftingPatternInputs.Ingredient<ItemStack> ingredient : inputs.getItemIngredients()) {
            ++ingredientNumber;
            PossibleInputs<ItemStack> possibleInputs = new PossibleInputs<ItemStack>((List<ItemStack>)ingredient.getInputs());
            possibleInputs.sort(storageSource, results);
            ItemStack possibleInput = possibleInputs.get();
            ItemStack fromSelf = results.get(possibleInput);
            ItemStack fromNetwork = storageSource.get(possibleInput);
            int remaining = ingredient.getCount() * qty;
            if (remaining < 0) {
                throw new CraftingCalculatorException(CalculationResultType.TOO_COMPLEX);
            }
            while (remaining > 0) {
                int toTake;
                if (fromSelf != null) {
                    toTake = Math.min(remaining, fromSelf.m_41613_());
                    node.getRequirements().addItemRequirement(ingredientNumber, possibleInput, toTake, ingredient.getCount());
                    results.remove(fromSelf, toTake);
                    remaining -= toTake;
                    fromSelf = results.get(possibleInput);
                }
                if (fromNetwork != null && remaining > 0) {
                    toTake = Math.min(remaining, fromNetwork.m_41613_());
                    this.craftingPreviewInfo.getToTake().add(possibleInput, toTake);
                    node.getRequirements().addItemRequirement(ingredientNumber, possibleInput, toTake, ingredient.getCount());
                    storageSource.remove(fromNetwork, toTake);
                    remaining -= toTake;
                    fromNetwork = storageSource.get(possibleInput);
                    this.toExtractInitial.add(possibleInput, toTake);
                }
                if (remaining <= 0) continue;
                ICraftingPattern subPattern = this.network.getCraftingManager().getPattern(possibleInput);
                if (subPattern != null) {
                    int qtyPerCraft = this.getQuantityPerCraft(possibleInput, null, subPattern);
                    int subQty = (remaining - 1) / qtyPerCraft + 1;
                    this.calculateInternal(subQty, storageSource, fluidStorageSource, results, fluidResults, subPattern, false);
                    fromSelf = results.get(possibleInput);
                    if (fromSelf == null) {
                        throw new IllegalStateException("Recursive calculation didn't yield anything");
                    }
                    fromNetwork = storageSource.get(possibleInput);
                    this.craftingPreviewInfo.getToCraft().add(fromSelf.m_41777_());
                    continue;
                }
                if (!possibleInputs.cycle()) {
                    possibleInput = possibleInputs.get();
                    this.craftingPreviewInfo.getMissing().add(possibleInput, remaining);
                    itemsToExtract.add(possibleInput, remaining);
                    remaining = 0;
                    continue;
                }
                possibleInput = possibleInputs.get();
                fromSelf = results.get(possibleInput);
                fromNetwork = storageSource.get(possibleInput);
            }
        }
    }

    private void calculateForFluids(int qty, IStackList<ItemStack> storageSource, IStackList<FluidStack> fluidStorageSource, IStackList<ItemStack> results, IStackList<FluidStack> fluidResults, CraftingPatternInputs inputs, IStackList<FluidStack> fluidsToExtract, ProcessingNode node) throws CraftingCalculatorException {
        int ingredientNumber = -1;
        for (CraftingPatternInputs.Ingredient<FluidStack> ingredient : inputs.getFluidIngredients()) {
            ++ingredientNumber;
            PossibleInputs<FluidStack> possibleInputs = new PossibleInputs<FluidStack>((List<FluidStack>)ingredient.getInputs());
            possibleInputs.sort(fluidStorageSource, fluidResults);
            FluidStack possibleInput = possibleInputs.get();
            FluidStack fromSelf = fluidResults.get(possibleInput, 1);
            FluidStack fromNetwork = fluidStorageSource.get(possibleInput, 1);
            int remaining = ingredient.getCount() * qty;
            if (remaining < 0) {
                throw new CraftingCalculatorException(CalculationResultType.TOO_COMPLEX);
            }
            while (remaining > 0) {
                int toTake;
                if (fromSelf != null) {
                    toTake = Math.min(remaining, fromSelf.getAmount());
                    node.getRequirements().addFluidRequirement(ingredientNumber, possibleInput, toTake, ingredient.getCount());
                    fluidResults.remove(possibleInput, toTake);
                    remaining -= toTake;
                    fromSelf = fluidResults.get(possibleInput, 1);
                }
                if (fromNetwork != null && remaining > 0) {
                    toTake = Math.min(remaining, fromNetwork.getAmount());
                    node.getRequirements().addFluidRequirement(ingredientNumber, possibleInput, toTake, ingredient.getCount());
                    this.craftingPreviewInfo.getToTakeFluids().add(possibleInput, toTake);
                    fluidStorageSource.remove(fromNetwork, toTake);
                    remaining -= toTake;
                    fromNetwork = fluidStorageSource.get(possibleInput, 1);
                    this.toExtractInitialFluids.add(possibleInput, toTake);
                }
                if (remaining <= 0) continue;
                ICraftingPattern subPattern = this.network.getCraftingManager().getPattern(possibleInput);
                if (subPattern != null) {
                    int qtyPerCraft = this.getQuantityPerCraft(null, possibleInput, subPattern);
                    int subQty = (remaining - 1) / qtyPerCraft + 1;
                    this.calculateInternal(subQty, storageSource, fluidStorageSource, results, fluidResults, subPattern, false);
                    fromSelf = fluidResults.get(possibleInput, 1);
                    if (fromSelf == null) {
                        throw new IllegalStateException("Recursive fluid calculation didn't yield anything");
                    }
                    fromNetwork = fluidStorageSource.get(possibleInput, 1);
                    this.craftingPreviewInfo.getToCraftFluids().add(fromSelf.copy());
                    continue;
                }
                if (!possibleInputs.cycle()) {
                    possibleInput = possibleInputs.get();
                    this.craftingPreviewInfo.getMissingFluids().add(possibleInput, remaining);
                    fluidsToExtract.add(possibleInput, remaining);
                    remaining = 0;
                    continue;
                }
                possibleInput = possibleInputs.get();
                fromSelf = fluidResults.get(possibleInput);
                fromNetwork = fluidStorageSource.get(possibleInput);
            }
        }
    }

    private int getQuantityPerCraft(@Nullable ItemStack item, @Nullable FluidStack fluid, ICraftingPattern pattern) {
        if (item != null) {
            return this.getQuantityPerCraftForItem(item, pattern);
        }
        if (fluid != null) {
            return this.getQuantityPerCraftForFluid(fluid, pattern);
        }
        return 0;
    }

    private int getQuantityPerCraftForFluid(FluidStack fluid, ICraftingPattern pattern) {
        int qty = 0;
        for (FluidStack output : pattern.getFluidOutputs()) {
            if (!API.instance().getComparer().isEqual(output, fluid, 1)) continue;
            qty += output.getAmount();
        }
        return qty;
    }

    private int getQuantityPerCraftForItem(ItemStack item, ICraftingPattern pattern) {
        int qty = 0;
        for (ItemStack output : pattern.getOutputs()) {
            if (!API.instance().getComparer().isEqualNoQuantity(output, item)) continue;
            qty += output.m_41613_();
            if (pattern.isProcessing()) continue;
            break;
        }
        return qty;
    }
}

