/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.IoUtil;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.Node;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.NodeList;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.node.NodeListener;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CraftingNode
extends Node {
    private static final String NBT_RECIPE = "Recipe";
    private final NonNullList<ItemStack> recipe;

    public CraftingNode(ICraftingPattern pattern, boolean root, NonNullList<ItemStack> recipe) {
        super(pattern, root);
        this.recipe = recipe;
    }

    public CraftingNode(INetwork network, CompoundTag tag) throws CraftingTaskReadException {
        super(network, tag);
        this.recipe = NonNullList.m_122779_();
        ListTag tookList = tag.m_128437_(NBT_RECIPE, 10);
        for (int i = 0; i < tookList.size(); ++i) {
            this.recipe.add((Object)StackUtils.deserializeStackFromNbt(tookList.m_128728_(i)));
        }
    }

    @Override
    public void update(INetwork network, int ticks, NodeList nodes, IStorageDisk<ItemStack> internalStorage, IStorageDisk<FluidStack> internalFluidStorage, NodeListener listener) {
        block0: for (ICraftingPatternContainer container : network.getCraftingManager().getAllContainers(this.getPattern())) {
            int interval = container.getUpdateInterval();
            if (interval < 0) {
                throw new IllegalStateException(container + " has an update interval of < 0");
            }
            if (interval != 0 && ticks % interval != 0) continue;
            for (int i = 0; i < container.getMaximumSuccessfulCraftingUpdates(); ++i) {
                List<ItemStack> simulatedRequirements = this.requirements.getSingleItemRequirementSet(true);
                if (simulatedRequirements == null) {
                    return;
                }
                if (IoUtil.extractFromInternalItemStorage(simulatedRequirements, internalStorage, Action.SIMULATE) == null) continue block0;
                List<ItemStack> actualRequirements = this.requirements.getSingleItemRequirementSet(false);
                if (actualRequirements == null) {
                    return;
                }
                IoUtil.extractFromInternalItemStorage(actualRequirements, internalStorage, Action.PERFORM);
                ItemStack output = this.getPattern().getOutput(this.recipe);
                if (!this.isRoot()) {
                    internalStorage.insert(output, output.m_41613_(), Action.PERFORM);
                } else {
                    ItemStack remainder = network.insertItem(output, output.m_41613_(), Action.PERFORM);
                    internalStorage.insert(remainder, remainder.m_41613_(), Action.PERFORM);
                }
                for (ItemStack byp : this.getPattern().getByproducts(this.recipe)) {
                    internalStorage.insert(byp, byp.m_41613_(), Action.PERFORM);
                }
                this.next();
                listener.onSingleDone(this);
                if (this.getQuantity() > 0) continue;
                listener.onAllDone(this);
                return;
            }
        }
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag tag = super.writeToNbt();
        ListTag tookList = new ListTag();
        for (ItemStack took : this.recipe) {
            tookList.add((Object)StackUtils.serializeStackToNbt(took));
        }
        tag.m_128365_(NBT_RECIPE, (Tag)tookList);
        return tag;
    }
}

