/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingRequestInfo;
import com.refinedmods.refinedstorage.api.network.grid.IGridTab;
import com.refinedmods.refinedstorage.api.render.IElementDrawer;
import com.refinedmods.refinedstorage.api.render.IElementDrawers;
import com.refinedmods.refinedstorage.api.util.IFilter;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.render.CraftingMonitorElementDrawers;
import com.refinedmods.refinedstorage.apiimpl.render.ElementDrawers;
import com.refinedmods.refinedstorage.blockentity.craftingmonitor.ICraftingMonitor;
import com.refinedmods.refinedstorage.container.CraftingMonitorContainerMenu;
import com.refinedmods.refinedstorage.network.craftingmonitor.CraftingMonitorCancelMessage;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.screen.widget.TabListWidget;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CraftingMonitorScreen
extends BaseScreen<CraftingMonitorContainerMenu> {
    private static final int ROWS = 5;
    private static final int ITEM_WIDTH = 73;
    private static final int ITEM_HEIGHT = 29;
    private final ScrollbarWidget scrollbar;
    private final ICraftingMonitor craftingMonitor;
    private final TabListWidget<CraftingMonitorContainerMenu> tabs;
    private final IElementDrawers drawers = new CraftingMonitorElementDrawers(this, 73, 29);
    private Button cancelButton;
    private Button cancelAllButton;
    private List<IGridTab> tasks = Collections.emptyList();

    public CraftingMonitorScreen(CraftingMonitorContainerMenu containerMenu, Inventory inventory, Component title) {
        super(containerMenu, 254, 201, inventory, title);
        this.craftingMonitor = containerMenu.getCraftingMonitor();
        this.tabs = new TabListWidget<CraftingMonitorContainerMenu>(this, new ElementDrawers<CraftingMonitorContainerMenu>(this), () -> this.tasks, () -> (int)Math.floor((float)Math.max(0, this.tasks.size() - 1) / 7.0f), this.craftingMonitor::getTabPage, () -> {
            IGridTab tab = this.getCurrentTab();
            if (tab == null) {
                return -1;
            }
            return this.tasks.indexOf(tab);
        }, 7);
        this.tabs.addListener(new TabListWidget.ITabListListener(){

            @Override
            public void onSelectionChanged(int tab) {
                CraftingMonitorScreen.this.craftingMonitor.onTabSelectionChanged(Optional.of(((Task)CraftingMonitorScreen.this.tasks.get((int)tab)).id));
                CraftingMonitorScreen.this.scrollbar.setOffset(0);
            }

            @Override
            public void onPageChanged(int page) {
                CraftingMonitorScreen.this.craftingMonitor.onTabPageChanged(page);
            }
        });
        this.scrollbar = new ScrollbarWidget(this, 235, 20, 12, 149);
    }

    public void setTasks(List<IGridTab> tasks) {
        this.tasks = tasks;
    }

    public List<ICraftingMonitorElement> getElements() {
        if (!this.craftingMonitor.isActiveOnClient()) {
            return Collections.emptyList();
        }
        IGridTab tab = this.getCurrentTab();
        if (tab == null) {
            return Collections.emptyList();
        }
        return ((Task)tab).elements;
    }

    @Override
    public void onPostInit(int x, int y) {
        this.tabs.init(this.f_97726_);
        if (this.craftingMonitor.getRedstoneModeParameter() != null) {
            this.addSideButton(new RedstoneModeSideButton(this, this.craftingMonitor.getRedstoneModeParameter()));
        }
        MutableComponent cancel = Component.m_237115_((String)"gui.cancel");
        MutableComponent cancelAll = Component.m_237115_((String)"misc.refinedstorage.cancel_all");
        int cancelButtonWidth = 14 + this.f_96547_.m_92895_(cancel.getString());
        int cancelAllButtonWidth = 14 + this.f_96547_.m_92895_(cancelAll.getString());
        this.cancelButton = this.addButton(x + 7, y + 201 - 20 - 7, cancelButtonWidth, 20, (Component)cancel, false, true, btn -> {
            if (this.hasValidTabSelected()) {
                RS.NETWORK_HANDLER.sendToServer(new CraftingMonitorCancelMessage(((Task)this.getCurrentTab()).id));
            }
        });
        this.cancelAllButton = this.addButton(x + 7 + cancelButtonWidth + 4, y + 201 - 20 - 7, cancelAllButtonWidth, 20, (Component)cancelAll, false, true, btn -> {
            if (!this.tasks.isEmpty()) {
                RS.NETWORK_HANDLER.sendToServer(new CraftingMonitorCancelMessage(null));
            }
        });
    }

    private void updateScrollbar() {
        if (this.scrollbar != null) {
            this.scrollbar.setEnabled(this.getRows() > 5);
            this.scrollbar.setMaxOffset(this.getRows() - 5);
        }
    }

    private int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.getElements().size() / 3.0f));
    }

    @Override
    public void tick(int x, int y) {
        this.updateScrollbar();
        this.tabs.update();
        if (this.cancelButton != null) {
            this.cancelButton.f_93623_ = this.hasValidTabSelected();
        }
        if (this.cancelAllButton != null) {
            this.cancelAllButton.f_93623_ = !this.tasks.isEmpty();
        }
    }

    private boolean hasValidTabSelected() {
        return this.getCurrentTab() != null;
    }

    @Nullable
    private IGridTab getCurrentTab() {
        IGridTab tab;
        Optional<UUID> currentTab = this.craftingMonitor.getTabSelected();
        if (currentTab.isPresent() && (tab = this.getTabById(currentTab.get())) != null) {
            return tab;
        }
        if (this.tasks.isEmpty()) {
            return null;
        }
        return this.tasks.get(0);
    }

    @Nullable
    private IGridTab getTabById(UUID id) {
        return this.tasks.stream().filter(t -> ((Task)t).id.equals(id)).findFirst().orElse(null);
    }

    @Override
    public void renderBackground(PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
        if (this.craftingMonitor.isActiveOnClient()) {
            this.tabs.drawBackground(poseStack, x, y - this.tabs.getHeight());
        }
        this.bindTexture("refinedstorage", "gui/crafting_preview.png");
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.scrollbar.render(poseStack);
        this.tabs.drawForeground(poseStack, x, y - this.tabs.getHeight(), mouseX, mouseY, this.craftingMonitor.isActiveOnClient());
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY) {
        this.renderString(poseStack, 7, 7, this.f_96539_.getString());
        int item = this.scrollbar != null ? this.scrollbar.getOffset() * 3 : 0;
        Lighting.m_84931_();
        int x = 7;
        int y = 20;
        List<Component> tooltip = null;
        for (int i = 0; i < 15; ++i) {
            if (item < this.getElements().size()) {
                ICraftingMonitorElement element = this.getElements().get(item);
                element.draw(poseStack, x, y, this.drawers);
                if (RenderUtils.inBounds(x, y, 73, 29, mouseX, mouseY)) {
                    tooltip = element.getTooltip();
                }
                if ((i + 1) % 3 == 0) {
                    x = 7;
                    y += 30;
                } else {
                    x += 74;
                }
            }
            ++item;
        }
        if (tooltip != null && !tooltip.isEmpty()) {
            this.renderTooltip(poseStack, ItemStack.f_41583_, mouseX, mouseY, tooltip);
        }
        this.tabs.drawTooltip(poseStack, this.f_96547_, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickedButton) {
        if (this.tabs.mouseClicked()) {
            return true;
        }
        if (this.scrollbar.m_6375_(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, clickedButton);
    }

    public void m_94757_(double mx, double my) {
        this.scrollbar.m_94757_(mx, my);
        super.m_94757_(mx, my);
    }

    public boolean m_6348_(double mx, double my, int button) {
        return this.scrollbar.m_6348_(mx, my, button) || super.m_6348_(mx, my, button);
    }

    public boolean m_6050_(double x, double y, double delta) {
        return this.scrollbar.m_6050_(x, y, delta) || super.m_6050_(x, y, delta);
    }

    public static class Task
    implements IGridTab {
        private final UUID id;
        private final ICraftingRequestInfo requested;
        private final int qty;
        private final long executionStarted;
        private final int completionPercentage;
        private final List<ICraftingMonitorElement> elements;

        public Task(UUID id, ICraftingRequestInfo requested, int qty, long executionStarted, int completionPercentage, List<ICraftingMonitorElement> elements) {
            this.id = id;
            this.requested = requested;
            this.qty = qty;
            this.executionStarted = executionStarted;
            this.completionPercentage = completionPercentage;
            this.elements = elements;
        }

        @Override
        public void drawTooltip(PoseStack poseStack, int x, int y, Screen screen) {
            ArrayList lines = Lists.newArrayList((Object[])new Component[]{this.requested.getItem() != null ? this.requested.getItem().m_41786_() : this.requested.getFluid().getDisplayName()});
            int totalSecs = (int)(System.currentTimeMillis() - this.executionStarted) / 1000;
            int hours = totalSecs / 3600;
            int minutes = totalSecs % 3600 / 60;
            int seconds = totalSecs % 60;
            lines.add(Component.m_237110_((String)"gui.refinedstorage.crafting_monitor.tooltip.requested", (Object[])new Object[]{this.requested.getFluid() != null ? API.instance().getQuantityFormatter().formatInBucketForm(this.qty) : API.instance().getQuantityFormatter().format(this.qty)}).m_130940_(ChatFormatting.GRAY));
            if (hours > 0) {
                lines.add(Component.m_237113_((String)String.format("%02d:%02d:%02d", hours, minutes, seconds)).m_130940_(ChatFormatting.GRAY));
            } else {
                lines.add(Component.m_237113_((String)String.format("%02d:%02d", minutes, seconds)).m_130940_(ChatFormatting.GRAY));
            }
            lines.add(Component.m_237113_((String)String.format("%d%%", this.completionPercentage)).m_130940_(ChatFormatting.GRAY));
            screen.m_96597_(poseStack, (List)lines, x, y);
        }

        @Override
        public List<IFilter> getFilters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void drawIcon(PoseStack poseStack, int x, int y, IElementDrawer<ItemStack> itemDrawer, IElementDrawer<FluidStack> fluidDrawer) {
            if (this.requested.getItem() != null) {
                Lighting.m_84931_();
                itemDrawer.draw(poseStack, x, y, this.requested.getItem());
            } else {
                fluidDrawer.draw(poseStack, x, y, this.requested.getFluid());
            }
        }
    }
}

