/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import reliquary.items.ToggleableItem;
import reliquary.items.util.fluid.FluidHandlerEmperorChalice;
import reliquary.reference.Settings;
import reliquary.util.TooltipBuilder;

public class EmperorChaliceItem
extends ToggleableItem {
    public EmperorChaliceItem() {
        super(new Item.Properties().m_41487_(1).setNoRepair().m_41497_(Rarity.EPIC));
        MinecraftForge.EVENT_BUS.addListener(this::onBlockRightClick);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack stack, @Nullable Level world, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.description(this, ".tooltip2", new Object[0]);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public int m_8105_(ItemStack stack) {
        return 16;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidHandlerEmperorChalice(stack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entityLiving) {
        if (world.f_46443_) {
            return stack;
        }
        if (!(entityLiving instanceof Player)) {
            return stack;
        }
        Player player = (Player)entityLiving;
        int multiplier = (Integer)Settings.COMMON.items.emperorChalice.hungerSatiationMultiplier.get();
        player.m_36324_().m_38707_(1, (float)multiplier / 2.0f);
        player.m_6469_(DamageSource.f_19312_, (float)multiplier);
        return stack;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack emperorChalice = player.m_21120_(hand);
        if (player.m_6144_()) {
            return super.m_7203_(world, player, hand);
        }
        boolean isInDrainMode = this.isEnabled(emperorChalice);
        BlockHitResult result = EmperorChaliceItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)(isInDrainMode ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (result == null || result.m_6662_() == HitResult.Type.MISS) {
            if (!this.isEnabled(emperorChalice)) {
                player.m_6672_(hand);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)emperorChalice);
        }
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            if (!world.m_7966_(player, result.m_82425_()) || !player.m_36204_(result.m_82425_(), result.m_82434_(), emperorChalice)) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)emperorChalice);
            }
            if (emperorChalice.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(fluidHandler -> {
                if (!this.isEnabled(emperorChalice)) {
                    return this.placeWater(world, player, hand, (IFluidHandlerItem)fluidHandler, result);
                }
                return FluidUtil.tryPickUpFluid((ItemStack)emperorChalice, (Player)player, (Level)world, (BlockPos)result.m_82425_(), (Direction)result.m_82434_()).isSuccess();
            }).orElse(false).booleanValue()) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)emperorChalice);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)emperorChalice);
    }

    private boolean placeWater(Level world, Player player, InteractionHand hand, IFluidHandlerItem fluidHandler, BlockHitResult result) {
        if (FluidUtil.tryPlaceFluid((Player)player, (Level)world, (InteractionHand)hand, (BlockPos)result.m_82425_(), (IFluidHandler)fluidHandler, (FluidStack)new FluidStack((Fluid)Fluids.f_76193_, 1000))) {
            return true;
        }
        return FluidUtil.tryPlaceFluid((Player)player, (Level)world, (InteractionHand)hand, (BlockPos)result.m_82425_().m_121945_(result.m_82434_()), (IFluidHandler)fluidHandler, (FluidStack)new FluidStack((Fluid)Fluids.f_76193_, 1000));
    }

    private void onBlockRightClick(PlayerInteractEvent.RightClickBlock evt) {
        if (evt.getItemStack().m_41720_() == this) {
            Level world = evt.getLevel();
            BlockState state = world.m_8055_(evt.getPos());
            if (!this.isEnabled(evt.getItemStack()) && state.m_60734_() == Blocks.f_50256_) {
                this.fillCauldron(evt, world);
            } else if (this.isEnabled(evt.getItemStack()) && state.m_60734_() == Blocks.f_152476_ && ((LayeredCauldronBlock)state.m_60734_()).m_142596_(state)) {
                this.emptyCauldron(evt, world);
            }
        }
    }

    private void emptyCauldron(PlayerInteractEvent.RightClickBlock evt, Level world) {
        world.m_46597_(evt.getPos(), Blocks.f_50256_.m_49966_());
        this.cancelEvent(evt);
    }

    private void fillCauldron(PlayerInteractEvent.RightClickBlock evt, Level world) {
        world.m_46597_(evt.getPos(), (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)));
        this.cancelEvent(evt);
    }

    private void cancelEvent(PlayerInteractEvent.RightClickBlock evt) {
        evt.setUseItem(Event.Result.DENY);
        evt.setCanceled(true);
        evt.setCancellationResult(InteractionResult.SUCCESS);
    }
}

