/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.google.common.collect.ImmutableList;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.features.configs.NbtFeatureConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class NbtFeature
extends Feature<NbtFeatureConfig> {
    private final BlockIgnoreProcessor IGNORE_STRUCTURE_VOID = new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.f_50454_));
    private final StructurePlaceSettings placementsettings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74383_((StructureProcessor)this.IGNORE_STRUCTURE_VOID).m_74392_(false);

    public NbtFeature() {
        super(NbtFeatureConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<NbtFeatureConfig> context) {
        ResourceLocation nbtRL;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)context.m_159777_());
        mutable.m_122173_(Direction.UP);
        while (context.m_159774_().m_46859_((BlockPos)mutable) && mutable.m_123342_() > 2) {
            mutable.m_122173_(Direction.DOWN);
        }
        if (context.m_159774_().m_8055_((BlockPos)mutable).m_60795_() || context.m_159774_().m_46859_(mutable.m_7495_()) || context.m_159774_().m_46859_(mutable.m_6625_(2))) {
            return false;
        }
        mutable.m_122173_(Direction.DOWN);
        if (((NbtFeatureConfig)context.m_159778_()).nbtResourcelocationsAndWeights.size() == 0) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos();
        StructureTemplateManager templatemanager = context.m_159774_().m_6018_().m_7654_().m_236738_();
        Optional template = templatemanager.m_230407_(nbtRL = (ResourceLocation)GeneralUtils.getRandomEntry(((NbtFeatureConfig)context.m_159778_()).nbtResourcelocationsAndWeights, context.m_225041_()));
        if (template.isEmpty()) {
            RepurposedStructures.LOGGER.warn(((NbtFeatureConfig)context.m_159778_()).nbtResourcelocationsAndWeights.toString() + " NTB does not exist!");
            return false;
        }
        int radius = ((StructureTemplate)template.get()).m_163801_().m_123341_() / 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z >= radius * radius + 1) continue;
                blockpos$Mutable.m_122190_((Vec3i)context.m_159777_()).m_122184_(x, 0, z);
                if (!((NbtFeatureConfig)context.m_159778_()).allowInWater && !context.m_159774_().m_6425_((BlockPos)blockpos$Mutable).m_76178_()) {
                    return false;
                }
                if (!context.m_159774_().m_8055_((BlockPos)blockpos$Mutable.m_122173_(Direction.UP)).m_60815_() && context.m_159774_().m_8055_((BlockPos)blockpos$Mutable.m_122175_(Direction.DOWN, 3)).m_60815_()) continue;
                return false;
            }
        }
        BlockPos halfLengths = new BlockPos(((StructureTemplate)template.get()).m_163801_().m_123341_() / 2, 0, ((StructureTemplate)template.get()).m_163801_().m_123343_() / 2);
        this.placementsettings.m_74379_(Rotation.m_221990_((RandomSource)context.m_225041_())).m_74385_(halfLengths).m_74392_(false);
        if (((NbtFeatureConfig)context.m_159778_()).processor != null) {
            context.m_159774_().m_5962_().m_175515_(Registry.f_122883_).m_6612_(((NbtFeatureConfig)context.m_159778_()).processor).ifPresent(processor -> processor.m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)this.placementsettings).m_74383_(arg_0)));
        }
        blockpos$Mutable.m_122190_((Vec3i)context.m_159777_());
        BlockPos offset = new BlockPos(-((StructureTemplate)template.get()).m_163801_().m_123341_() / 2, ((NbtFeatureConfig)context.m_159778_()).heightOffset, -((StructureTemplate)template.get()).m_163801_().m_123343_() / 2);
        ((StructureTemplate)template.get()).m_230328_((ServerLevelAccessor)context.m_159774_(), blockpos$Mutable.m_121955_((Vec3i)offset), blockpos$Mutable.m_121955_((Vec3i)offset), this.placementsettings, context.m_225041_(), 2);
        return true;
    }
}

