/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.client;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderGlowEffect;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.client.RenderSettings;
import mcjty.rftoolsbase.RFToolsBase;
import mcjty.rftoolsbase.api.client.IHudSupport;
import mcjty.rftoolsbase.modules.hud.client.HudRenderer;
import mcjty.rftoolsbase.modules.various.items.SmartWrenchItem;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.blocks.EndergenicTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class EndergenicRenderer
implements BlockEntityRenderer<EndergenicTileEntity> {
    public static final ResourceLocation HALO = new ResourceLocation("rftoolspower", "block/endergenic/floatingpearl");
    public static final ResourceLocation WHITEFLASH = new ResourceLocation("rftoolspower", "block/endergenic/whiteflash");
    public static final ResourceLocation BLACKFLASH = new ResourceLocation("rftoolspower", "block/endergenic/redflash");
    public static final ResourceLocation REDGLOW = new ResourceLocation("rftoolspower", "block/endergenic/redglow");
    public static final ResourceLocation BLUEGLOW = new ResourceLocation("rftoolspower", "block/endergenic/blueglow");
    public static final RenderSettings FLASH_SETTINGS = RenderSettings.builder().color(255, 255, 255).alpha(128).renderType(CustomRenderTypes.m_110466_()).build();

    public EndergenicRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(EndergenicTileEntity tileEntity, float partialTicks, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        boolean showOverlay;
        BlockPos coord = tileEntity.m_58899_();
        if (coord.equals((Object)RFToolsBase.instance.clientInfo.getSelectedTE())) {
            RenderGlowEffect.renderGlow((PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (ResourceLocation)REDGLOW);
        } else if (coord.equals((Object)RFToolsBase.instance.clientInfo.getDestinationTE())) {
            RenderGlowEffect.renderGlow((PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (ResourceLocation)BLUEGLOW);
        }
        float s = (float)(System.currentTimeMillis() % 1000L) / 1000.0f;
        if (s > 0.5f) {
            s = 1.0f - s;
        }
        RenderHelper.renderBillboardQuadBright((PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (float)(0.2f + s * 0.3f), (ResourceLocation)HALO);
        if (tileEntity.getGoodCounter() > 0) {
            RenderHelper.renderBillboardQuadBright((PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (float)(0.8f * ((float)tileEntity.getGoodCounter() / 10.0f)), (ResourceLocation)WHITEFLASH, (RenderSettings)FLASH_SETTINGS);
        }
        if (tileEntity.getBadCounter() > 0) {
            RenderHelper.renderBillboardQuadBright((PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (float)(0.8f * ((float)tileEntity.getBadCounter() / 20.0f)), (ResourceLocation)BLACKFLASH, (RenderSettings)FLASH_SETTINGS);
        }
        ItemStack mainHand = Minecraft.m_91087_().f_91074_.m_21205_();
        ItemStack offHand = Minecraft.m_91087_().f_91074_.m_21206_();
        boolean bl = showOverlay = !mainHand.m_41619_() && mainHand.m_41720_() instanceof SmartWrenchItem || !offHand.m_41619_() && offHand.m_41720_() instanceof SmartWrenchItem;
        if (showOverlay) {
            HudRenderer.renderHud((PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (IHudSupport)tileEntity);
        }
    }

    public static void register() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)EndergenicModule.TYPE_ENDERGENIC.get()), EndergenicRenderer::new);
    }
}

