/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import java.util.Objects;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;

public class ItemStackScreenModule
implements IScreenModule<ModuleDataStacks> {
    private int slot1 = -1;
    private int slot2 = -1;
    private int slot3 = -1;
    private int slot4 = -1;
    protected ResourceKey<Level> dim = Level.f_46428_;
    protected BlockPos coordinate = BlockPosTools.INVALID;

    public ModuleDataStacks getData(IScreenDataHelper helper, Level worldObj, long millis) {
        ServerLevel world = LevelTools.getLevel((Level)worldObj, this.dim);
        if (world == null) {
            return null;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)this.coordinate)) {
            return null;
        }
        BlockEntity te = world.m_7702_(this.coordinate);
        if (te == null) {
            return null;
        }
        return CapabilityTools.getItemCapabilitySafe((BlockEntity)te).map(h -> {
            ItemStack stack1 = this.getItemStack((IItemHandler)h, this.slot1);
            ItemStack stack2 = this.getItemStack((IItemHandler)h, this.slot2);
            ItemStack stack3 = this.getItemStack((IItemHandler)h, this.slot3);
            ItemStack stack4 = this.getItemStack((IItemHandler)h, this.slot4);
            return new ModuleDataStacks(stack1, stack2, stack3, stack4);
        }).orElse(null);
    }

    private ItemStack getItemStack(Container inventory, int slot) {
        if (slot == -1) {
            return ItemStack.f_41583_;
        }
        if (slot < inventory.m_6643_()) {
            return inventory.m_8020_(slot);
        }
        return ItemStack.f_41583_;
    }

    private ItemStack getItemStack(IItemHandler itemHandler, int slot) {
        if (slot == -1) {
            return ItemStack.f_41583_;
        }
        if (slot < itemHandler.getSlots()) {
            return itemHandler.getStackInSlot(slot);
        }
        return ItemStack.f_41583_;
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
            if (tagCompound.m_128441_("slot1")) {
                this.slot1 = tagCompound.m_128451_("slot1");
            }
            if (tagCompound.m_128441_("slot2")) {
                this.slot2 = tagCompound.m_128451_("slot2");
            }
            if (tagCompound.m_128441_("slot3")) {
                this.slot3 = tagCompound.m_128451_("slot3");
            }
            if (tagCompound.m_128441_("slot4")) {
                this.slot4 = tagCompound.m_128451_("slot4");
            }
        }
    }

    protected void setupCoordinateFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        if (tagCompound.m_128441_("monitorx")) {
            this.dim = LevelTools.getId((String)tagCompound.m_128461_("monitordim"));
            if (Objects.equals(dim, this.dim)) {
                BlockPos c = new BlockPos(tagCompound.m_128451_("monitorx"), tagCompound.m_128451_("monitory"), tagCompound.m_128451_("monitorz"));
                int dx = Math.abs(c.m_123341_() - pos.m_123341_());
                int dy = Math.abs(c.m_123342_() - pos.m_123342_());
                int dz = Math.abs(c.m_123343_() - pos.m_123343_());
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.ITEMSTACK_RFPERTICK.get();
    }

    public void mouseClick(Level world, int x, int y, boolean clicked, Player player) {
    }

    public static class ModuleDataStacks
    implements IModuleData {
        public static final String ID = "rftoolsutility:itemStacks";
        private final ItemStack[] stacks = new ItemStack[4];

        public String getId() {
            return ID;
        }

        public ModuleDataStacks(ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack stack4) {
            this.stacks[0] = stack1;
            this.stacks[1] = stack2;
            this.stacks[2] = stack3;
            this.stacks[3] = stack4;
        }

        public ModuleDataStacks(FriendlyByteBuf buf) {
            for (int i = 0; i < 4; ++i) {
                this.stacks[i] = NetworkTools.readItemStack((FriendlyByteBuf)buf);
            }
        }

        public ItemStack getStack(int idx) {
            return this.stacks[idx];
        }

        public void writeToBuf(FriendlyByteBuf buf) {
            this.writeStack(buf, this.stacks[0]);
            this.writeStack(buf, this.stacks[1]);
            this.writeStack(buf, this.stacks[2]);
            this.writeStack(buf, this.stacks[3]);
        }

        private void writeStack(FriendlyByteBuf buf, ItemStack stack) {
            NetworkTools.writeItemStack((FriendlyByteBuf)buf, (ItemStack)stack);
        }
    }
}

