/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.data;

import java.util.function.BiConsumer;
import java.util.function.Function;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import net.minecraft.network.FriendlyByteBuf;

public class TeleportDestinationClientInfo
extends TeleportDestination
implements Comparable<TeleportDestinationClientInfo> {
    private String dimensionName = "";
    private boolean favorite = false;

    public TeleportDestinationClientInfo(FriendlyByteBuf buf) {
        super(buf);
        this.setDimensionName(buf.m_130136_(Short.MAX_VALUE));
        this.setFavorite(buf.readBoolean());
    }

    public TeleportDestinationClientInfo(TeleportDestination destination) {
        super(destination.getCoordinate(), destination.getDimension());
        this.setName(destination.getName());
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.m_130070_(this.getDimensionName());
        buf.writeBoolean(this.favorite);
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public void setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    @Override
    public int compareTo(TeleportDestinationClientInfo o) {
        if (this.getDimension().compareTo(o.getDimension()) < 0) {
            return -1;
        }
        if (this.getDimension().compareTo(o.getDimension()) > 0) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TeleportDestinationClientInfo that = (TeleportDestinationClientInfo)o;
        if (this.favorite != that.favorite) {
            return false;
        }
        return !(this.dimensionName != null ? !this.dimensionName.equals(that.dimensionName) : that.dimensionName != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dimensionName != null ? this.dimensionName.hashCode() : 0);
        result = 31 * result + (this.favorite ? 1 : 0);
        return result;
    }

    public static class Serializer
    implements ISerializer<TeleportDestinationClientInfo> {
        public Function<FriendlyByteBuf, TeleportDestinationClientInfo> getDeserializer() {
            return TeleportDestinationClientInfo::new;
        }

        public BiConsumer<FriendlyByteBuf, TeleportDestinationClientInfo> getSerializer() {
            return (buf, s) -> s.toBytes((FriendlyByteBuf)buf);
        }
    }
}

