/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.rftoolsutility.modules.screen.MachineInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketReturnRfInRange {
    private final Map<BlockPos, MachineInfo> levels;
    public static Map<BlockPos, MachineInfo> clientLevels;

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.levels.size());
        for (Map.Entry<BlockPos, MachineInfo> entry : this.levels.entrySet()) {
            buf.m_130064_(entry.getKey());
            MachineInfo info = entry.getValue();
            buf.writeLong(info.energy());
            buf.writeLong(info.maxEnergy());
            if (info.energyPerTick() != null) {
                buf.writeBoolean(true);
                buf.writeLong(info.energyPerTick().longValue());
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public Map<BlockPos, MachineInfo> getLevels() {
        return this.levels;
    }

    public PacketReturnRfInRange(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.levels = new HashMap<BlockPos, MachineInfo>(size);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = buf.m_130135_();
            long e = buf.readLong();
            long m = buf.readLong();
            Long usage = null;
            if (buf.readBoolean()) {
                usage = buf.readLong();
            }
            this.levels.put(pos, new MachineInfo(e, m, usage));
        }
    }

    public PacketReturnRfInRange(Map<BlockPos, MachineInfo> levels) {
        this.levels = levels;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            clientLevels = this.levels;
        });
        ctx.setPacketHandled(true);
    }
}

