/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class DimmerSwitchBlock
extends SwitchBlock {
    public static final IntegerProperty POWER = IntegerProperty.m_61631_((String)"power", (int)0, (int)15);

    public DimmerSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config | 0xFFL, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWER});
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean was_powered;
        if (!(state.m_60734_() instanceof DimmerSwitchBlock)) {
            return InteractionResult.FAIL;
        }
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        SwitchBlock.SwitchTileEntity te = this.getTe((LevelReader)world, pos);
        if (te == null) {
            return InteractionResult.FAIL;
        }
        te.click_config(null, false);
        SwitchBlock.ClickInteraction ck = SwitchBlock.ClickInteraction.get(state, world, pos, player, hand, hit);
        boolean bl = was_powered = te.setpower() != 0;
        if (ck.touch_configured) {
            int p = (int)ck.y;
            if (p != te.setpower()) {
                te.setpower(p);
                p = te.setpower();
                Overlay.show(player, (Component)Auxiliaries.localizable("switchconfig.dimmerswitch.output_power", ChatFormatting.RED, new Object[]{p}));
                int state_p = (Integer)state.m_61143_((Property)POWER);
                if (state_p != p) {
                    world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(p))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(p > 0)), 27);
                    this.notifyNeighbours(world, pos, state, te, false);
                    te.m_6596_();
                }
                if (was_powered && p == 0) {
                    this.power_off_sound.play(world, pos);
                } else {
                    this.power_on_sound.play(world, pos);
                }
                if (state_p != p && (this.config & 0x100000000000000L) != 0L && !te.activateSwitchLinks(p, p > 0 ? 15 : 0, state_p == 0 != (p == 0))) {
                    ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
                }
            }
        } else if (ck.wrenched) {
            if (te.click_config(this, false)) {
                Overlay.show(player, (Component)te.configStatusTextComponentTranslation((SwitchBlock)state.m_60734_()));
            }
        } else if (ck.item == ModContent.SWITCH_LINK_PEARL) {
            this.m_6256_(state, world, pos, player);
        }
        return InteractionResult.CONSUME;
    }
}

