/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.libmc.detail;

import com.mojang.blaze3d.platform.InputConstants;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;
import wile.rsgauges.libmc.detail.SidedProxy;

public class Auxiliaries {
    private static String modid;
    private static Logger logger;
    private static Supplier<CompoundTag> server_config_supplier;

    public static void init(String modid, Logger logger, Supplier<CompoundTag> server_config_supplier) {
        Auxiliaries.modid = modid;
        Auxiliaries.logger = logger;
        Auxiliaries.server_config_supplier = server_config_supplier;
    }

    public static String modid() {
        return modid;
    }

    public static Logger logger() {
        return logger;
    }

    public static boolean isModLoaded(String registry_name) {
        return ModList.get().isLoaded(registry_name);
    }

    public static boolean isDevelopmentMode() {
        return SharedConstants.f_136183_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isShiftDown() {
        return InputConstants.m_84830_((long)SidedProxy.mc().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)SidedProxy.mc().m_91268_().m_85439_(), (int)344);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isCtrlDown() {
        return InputConstants.m_84830_((long)SidedProxy.mc().m_91268_().m_85439_(), (int)341) || InputConstants.m_84830_((long)SidedProxy.mc().m_91268_().m_85439_(), (int)345);
    }

    public static void logInfo(String msg) {
        logger.info(msg);
    }

    public static void logWarn(String msg) {
        logger.warn(msg);
    }

    public static void logError(String msg) {
        logger.error(msg);
    }

    public static MutableComponent localizable(String modtrkey, Object ... args) {
        return Component.m_237110_((String)(modtrkey.startsWith("block.") || modtrkey.startsWith("item.") ? modtrkey : modid + "." + modtrkey), (Object[])args);
    }

    public static MutableComponent localizable(String modtrkey, @Nullable ChatFormatting color, Object ... args) {
        MutableComponent tr = Component.m_237110_((String)(modid + "." + modtrkey), (Object[])args);
        if (color != null) {
            tr.m_130940_(color);
        }
        return tr;
    }

    public static MutableComponent localizable(String modtrkey) {
        return Auxiliaries.localizable(modtrkey, new Object[0]);
    }

    public static MutableComponent localizable_block_key(String blocksubkey) {
        return Component.m_237115_((String)("block." + modid + "." + blocksubkey));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String localize(String translationKey, Object ... args) {
        MutableComponent tr = Component.m_237110_((String)translationKey, (Object[])args);
        tr.m_130940_(ChatFormatting.RESET);
        String ft = tr.getString();
        if (ft.contains("${")) {
            Pattern pt = Pattern.compile("\\$\\{([^}]+)\\}");
            Matcher mt = pt.matcher(ft);
            StringBuffer sb = new StringBuffer();
            while (mt.find()) {
                String m = mt.group(1);
                if (m.contains("?")) {
                    String[] kv = m.split("\\?", 2);
                    String key = kv[0].trim();
                    boolean not = key.startsWith("!");
                    if (not) {
                        key = key.replaceFirst("!", "");
                    }
                    m = kv[1].trim();
                    if (!server_config_supplier.get().m_128441_(key)) {
                        m = "";
                    } else {
                        boolean r = server_config_supplier.get().m_128471_(key);
                        if (not) {
                            boolean bl = r = !r;
                        }
                        if (!r) {
                            m = "";
                        }
                    }
                }
                mt.appendReplacement(sb, Matcher.quoteReplacement(Component.m_237115_((String)m).getString().trim()));
            }
            mt.appendTail(sb);
            return sb.toString();
        }
        return ft;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasTranslation(String key) {
        return I18n.m_118936_((String)key);
    }

    public static void playerChatMessage(Player player, String message) {
        String s = message.trim();
        if (!s.isEmpty()) {
            player.m_213846_((Component)Component.m_237115_((String)s));
        }
    }

    @Nullable
    public static Component unserializeTextComponent(String serialized) {
        return Component.Serializer.m_130701_((String)serialized);
    }

    public static String serializeTextComponent(Component tc) {
        return tc == null ? "" : Component.Serializer.m_130703_((Component)tc);
    }

    public static boolean isInItemTag(Item item, ResourceLocation tag) {
        return ForgeRegistries.ITEMS.tags().stream().filter(tg -> tg.getKey().f_203868_().equals((Object)tag)).anyMatch(tk -> tk.contains((Object)item));
    }

    public static boolean isInBlockTag(Block block, ResourceLocation tag) {
        return ForgeRegistries.BLOCKS.tags().stream().filter(tg -> tg.getKey().f_203868_().equals((Object)tag)).anyMatch(tk -> tk.contains((Object)block));
    }

    @Nullable
    public static Component getItemLabel(ItemStack stack) {
        CompoundTag nbt = stack.m_41737_("display");
        if (nbt != null && nbt.m_128425_("Name", 8)) {
            try {
                Component tc = Auxiliaries.unserializeTextComponent(nbt.m_128461_("Name"));
                if (tc != null) {
                    return tc;
                }
                nbt.m_128473_("Name");
            }
            catch (Exception e) {
                nbt.m_128473_("Name");
            }
        }
        return null;
    }

    public static ItemStack setItemLabel(ItemStack stack, @Nullable Component name) {
        if (name != null) {
            CompoundTag nbt = stack.m_41698_("display");
            nbt.m_128359_("Name", Auxiliaries.serializeTextComponent(name));
        } else if (stack.m_41782_()) {
            stack.m_41749_("display");
        }
        return stack;
    }

    public static boolean isWaterLogged(BlockState state) {
        return state.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false;
    }

    public static AABB getPixeledAABB(double x0, double y0, double z0, double x1, double y1, double z1) {
        return new AABB(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0);
    }

    public static AABB getRotatedAABB(AABB bb, Direction new_facing) {
        return Auxiliaries.getRotatedAABB(bb, new_facing, false);
    }

    public static AABB[] getRotatedAABB(AABB[] bb, Direction new_facing) {
        return Auxiliaries.getRotatedAABB(bb, new_facing, false);
    }

    public static AABB getRotatedAABB(AABB bb, Direction new_facing, boolean horizontal_rotation) {
        if (!horizontal_rotation) {
            switch (new_facing.m_122411_()) {
                case 0: {
                    return new AABB(1.0 - bb.f_82291_, bb.f_82290_, bb.f_82289_, 1.0 - bb.f_82288_, bb.f_82293_, bb.f_82292_);
                }
                case 1: {
                    return new AABB(1.0 - bb.f_82291_, 1.0 - bb.f_82293_, 1.0 - bb.f_82292_, 1.0 - bb.f_82288_, 1.0 - bb.f_82290_, 1.0 - bb.f_82289_);
                }
                case 2: {
                    return new AABB(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
                }
                case 3: {
                    return new AABB(1.0 - bb.f_82291_, bb.f_82289_, 1.0 - bb.f_82293_, 1.0 - bb.f_82288_, bb.f_82292_, 1.0 - bb.f_82290_);
                }
                case 4: {
                    return new AABB(bb.f_82290_, bb.f_82289_, 1.0 - bb.f_82291_, bb.f_82293_, bb.f_82292_, 1.0 - bb.f_82288_);
                }
                case 5: {
                    return new AABB(1.0 - bb.f_82293_, bb.f_82289_, bb.f_82288_, 1.0 - bb.f_82290_, bb.f_82292_, bb.f_82291_);
                }
            }
        } else {
            switch (new_facing.m_122411_()) {
                case 0: {
                    return new AABB(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
                }
                case 1: {
                    return new AABB(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
                }
                case 2: {
                    return new AABB(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
                }
                case 3: {
                    return new AABB(1.0 - bb.f_82291_, bb.f_82289_, 1.0 - bb.f_82293_, 1.0 - bb.f_82288_, bb.f_82292_, 1.0 - bb.f_82290_);
                }
                case 4: {
                    return new AABB(bb.f_82290_, bb.f_82289_, 1.0 - bb.f_82291_, bb.f_82293_, bb.f_82292_, 1.0 - bb.f_82288_);
                }
                case 5: {
                    return new AABB(1.0 - bb.f_82293_, bb.f_82289_, bb.f_82288_, 1.0 - bb.f_82290_, bb.f_82292_, bb.f_82291_);
                }
            }
        }
        return bb;
    }

    public static AABB[] getRotatedAABB(AABB[] bbs, Direction new_facing, boolean horizontal_rotation) {
        AABB[] transformed = new AABB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getRotatedAABB(bbs[i], new_facing, horizontal_rotation);
        }
        return transformed;
    }

    public static AABB getYRotatedAABB(AABB bb, int clockwise_90deg_steps) {
        Direction[] direction_map = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        return Auxiliaries.getRotatedAABB(bb, direction_map[clockwise_90deg_steps + 4096 & 3], true);
    }

    public static AABB[] getYRotatedAABB(AABB[] bbs, int clockwise_90deg_steps) {
        AABB[] transformed = new AABB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getYRotatedAABB(bbs[i], clockwise_90deg_steps);
        }
        return transformed;
    }

    public static AABB getMirroredAABB(AABB bb, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new AABB(1.0 - bb.f_82291_, bb.f_82289_, bb.f_82290_, 1.0 - bb.f_82288_, bb.f_82292_, bb.f_82293_);
            case Direction.Axis.Y -> new AABB(bb.f_82288_, 1.0 - bb.f_82292_, bb.f_82290_, bb.f_82291_, 1.0 - bb.f_82289_, bb.f_82293_);
            case Direction.Axis.Z -> new AABB(bb.f_82288_, bb.f_82289_, 1.0 - bb.f_82293_, bb.f_82291_, bb.f_82292_, 1.0 - bb.f_82290_);
        };
    }

    public static AABB[] getMirroredAABB(AABB[] bbs, Direction.Axis axis) {
        AABB[] transformed = new AABB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getMirroredAABB(bbs[i], axis);
        }
        return transformed;
    }

    public static VoxelShape getUnionShape(AABB ... aabbs) {
        VoxelShape shape = Shapes.m_83040_();
        for (AABB aabb : aabbs) {
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    public static VoxelShape getUnionShape(AABB[] ... aabb_list) {
        VoxelShape shape = Shapes.m_83040_();
        AABB[][] aABBArray = aabb_list;
        int n = aABBArray.length;
        for (int i = 0; i < n; ++i) {
            AABB[] aabbs;
            for (AABB aabb : aabbs = aABBArray[i]) {
                shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82695_);
            }
        }
        return shape;
    }

    public static AABB[] getMappedAABB(AABB[] bbs, Function<AABB, AABB> mapper) {
        AABB[] transformed = new AABB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = mapper.apply(bbs[i]);
        }
        return transformed;
    }

    public static String loadResourceText(InputStream is) {
        try {
            if (is == null) {
                return "";
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            return br.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static String loadResourceText(String path) {
        return Auxiliaries.loadResourceText(Auxiliaries.class.getResourceAsStream(path));
    }

    public static void logGitVersion(String mod_name) {
        try {
            String version = Auxiliaries.loadResourceText("/.gitversion-" + modid).trim();
            Auxiliaries.logInfo(mod_name + (String)(version.isEmpty() ? " (dev build)" : " GIT id #" + version) + ".");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        server_config_supplier = CompoundTag::new;
    }

    public static final class BlockPosRange
    implements Iterable<BlockPos> {
        private final int x0;
        private final int x1;
        private final int y0;
        private final int y1;
        private final int z0;
        private final int z1;

        public BlockPosRange(int x0, int y0, int z0, int x1, int y1, int z1) {
            this.x0 = Math.min(x0, x1);
            this.x1 = Math.max(x0, x1);
            this.y0 = Math.min(y0, y1);
            this.y1 = Math.max(y0, y1);
            this.z0 = Math.min(z0, z1);
            this.z1 = Math.max(z0, z1);
        }

        public static BlockPosRange of(AABB range) {
            return new BlockPosRange((int)Math.floor(range.f_82288_), (int)Math.floor(range.f_82289_), (int)Math.floor(range.f_82290_), (int)Math.floor(range.f_82291_ - 0.0625), (int)Math.floor(range.f_82292_ - 0.0625), (int)Math.floor(range.f_82293_ - 0.0625));
        }

        public int getXSize() {
            return this.x1 - this.x0 + 1;
        }

        public int getYSize() {
            return this.y1 - this.y0 + 1;
        }

        public int getZSize() {
            return this.z1 - this.z0 + 1;
        }

        public int getArea() {
            return this.getXSize() * this.getZSize();
        }

        public int getHeight() {
            return this.getYSize();
        }

        public int getVolume() {
            return this.getXSize() * this.getYSize() * this.getZSize();
        }

        public BlockPos byXZYIndex(int xyz_index) {
            int xsz = this.getXSize();
            int ysz = this.getYSize();
            int zsz = this.getZSize();
            int y = (xyz_index %= xsz * ysz * zsz) / (xsz * zsz);
            int z = (xyz_index -= y * (xsz * zsz)) / xsz;
            int x = xyz_index -= z * xsz;
            return new BlockPos(this.x0 + x, this.y0 + y, this.z0 + z);
        }

        public BlockPos byXZIndex(int xz_index, int y_offset) {
            int xsz = this.getXSize();
            int zsz = this.getZSize();
            int z = (xz_index %= xsz * zsz) / xsz;
            int x = xz_index -= z * xsz;
            return new BlockPos(this.x0 + x, this.y0 + y_offset, this.z0 + z);
        }

        public BlockRangeIterator iterator() {
            return new BlockRangeIterator(this);
        }

        public Stream<BlockPos> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        public static final class BlockRangeIterator
        implements Iterator<BlockPos> {
            private final BlockPosRange range_;
            private int x;
            private int y;
            private int z;

            public BlockRangeIterator(BlockPosRange range) {
                this.range_ = range;
                this.x = range.x0;
                this.y = range.y0;
                this.z = range.z0;
            }

            @Override
            public boolean hasNext() {
                return this.z <= this.range_.z1;
            }

            @Override
            public BlockPos next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BlockPos pos = new BlockPos(this.x, this.y, this.z);
                ++this.x;
                if (this.x > this.range_.x1) {
                    this.x = this.range_.x0;
                    ++this.y;
                    if (this.y > this.range_.y1) {
                        this.y = this.range_.y0;
                        ++this.z;
                    }
                }
                return pos;
            }
        }
    }

    public static final class Tooltip {
        @OnlyIn(value=Dist.CLIENT)
        public static boolean extendedTipCondition() {
            return Auxiliaries.isShiftDown();
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean helpCondition() {
            return Auxiliaries.isShiftDown() && Auxiliaries.isCtrlDown();
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean addInformation(@Nullable String advancedTooltipTranslationKey, @Nullable String helpTranslationKey, List<Component> tooltip, TooltipFlag flag, boolean addAdvancedTooltipHints) {
            String[] tip_list;
            boolean tip_available;
            boolean help_available = helpTranslationKey != null && Auxiliaries.hasTranslation(helpTranslationKey + ".help");
            boolean bl = tip_available = advancedTooltipTranslationKey != null && Auxiliaries.hasTranslation(helpTranslationKey + ".tip");
            if (!help_available && !tip_available) {
                return false;
            }
            Object tip_text = "";
            if (Tooltip.helpCondition()) {
                if (help_available) {
                    tip_text = Auxiliaries.localize(helpTranslationKey + ".help", new Object[0]);
                }
            } else if (Tooltip.extendedTipCondition()) {
                if (tip_available) {
                    tip_text = Auxiliaries.localize(advancedTooltipTranslationKey + ".tip", new Object[0]);
                }
            } else if (addAdvancedTooltipHints) {
                if (tip_available) {
                    tip_text = (String)tip_text + Auxiliaries.localize(modid + ".tooltip.hint.extended", new Object[0]) + (help_available ? " " : "");
                }
                if (help_available) {
                    tip_text = (String)tip_text + Auxiliaries.localize(modid + ".tooltip.hint.help", new Object[0]);
                }
            }
            if (((String)tip_text).isEmpty()) {
                return false;
            }
            for (String tip : tip_list = ((String)tip_text).split("\\r?\\n")) {
                tooltip.add((Component)Component.m_237113_((String)tip.replaceAll("\\s+$", "").replaceAll("^\\s+", "")).m_130940_(ChatFormatting.GRAY));
            }
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean addInformation(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag, boolean addAdvancedTooltipHints) {
            return Tooltip.addInformation(stack.m_41778_(), stack.m_41778_(), tooltip, flag, addAdvancedTooltipHints);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean addInformation(String translation_key, List<Component> tooltip) {
            if (!Auxiliaries.hasTranslation(translation_key)) {
                return false;
            }
            tooltip.add((Component)Component.m_237113_((String)Auxiliaries.localize(translation_key, new Object[0]).replaceAll("\\s+$", "").replaceAll("^\\s+", "")).m_130940_(ChatFormatting.GRAY));
            return true;
        }
    }
}

