/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.serverconfigupdater;

import com.darkere.serverconfigupdater.ServerConfigUpdater;
import com.electronwill.nightconfig.core.utils.StringUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    private ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    private ForgeConfigSpec spec;
    private static final char versionToModIDSeparator = '=';
    private static final char modIDSeparator = ',';
    private ForgeConfigSpec.ConfigValue<List<? extends String>> history;
    private Map<Integer, String> versionhistory = new LinkedHashMap<Integer, String>();
    private ForgeConfigSpec.ConfigValue<List<? extends String>> filesToDelete;
    private ForgeConfigSpec.BooleanValue deleteFolders;

    public CommonConfig() {
        this.buildConfig();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    private void buildConfig() {
        this.builder.push("Version Configuration");
        this.history = this.builder.comment(" Define a version here. On world load the mod will look up the serverconfig version and reset all files that specified up to the newest version.\n Example: [\"1=minecraft\",\"2=forge\"] will reset minecraft and forge config on first load, but will only reset forge if the world has been loaded before with only version 1 defined").defineListAllowEmpty(List.of("versions"), () -> List.of(""), o -> true);
        this.builder.pop();
        this.builder.push("File Deleter");
        this.filesToDelete = this.builder.comment(" This is intended for deleting files for pack updates. This is a last resort! Replace with empty files instead when possible. The file will be deleted every launch if it exists! Specify the path to the file. Comma Separated List. Example: scripts/badscript.zs").defineListAllowEmpty(List.of("files"), () -> List.of(""), o -> true);
        this.deleteFolders = this.builder.comment(" By default Folders are only deleted if they are empty. Set to true to change that.").define("deleteFoldersWithContent", false);
        this.builder.pop();
        this.spec = this.builder.build();
    }

    public boolean shouldDeleteFolders() {
        return (Boolean)this.deleteFolders.get();
    }

    public List<Path> getFilesToDelete() {
        List files = (List)this.filesToDelete.get();
        if (files.isEmpty()) {
            return new ArrayList<Path>();
        }
        return files.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }

    public void readVersionhistory() {
        List list = (List)this.history.get();
        for (String s : list) {
            List strings;
            int version;
            if (s.isEmpty() || (version = Integer.parseInt((String)(strings = StringUtils.split((String)s, (char)'=')).get(0))) == 0) continue;
            this.versionhistory.put(version, (String)strings.get(1));
        }
    }

    public Set<String> getModIDsToReset() {
        int version = ServerConfigUpdater.SERVER_CONFIG.getCurrentVersion();
        HashSet<String> modIDs = new HashSet<String>();
        int maxversion = version;
        for (Map.Entry<Integer, String> entry : this.versionhistory.entrySet()) {
            if (entry.getKey() <= version) continue;
            maxversion = entry.getKey();
            List strings = StringUtils.split((String)entry.getValue(), (char)',');
            strings.forEach(s -> {
                s = s.trim();
            });
            modIDs.addAll(strings);
        }
        ServerConfigUpdater.SERVER_CONFIG.setVersion(maxversion);
        return modIDs;
    }
}

