/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiHelper {
    public static float zLevel = 0.0f;

    public static void setTexture(ResourceLocation texture) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    public static void setRenderSystem(ResourceLocation texture) {
        GuiHelper.setTexture(texture);
        GuiHelper.setRenderSystem();
    }

    public static void setRenderSystem() {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69465_();
        RenderSystem.m_69464_();
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
    }

    public static void resetRenderSystem() {
        RenderSystem.m_69461_();
        RenderSystem.m_69481_();
        RenderSystem.m_69482_();
    }

    public static void drawTexture(PoseStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV) {
        GuiHelper.drawTexturedQuad(matrixStack, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f);
    }

    public static void drawTexture(PoseStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, int textureWidth, int textureHeight) {
        GuiHelper.drawTexturedQuad(matrixStack, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight);
    }

    public static void drawTextureScaled(PoseStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale) {
        GuiHelper.drawTexturedQuad(matrixStack, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f);
    }

    public static void drawTextureScaled(PoseStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, int textureWidth, int textureHeight) {
        GuiHelper.drawTexturedQuad(matrixStack, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight);
    }

    private static void drawTexturedQuad(PoseStack matrixStack, double x0, double x1, double y0, double y1, float u0, float u1, float v0, float v1) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder renderer = Tesselator.m_85913_().m_85915_();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        renderer.m_85982_(matrix, (float)x0, (float)y1, zLevel).m_7421_(u0, v1).m_5752_();
        renderer.m_85982_(matrix, (float)x1, (float)y1, zLevel).m_7421_(u1, v1).m_5752_();
        renderer.m_85982_(matrix, (float)x1, (float)y0, zLevel).m_7421_(u1, v0).m_5752_();
        renderer.m_85982_(matrix, (float)x0, (float)y0, zLevel).m_7421_(u0, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)renderer.m_231175_());
    }

    public static void drawTextureMirrored(PoseStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV) {
        GuiHelper.drawMirroredTexturedQuad(matrixStack, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f);
    }

    public static void drawTextureMirrored(PoseStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, int textureWidth, int textureHeight) {
        GuiHelper.drawMirroredTexturedQuad(matrixStack, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight);
    }

    public static void drawTextureMirroredAndScaled(PoseStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale) {
        GuiHelper.drawMirroredTexturedQuad(matrixStack, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f);
    }

    public static void drawTextureMirroredAndScaled(PoseStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, int textureWidth, int textureHeight) {
        GuiHelper.drawMirroredTexturedQuad(matrixStack, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight);
    }

    private static void drawMirroredTexturedQuad(PoseStack matrixStack, double x0, double x1, double y0, double y1, float u0, float u1, float v0, float v1) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder renderer = Tesselator.m_85913_().m_85915_();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        renderer.m_85982_(matrix, (float)x0, (float)y1, zLevel).m_7421_(u1, v1).m_5752_();
        renderer.m_85982_(matrix, (float)x1, (float)y1, zLevel).m_7421_(u0, v1).m_5752_();
        renderer.m_85982_(matrix, (float)x1, (float)y0, zLevel).m_7421_(u0, v0).m_5752_();
        renderer.m_85982_(matrix, (float)x0, (float)y0, zLevel).m_7421_(u1, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)renderer.m_231175_());
    }

    public static void drawTextureInverted(PoseStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV) {
        GuiHelper.drawInvertedTexturedQuad(matrixStack, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f);
    }

    public static void drawTextureInverted(PoseStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, int textureWidth, int textureHeight) {
        GuiHelper.drawInvertedTexturedQuad(matrixStack, posX, posX + (double)sizeU, posY, posY + (double)sizeV, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight);
    }

    public static void drawTextureInvertedAndScaled(PoseStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale) {
        GuiHelper.drawInvertedTexturedQuad(matrixStack, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / 256.0f, (float)(posU + sizeU) / 256.0f, (float)posV / 256.0f, (float)(posV + sizeV) / 256.0f);
    }

    public static void drawTextureInvertedAndScaled(PoseStack matrixStack, double posX, double posY, int posU, int posV, int sizeU, int sizeV, double scale, int textureWidth, int textureHeight) {
        GuiHelper.drawInvertedTexturedQuad(matrixStack, posX, posX + (double)sizeU * scale, posY, posY + (double)sizeV * scale, (float)posU / (float)textureWidth, (float)(posU + sizeU) / (float)textureWidth, (float)posV / (float)textureHeight, (float)(posV + sizeV) / (float)textureHeight);
    }

    private static void drawInvertedTexturedQuad(PoseStack matrixStack, double x0, double x1, double y0, double y1, float u0, float u1, float v0, float v1) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder renderer = Tesselator.m_85913_().m_85915_();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        renderer.m_85982_(matrix, (float)x0, (float)y1, zLevel).m_7421_(u0, v0).m_5752_();
        renderer.m_85982_(matrix, (float)x1, (float)y1, zLevel).m_7421_(u1, v0).m_5752_();
        renderer.m_85982_(matrix, (float)x1, (float)y0, zLevel).m_7421_(u1, v1).m_5752_();
        renderer.m_85982_(matrix, (float)x0, (float)y0, zLevel).m_7421_(u0, v1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)renderer.m_231175_());
    }

    public static void drawHorizontalGradient(PoseStack matrixStack, double left, double top, double right, double bottom, int colorRight, int colorLeft) {
        GuiHelper.drawGradientRect(matrixStack, left, top, right, bottom, colorRight, colorLeft, colorLeft, colorRight);
    }

    public static void drawGradientRect(PoseStack matrixStack, double left, double top, double right, double bottom, int colorTop, int colorBottom) {
        GuiHelper.drawGradientRect(matrixStack, left, top, right, bottom, colorTop, colorTop, colorBottom, colorBottom);
    }

    public static void drawRect(PoseStack matrixStack, double left, double top, double right, double bottom, int color) {
        GuiHelper.drawGradientRect(matrixStack, left, top, right, bottom, color, color, color, color);
    }

    public static void drawGradientRect(PoseStack matrixStack, double left, double top, double right, double bottom, int colorTopRight, int colorTopLeft, int colorBottomLeft, int colorBottomRight) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder renderer = Tesselator.m_85913_().m_85915_();
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        renderer.m_85982_(matrix, (float)right, (float)top, zLevel).m_193479_(colorTopRight).m_5752_();
        renderer.m_85982_(matrix, (float)left, (float)top, zLevel).m_193479_(colorTopLeft).m_5752_();
        renderer.m_85982_(matrix, (float)left, (float)bottom, zLevel).m_193479_(colorBottomLeft).m_5752_();
        renderer.m_85982_(matrix, (float)right, (float)bottom, zLevel).m_193479_(colorBottomRight).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)renderer.m_231175_());
        RenderSystem.m_69493_();
    }

    public static void drawLine(PoseStack matrixStack, double x1, double y1, double x2, double y2, float width, int color) {
        GuiHelper.drawLine(matrixStack, x1, y1, x2, y2, width, color, color);
    }

    public static void drawLine(PoseStack matrixStack, double x1, double y1, double x2, double y2, float width, int color1, int color2) {
        width /= 2.0f;
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder renderer = Tesselator.m_85913_().m_85915_();
        renderer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        if (y1 == y2) {
            renderer.m_85982_(matrix, (float)x1, (float)y1 - width, zLevel).m_193479_(color1).m_5752_();
            renderer.m_85982_(matrix, (float)x2, (float)y2 - width, zLevel).m_193479_(color2).m_5752_();
            renderer.m_85982_(matrix, (float)x1, (float)y1 + width, zLevel).m_193479_(color1).m_5752_();
            renderer.m_85982_(matrix, (float)x2, (float)y2 + width, zLevel).m_193479_(color2).m_5752_();
        } else if (x1 == x2) {
            renderer.m_85982_(matrix, (float)x1 - width, (float)y1, zLevel).m_193479_(color1).m_5752_();
            renderer.m_85982_(matrix, (float)x2 - width, (float)y2, zLevel).m_193479_(color2).m_5752_();
            renderer.m_85982_(matrix, (float)x1 + width, (float)y1, zLevel).m_193479_(color1).m_5752_();
            renderer.m_85982_(matrix, (float)x2 + width, (float)y2, zLevel).m_193479_(color2).m_5752_();
        } else {
            double angle = Math.abs(Math.atan2(y2 - y1, x2 - x1));
            double percentage = angle % 0.7853981633974483 / 0.7853981633974483;
            int sector = (int)(angle / 0.7853981633974483);
            float xWidth = (float)((double)width * (sector == 0 ? percentage : (sector == 3 ? 1.0 - percentage : 1.0)));
            float yWidth = (float)((double)width * (sector == 1 ? 1.0 - percentage : (sector == 2 ? percentage : 1.0)));
            if (y1 < y2 && x1 < x2 || y1 > y2 && x1 > x2) {
                renderer.m_85982_(matrix, (float)x1 + xWidth, (float)y1 - yWidth, zLevel).m_193479_(color1).m_5752_();
                renderer.m_85982_(matrix, (float)x2 + xWidth, (float)y2 - yWidth, zLevel).m_193479_(color2).m_5752_();
                renderer.m_85982_(matrix, (float)x1 - xWidth, (float)y1 + yWidth, zLevel).m_193479_(color1).m_5752_();
                renderer.m_85982_(matrix, (float)x2 - xWidth, (float)y2 + yWidth, zLevel).m_193479_(color2).m_5752_();
            } else {
                renderer.m_85982_(matrix, (float)x1 - xWidth, (float)y1 - yWidth, zLevel).m_193479_(color1).m_5752_();
                renderer.m_85982_(matrix, (float)x2 - xWidth, (float)y2 - yWidth, zLevel).m_193479_(color2).m_5752_();
                renderer.m_85982_(matrix, (float)x1 + xWidth, (float)y1 + yWidth, zLevel).m_193479_(color1).m_5752_();
                renderer.m_85982_(matrix, (float)x2 + xWidth, (float)y2 + yWidth, zLevel).m_193479_(color2).m_5752_();
            }
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)renderer.m_231175_());
        RenderSystem.m_69493_();
    }
}

