/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal;

import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.core.internal.Roster;

public class RecipeRGB16
extends CustomRecipe {
    public RecipeRGB16(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inv, Level world) {
        int dyeCount = 0;
        ItemStack rgb16 = ItemStack.f_41583_;
        for (int index = 0; index < inv.m_6643_(); ++index) {
            ItemStack invStack = inv.m_8020_(index);
            if (this.isValid(invStack)) {
                if (invStack.m_41720_() instanceof IRGB16_Item) {
                    if (rgb16.m_41619_()) {
                        rgb16 = invStack.m_41777_();
                        continue;
                    }
                    return false;
                }
                ++dyeCount;
                continue;
            }
            if (invStack.m_41619_()) continue;
            return false;
        }
        if (!rgb16.m_41619_() && dyeCount > 0) {
            return RGB16StackHelper.getRGB16Index(this.assemble(inv)) != RGB16StackHelper.getRGB16Index(rgb16);
        }
        return false;
    }

    private boolean isValid(ItemStack stack) {
        return !stack.m_41619_() && (stack.m_41720_() instanceof IRGB16_Item && ((IRGB16_Item)stack.m_41720_()).enableDyeRecipe(stack) || DyeHelper.isDye(stack));
    }

    public ItemStack assemble(CraftingContainer inv) {
        ItemStack stack = ItemStack.f_41583_;
        ArrayList<ItemStack> dye = new ArrayList<ItemStack>();
        for (int index = 0; index < inv.m_6643_(); ++index) {
            ItemStack invStack = inv.m_8020_(index);
            if (invStack.m_41619_() || !this.isValid(invStack)) continue;
            if (invStack.m_41720_() instanceof IRGB16_Item) {
                stack = invStack.m_41777_();
                stack.m_41764_(1);
                continue;
            }
            dye.add(invStack);
        }
        if (!stack.m_41619_()) {
            IRGB16_Item item = (IRGB16_Item)stack.m_41720_();
            RGB16 rgb16 = RGB16StackHelper.getRGB16(stack);
            short startingIndex = item.getStartingIndex(stack);
            if (rgb16 == null) {
                rgb16 = new RGB16(startingIndex);
            }
            boolean first = true;
            for (ItemStack dyeStack : dye) {
                if (first && rgb16.getIndex() == startingIndex) {
                    rgb16.setValues(DyeHelper.getDyeName(dyeStack));
                } else {
                    rgb16.add(DyeHelper.getDyeName(dyeStack));
                }
                first = false;
            }
            RGB16StackHelper.setRGB16(stack, rgb16);
        }
        return stack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Roster.RecipeSerializers.RGB16_COLORIZE.get();
    }
}

