/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.smithing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.ForgeHooks;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.crafting.recipe.smithing.GearSmithingRecipe;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.SgRecipes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class UpgradeSmithingRecipe
extends GearSmithingRecipe {
    public UpgradeSmithingRecipe(ResourceLocation recipeIdIn, ItemStack gearItem, Ingredient additionIn) {
        super(recipeIdIn, gearItem, additionIn);
    }

    @Override
    protected ItemStack applyUpgrade(ItemStack gear, ItemStack upgradeItem) {
        GearType gearType;
        PartData part = PartData.from(upgradeItem);
        if (part != null && (gearType = GearHelper.getType(gear)).isGear() && part.get().canAddToGear(gear, part) && !GearData.hasPart(gear, part.get())) {
            ItemStack result = gear.m_41777_();
            GearData.addPart(result, part);
            GearData.recalculateStats(result, ForgeHooks.getCraftingPlayer());
            return result;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SgRecipes.SMITHING_UPGRADE.get();
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeSmithingRecipe> {
        public UpgradeSmithingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack gearItem = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"gear"));
            Ingredient upgradeItem = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"addition"));
            return new UpgradeSmithingRecipe(recipeId, gearItem, upgradeItem);
        }

        public UpgradeSmithingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ItemStack itemstack = buffer.m_130267_();
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new UpgradeSmithingRecipe(recipeId, itemstack, ingredient1);
        }

        public void toNetwork(FriendlyByteBuf buffer, UpgradeSmithingRecipe recipe) {
            buffer.m_130055_(recipe.gearItem);
            recipe.f_44519_.m_43923_(buffer);
        }
    }
}

