/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.item.blueprint.BlueprintType;
import net.silentchaos512.gear.item.blueprint.IBlueprint;
import net.silentchaos512.gear.util.TextUtil;

public abstract class AbstractBlueprintItem
extends Item
implements IBlueprint {
    final boolean singleUse;

    AbstractBlueprintItem(Item.Properties properties, boolean singleUse) {
        super(properties);
        this.singleUse = singleUse;
    }

    public abstract TagKey<Item> getItemTag();

    protected abstract Component getCraftedName(ItemStack var1);

    public boolean isSingleUse() {
        return this.singleUse;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack copy = itemStack.m_41777_();
        copy.m_41764_(1);
        return copy;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return !this.singleUse;
    }

    boolean isDisabled() {
        BlueprintType config = (BlueprintType)((Object)Config.Common.blueprintTypes.get());
        return this.singleUse && !config.allowTemplate() || !this.singleUse && !config.allowBlueprint();
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.isDisabled()) {
            super.m_6787_(group, items);
        }
    }

    public Component m_7626_(ItemStack stack) {
        String key = "item.silentgear." + (this.singleUse ? "template" : "blueprint");
        return Component.m_237110_((String)key, (Object[])new Object[]{this.getCraftedName(stack)});
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.singleUse ? Rarity.COMMON : Rarity.UNCOMMON;
    }

    public boolean hasStandardModel() {
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flags) {
        if (!this.isDisabled()) {
            if (((Boolean)Config.Client.showJeiHints.get()).booleanValue()) {
                if (ModList.get().isLoaded("jei")) {
                    tooltip.add((Component)TextUtil.translate("item", "blueprint.jeiTip").m_130940_(ChatFormatting.AQUA));
                } else {
                    tooltip.add((Component)TextUtil.misc("jeiNotInstalled", new Object[0]).m_130940_(ChatFormatting.DARK_RED));
                }
            }
            if (((Boolean)Config.Common.allowLegacyMaterialMixing.get()).booleanValue()) {
                tooltip.add((Component)TextUtil.translate("item", "blueprint.mixing.enabled").m_130940_(ChatFormatting.GREEN));
            } else {
                tooltip.add((Component)TextUtil.translate("item", "blueprint.mixing.disabled").m_130940_(ChatFormatting.RED));
            }
        }
    }
}

