/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.HashSet;
import java.util.Set;
import java.util.function.LongSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class CachedFailedInsertInventoryHandler
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable wrapped;
    private final LongSupplier timeSupplier;
    private long currentCacheTime = 0L;
    private final Set<ItemStack> failedInsertStacks = new HashSet<ItemStack>();

    public CachedFailedInsertInventoryHandler(IItemHandlerModifiable wrapped, LongSupplier timeSupplier) {
        this.wrapped = wrapped;
        this.timeSupplier = timeSupplier;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.wrapped.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.wrapped.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.wrapped.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.currentCacheTime != this.timeSupplier.getAsLong()) {
            this.failedInsertStacks.clear();
            this.currentCacheTime = this.timeSupplier.getAsLong();
        }
        if (this.failedInsertStacks.contains(stack)) {
            return stack;
        }
        ItemStack result = this.wrapped.insertItem(slot, stack, simulate);
        if (result == stack) {
            this.failedInsertStacks.add(stack);
        }
        return result;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.wrapped.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.wrapped.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.wrapped.isItemValid(slot, stack);
    }
}

