/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.spirit.data.traits;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.codexadrian.spirit.data.MobTrait;
import me.codexadrian.spirit.data.MobTraitSerializer;
import me.codexadrian.spirit.data.ToolType;
import me.codexadrian.spirit.entity.SoulArrowEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;

public record FireTrait(int burnTime) implements MobTrait<FireTrait>
{
    public static final Serializer SERIALIZER = new Serializer();

    @Override
    public void initializeArrow(SoulArrowEntity soulArrow) {
        soulArrow.m_20254_(this.burnTime());
    }

    @Override
    public void onHitEntity(ToolType type, Entity attacker, Entity victim) {
        if (type == ToolType.BOW) {
            return;
        }
        victim.m_20254_(this.burnTime());
    }

    @Override
    public void onHitBlock(ToolType type, Entity entity, BlockState blockState, Level level, BlockPos pos) {
        if (BaseFireBlock.m_49255_((Level)level, (BlockPos)pos.m_121945_(Direction.UP), (Direction)Direction.UP)) {
            level.m_7731_(pos.m_121945_(Direction.UP), BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos.m_121945_(Direction.UP)), 11);
        }
    }

    @Override
    public MobTraitSerializer<FireTrait> serializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements MobTraitSerializer<FireTrait> {
        public static final Codec<FireTrait> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("burnTime").orElse((Object)120).forGetter(FireTrait::burnTime)).apply((Applicative)instance, FireTrait::new));

        private Serializer() {
        }

        @Override
        public ResourceLocation id() {
            return new ResourceLocation("spirit", "fire");
        }

        @Override
        public Codec<FireTrait> codec() {
            return CODEC;
        }
    }
}

