/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blockentities.BlockEntityTagSubstitution;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlockPlacementResult;
import com.ldtteam.structurize.placement.StructureIterators;
import com.ldtteam.structurize.placement.StructurePhasePlacementResult;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.ChangeStorage;
import com.ldtteam.structurize.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StructurePlacer {
    protected final AbstractBlueprintIterator iterator;
    protected final IStructureHandler handler;

    public StructurePlacer(IStructureHandler handler) {
        this.iterator = StructureIterators.getIterator(((String)Structurize.getConfig().getServer().iteratorType.get()).toString(), handler);
        this.handler = handler;
    }

    public StructurePlacer(IStructureHandler handler, String id) {
        this.iterator = StructureIterators.getIterator(id, handler);
        this.handler = handler;
    }

    public StructurePhasePlacementResult executeStructureStep(Level world, ChangeStorage storage, BlockPos inputPos, Operation operation, Supplier<AbstractBlueprintIterator.Result> iterateFunction, boolean includeEntities) {
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
        if (includeEntities) {
            this.iterator.includeEntities();
        }
        this.iterator.setProgressPos(new BlockPos(inputPos.m_123341_(), inputPos.m_123342_(), inputPos.m_123343_()));
        AbstractBlueprintIterator.Result iterationResult = iterateFunction.get();
        BlockPos lastPos = inputPos;
        int count = 0;
        while (iterationResult == AbstractBlueprintIterator.Result.NEW_BLOCK) {
            BlockPlacementResult result;
            BlockPos localPos = this.iterator.getProgressPos();
            BlockPos worldPos = this.handler.getProgressPosInWorld(localPos);
            if (count >= this.handler.getStepsPerCall()) {
                return new StructurePhasePlacementResult(lastPos, new BlockPlacementResult(worldPos, BlockPlacementResult.Result.LIMIT_REACHED, requiredItems));
            }
            BlockState localState = this.handler.getBluePrint().getBlockState(localPos);
            if (localState == null || world.m_151570_(worldPos)) {
                lastPos = localPos;
                iterationResult = iterateFunction.get();
                continue;
            }
            if (storage != null) {
                storage.addPreviousDataFor(worldPos, world);
            }
            switch (operation) {
                case BLOCK_REMOVAL: {
                    if (!this.handler.isCreative() && !(world.m_8055_(worldPos).m_60734_() instanceof AirBlock)) {
                        result = new BlockPlacementResult(worldPos, BlockPlacementResult.Result.BREAK_BLOCK);
                        break;
                    }
                    world.m_7471_(worldPos, false);
                    result = new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
                    break;
                }
                case WATER_REMOVAL: {
                    BlockState worldState = world.m_8055_(worldPos);
                    if (worldState.m_60734_() instanceof BucketPickup || worldState.m_60734_() instanceof LiquidBlock || !worldState.m_60819_().m_76178_()) {
                        BlockUtils.removeFluid(world, worldPos);
                    }
                    result = new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
                    break;
                }
                case GET_RES_REQUIREMENTS: {
                    result = this.getResourceRequirements(world, worldPos, localPos, localState, this.handler.getBluePrint().getTileEntityData(worldPos, localPos));
                    requiredItems.addAll(result.getRequiredItems());
                    break;
                }
                default: {
                    result = this.handleBlockPlacement(world, worldPos, localPos, storage, localState, this.handler.getBluePrint().getTileEntityData(worldPos, localPos));
                }
            }
            ++count;
            if (storage != null) {
                storage.addPostDataFor(worldPos, world);
            }
            if (operation != Operation.GET_RES_REQUIREMENTS && (result.getResult() == BlockPlacementResult.Result.MISSING_ITEMS || result.getResult() == BlockPlacementResult.Result.FAIL || result.getResult() == BlockPlacementResult.Result.BREAK_BLOCK)) {
                return new StructurePhasePlacementResult(lastPos, result);
            }
            lastPos = localPos;
            iterationResult = iterateFunction.get();
            if (operation == Operation.GET_RES_REQUIREMENTS || count < this.handler.getStepsPerCall()) continue;
            return new StructurePhasePlacementResult(lastPos, result);
        }
        if (iterationResult == AbstractBlueprintIterator.Result.AT_END) {
            this.iterator.reset();
            return new StructurePhasePlacementResult(this.iterator.getProgressPos(), new BlockPlacementResult(this.iterator.getProgressPos(), BlockPlacementResult.Result.FINISHED, requiredItems));
        }
        return new StructurePhasePlacementResult(this.iterator.getProgressPos(), new BlockPlacementResult(this.handler.getProgressPosInWorld(this.iterator.getProgressPos()), BlockPlacementResult.Result.LIMIT_REACHED, requiredItems));
    }

    public BlockPlacementResult handleBlockPlacement(Level world, BlockPos worldPos, BlockPos localPos, ChangeStorage storage, BlockState localState, CompoundTag tileEntityData) {
        BlockState worldState = world.m_8055_(worldPos);
        boolean sameBlockInWorld = false;
        if (worldState.m_60734_() == localState.m_60734_() && tileEntityData == null) {
            sameBlockInWorld = true;
        }
        if (!(worldState.m_60734_() instanceof AirBlock) && !this.handler.allowReplace()) {
            return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.BREAK_BLOCK);
        }
        for (CompoundTag compound : this.iterator.getBluePrintPositionInfo(localPos).getEntities()) {
            if (compound == null) continue;
            try {
                Entity entity;
                BlockPos pos = this.handler.getWorldPos().m_121996_((Vec3i)this.handler.getBluePrint().getPrimaryBlockOffset());
                Optional type = EntityType.m_20637_((CompoundTag)compound);
                if (!type.isPresent() || (entity = ((EntityType)type.get()).m_20615_(world)) == null) continue;
                entity.deserializeNBT(compound);
                entity.m_20084_(UUID.randomUUID());
                Vec3 posInWorld = entity.m_20182_().m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                if (entity instanceof HangingEntity) {
                    HangingEntity hang = (HangingEntity)entity;
                    posInWorld = posInWorld.m_82546_(Vec3.m_82528_((Vec3i)hang.m_20183_().m_121996_((Vec3i)hang.m_31748_())));
                }
                entity.m_7678_(posInWorld.f_82479_, posInWorld.f_82480_, posInWorld.f_82481_, entity.m_146908_(), entity.m_146909_());
                List list = world.m_45976_(entity.getClass(), new AABB(posInWorld.m_82520_(1.0, 1.0, 1.0), posInWorld.m_82520_(-1.0, -1.0, -1.0)));
                boolean foundEntity = false;
                for (Entity worldEntity : list) {
                    if (!worldEntity.m_20182_().equals((Object)posInWorld)) continue;
                    foundEntity = true;
                    break;
                }
                if (foundEntity || entity instanceof Mob && !this.handler.isCreative()) continue;
                ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
                if (!this.handler.isCreative()) {
                    requiredItems.addAll(ItemStackUtils.getListOfStackForEntity(entity, pos));
                    if (!InventoryUtils.hasRequiredItems(this.handler.getInventory(), requiredItems)) {
                        return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
                    }
                }
                world.m_7967_(entity);
                if (storage != null) {
                    storage.addToBeKilledEntity(entity);
                }
                for (ItemStack tempStack : requiredItems) {
                    if (ItemStackUtils.isEmpty(tempStack).booleanValue()) continue;
                    InventoryUtils.consumeStack(tempStack, this.handler.getInventory());
                }
                this.handler.triggerEntitySuccess(localPos, requiredItems, true);
            }
            catch (RuntimeException e) {
                Log.getLogger().info("Couldn't restore entity", (Throwable)e);
            }
        }
        BlockEntity worldEntity = null;
        if (tileEntityData != null) {
            worldEntity = world.m_7702_(worldPos);
        }
        if (localState.m_60734_() == ModBlocks.blockSolidSubstitution.get() && this.handler.fancyPlacement()) {
            localState = this.handler.getSolidBlockForPos(worldPos, this.handler.getBluePrint().getRawBlockStateFunction().compose(this.handler::getStructurePosFromWorld));
        }
        if (localState.m_60734_() == ModBlocks.blockTagSubstitution.get() && this.handler.fancyPlacement()) {
            BlockEntity blockEntity;
            if (tileEntityData != null && (blockEntity = BlockEntity.m_155241_((BlockPos)localPos, (BlockState)localState, (CompoundTag)tileEntityData)) instanceof BlockEntityTagSubstitution) {
                BlockEntityTagSubstitution tagEntity = (BlockEntityTagSubstitution)blockEntity;
                localState = tagEntity.getReplacement().getBlockState();
                tileEntityData = tagEntity.getReplacement().getBlockEntityTag();
            } else {
                localState = Blocks.f_50016_.m_49966_();
            }
        }
        if (BlockUtils.areBlockStatesEqual(localState, worldState, this.handler::replaceWithSolidBlock, this.handler.fancyPlacement(), this.handler::shouldBlocksBeConsideredEqual, tileEntityData, worldEntity)) {
            return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
        }
        for (IPlacementHandler placementHandler : PlacementHandlers.handlers) {
            if (!placementHandler.canHandle(world, worldPos, localState)) continue;
            ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
            if (!sameBlockInWorld && !this.handler.isCreative()) {
                for (ItemStack stack : placementHandler.getRequiredItems(world, worldPos, localState, tileEntityData, false)) {
                    if (stack.m_41619_() || this.handler.isStackFree(stack)) continue;
                    requiredItems.add(stack);
                }
                if (!this.handler.hasRequiredItems(requiredItems)) {
                    return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
                }
            }
            if (!(worldState.m_60734_() instanceof AirBlock || sameBlockInWorld || worldState.m_60767_() == Material.f_76296_ || worldState.m_60734_() instanceof DoublePlantBlock && ((DoubleBlockHalf)worldState.m_61143_((Property)DoublePlantBlock.f_52858_)).equals((Object)DoubleBlockHalf.UPPER))) {
                placementHandler.handleRemoval(this.handler, world, worldPos, tileEntityData);
            }
            this.handler.prePlacementLogic(worldPos, localState, requiredItems);
            IPlacementHandler.ActionProcessingResult result = placementHandler.handle(this.getHandler().getBluePrint(), world, worldPos, localState, tileEntityData, !this.handler.fancyPlacement(), this.handler.getWorldPos(), this.handler.getSettings());
            if (result == IPlacementHandler.ActionProcessingResult.DENY) {
                placementHandler.handleRemoval(this.handler, world, worldPos, tileEntityData);
                return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.FAIL);
            }
            this.handler.triggerSuccess(localPos, requiredItems, true);
            if (result == IPlacementHandler.ActionProcessingResult.PASS) {
                return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
            }
            if (!this.handler.isCreative() && !sameBlockInWorld) {
                for (ItemStack tempStack : requiredItems) {
                    if (ItemStackUtils.isEmpty(tempStack).booleanValue()) continue;
                    InventoryUtils.consumeStack(tempStack, this.handler.getInventory());
                }
            }
            return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.SUCCESS);
        }
        return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.FAIL);
    }

    public BlockPlacementResult getResourceRequirements(Level world, BlockPos worldPos, BlockPos localPos, BlockState localState, CompoundTag tileEntityData) {
        BlockState worldState = world.m_8055_(worldPos);
        boolean sameBlockInWorld = false;
        if (worldState.m_60734_() == localState.m_60734_() && tileEntityData == null) {
            sameBlockInWorld = true;
        }
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
        for (CompoundTag compound : this.iterator.getBluePrintPositionInfo(localPos).getEntities()) {
            if (compound == null) continue;
            try {
                Entity entity;
                BlockPos pos = this.handler.getWorldPos().m_121996_((Vec3i)this.handler.getBluePrint().getPrimaryBlockOffset());
                Optional type = EntityType.m_20637_((CompoundTag)compound);
                if (!type.isPresent() || (entity = ((EntityType)type.get()).m_20615_(world)) == null) continue;
                entity.deserializeNBT(compound);
                Vec3 posInWorld = entity.m_20182_().m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                List list = world.m_45976_(entity.getClass(), new AABB(posInWorld.m_82520_(1.0, 1.0, 1.0), posInWorld.m_82520_(-1.0, -1.0, -1.0)));
                boolean foundEntity = false;
                for (Entity worldEntity : list) {
                    if (!worldEntity.m_20182_().equals((Object)posInWorld)) continue;
                    foundEntity = true;
                    break;
                }
                if (foundEntity) continue;
                requiredItems.addAll(ItemStackUtils.getListOfStackForEntity(entity, pos));
            }
            catch (RuntimeException e) {
                Log.getLogger().info("Couldn't restore entity", (Throwable)e);
            }
        }
        BlockEntity worldEntity = null;
        if (tileEntityData != null) {
            worldEntity = world.m_7702_(worldPos);
        }
        if (localState.m_60734_() == ModBlocks.blockSolidSubstitution.get() && this.handler.fancyPlacement()) {
            localState = this.handler.getSolidBlockForPos(worldPos, this.handler.getBluePrint().getRawBlockStateFunction().compose(this.handler::getStructurePosFromWorld));
        }
        if (localState.m_60734_() == ModBlocks.blockTagSubstitution.get() && this.handler.fancyPlacement()) {
            BlockEntity blockEntity;
            if (tileEntityData != null && (blockEntity = BlockEntity.m_155241_((BlockPos)localPos, (BlockState)localState, (CompoundTag)tileEntityData)) instanceof BlockEntityTagSubstitution) {
                BlockEntityTagSubstitution tagEntity = (BlockEntityTagSubstitution)blockEntity;
                localState = tagEntity.getReplacement().getBlockState();
                tileEntityData = tagEntity.getReplacement().getBlockEntityTag();
            } else {
                localState = Blocks.f_50016_.m_49966_();
            }
        }
        if (BlockUtils.areBlockStatesEqual(localState, worldState, this.handler::replaceWithSolidBlock, this.handler.fancyPlacement(), this.handler::shouldBlocksBeConsideredEqual, tileEntityData, worldEntity)) {
            return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
        }
        for (IPlacementHandler placementHandler : PlacementHandlers.handlers) {
            if (!placementHandler.canHandle(world, worldPos, localState)) continue;
            if (!sameBlockInWorld) {
                for (ItemStack stack : placementHandler.getRequiredItems(world, worldPos, localState, tileEntityData, false)) {
                    if (stack.m_41619_() || this.handler.isStackFree(stack)) continue;
                    requiredItems.add(stack);
                }
            }
            return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
        }
        return new BlockPlacementResult(worldPos, BlockPlacementResult.Result.MISSING_ITEMS, requiredItems);
    }

    public boolean checkForFreeSpace(BlockPos pos) {
        this.iterator.setProgressPos(pos);
        while (this.iterator.increment() == AbstractBlueprintIterator.Result.NEW_BLOCK) {
            BlockPos localPos = this.iterator.getProgressPos();
            BlockPos worldPos = pos.m_121955_((Vec3i)localPos);
            if (worldPos.m_123342_() <= pos.m_123342_() && !this.handler.getWorld().m_8055_(worldPos.m_7495_()).m_60767_().m_76333_()) {
                this.iterator.reset();
                return false;
            }
            BlockState worldState = this.handler.getWorld().m_8055_(worldPos);
            if (worldState.m_60734_() == Blocks.f_50752_) {
                this.iterator.reset();
                return false;
            }
            if (worldPos.m_123342_() <= pos.m_123342_() || worldState.m_60734_() == Blocks.f_50016_) continue;
            this.iterator.reset();
            return false;
        }
        this.iterator.reset();
        return true;
    }

    public AbstractBlueprintIterator getIterator() {
        return this.iterator;
    }

    public IStructureHandler getHandler() {
        return this.handler;
    }

    public boolean isReady() {
        return this.getHandler().isReady();
    }

    public static enum Operation {
        WATER_REMOVAL,
        BLOCK_REMOVAL,
        BLOCK_PLACEMENT,
        GET_RES_REQUIREMENTS;

    }
}

