/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.storage.rendering.ServerPreviewDistributor;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class SyncSettingsToServer
implements IMessage {
    private final boolean displayShared;

    public SyncSettingsToServer(FriendlyByteBuf buf) {
        this.displayShared = buf.readBoolean();
    }

    public SyncSettingsToServer() {
        this.displayShared = (Boolean)Structurize.getConfig().getClient().displayShared.get();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.displayShared);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPreviewDistributor.register(ctxIn.getSender(), this.displayShared);
    }
}

