/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.map.MapHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.entities.trades.AdventurerMapTrade;
import net.mehvahdjukaar.supplementaries.common.misc.map_markers.ModMapMarkers;
import net.mehvahdjukaar.supplementaries.common.worldgen.StructureLocator;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdventurerMapsHandler
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(AdventurerMapTrade.class, (json, typeOfT, context) -> (AdventurerMapTrade)AdventurerMapTrade.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, e -> Supplementaries.LOGGER.error("failed to parse structure map trade: {}", e))).create();
    public static final PreparableReloadListener RELOAD_INSTANCE = new AdventurerMapsHandler();
    public static final int SEARCH_RADIUS = 150;
    private static final List<AdventurerMapTrade> CUSTOM_MAPS_TRADES = new ArrayList<AdventurerMapTrade>();
    private static final Map<TagKey<Structure>, Pair<ResourceLocation, Integer>> DEFAULT_STRUCTURE_MARKERS = new HashMap<TagKey<Structure>, Pair<ResourceLocation, Integer>>();

    public AdventurerMapsHandler() {
        super(GSON, "structure_maps");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        CUSTOM_MAPS_TRADES.clear();
        jsons.forEach((key, json) -> {
            DataResult v = AdventurerMapTrade.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
            AdventurerMapTrade data = (AdventurerMapTrade)v.getOrThrow(false, e -> Supplementaries.LOGGER.error("failed to parse structure map trade: {}", e));
            CUSTOM_MAPS_TRADES.add(data);
        });
        if (CUSTOM_MAPS_TRADES.size() != 0) {
            Supplementaries.LOGGER.info("Loaded  " + CUSTOM_MAPS_TRADES.size() + " structure maps trades");
        }
    }

    private static void associateStructureMarker(TagKey<Structure> tag, ResourceLocation res, int color) {
        DEFAULT_STRUCTURE_MARKERS.put(tag, (Pair<ResourceLocation, Integer>)Pair.of((Object)res, (Object)color));
    }

    private static Pair<ResourceLocation, Integer> getStructureMarker(Holder<Structure> structure) {
        ResourceLocation res = ((ResourceKey)structure.m_203543_().get()).m_135782_();
        int color = 0;
        for (Map.Entry<TagKey<Structure>, Pair<ResourceLocation, Integer>> v : DEFAULT_STRUCTURE_MARKERS.entrySet()) {
            if (!structure.m_203656_(v.getKey())) continue;
            res = (ResourceLocation)v.getValue().getFirst();
            color = (Integer)v.getValue().getSecond();
            break;
        }
        return Pair.of((Object)res, (Object)color);
    }

    public static void addTradesCallback() {
        RegHelper.registerVillagerTrades((VillagerProfession)VillagerProfession.f_35588_, (int)1, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 1));
        RegHelper.registerVillagerTrades((VillagerProfession)VillagerProfession.f_35588_, (int)2, itemListings -> {
            if (CommonConfigs.Tweaks.RANDOM_ADVENTURER_MAPS.get().booleanValue()) {
                itemListings.add(new RandomAdventureMapTrade());
            }
            AdventurerMapsHandler.maybeAddCustomMap(itemListings, 2);
        });
        RegHelper.registerVillagerTrades((VillagerProfession)VillagerProfession.f_35588_, (int)3, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 3));
        RegHelper.registerVillagerTrades((VillagerProfession)VillagerProfession.f_35588_, (int)4, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 4));
        RegHelper.registerVillagerTrades((VillagerProfession)VillagerProfession.f_35588_, (int)5, itemListings -> AdventurerMapsHandler.maybeAddCustomMap(itemListings, 5));
    }

    private static void maybeAddCustomMap(List<VillagerTrades.ItemListing> listings, int level) {
        for (AdventurerMapTrade data : CUSTOM_MAPS_TRADES) {
            if (level != data.villagerLevel()) continue;
            listings.add(data);
        }
    }

    private static ItemStack createMapOrQuill(BlockPos pos, ServerLevel serverLevel, @Nullable TagKey<Structure> tag, int zoom, @Nullable ResourceLocation mapMarker, @Nullable String name, int color) {
        if (CompatHandler.QUARK && CommonConfigs.Tweaks.QUARK_QUILL.get().booleanValue()) {
            ItemStack item = QuarkCompat.makeAdventurerQuill(serverLevel, tag, 150, true, zoom, null, name, color);
            item.m_41714_((Component)Component.m_237115_((String)name));
            return item;
        }
        if (!serverLevel.m_7654_().m_129910_().m_5961_().m_224677_()) {
            return ItemStack.f_41583_;
        }
        Pair<BlockPos, Holder<Structure>> found = StructureLocator.findNearestRandomMapFeature(serverLevel, tag, pos, 150, true);
        if (found != null) {
            BlockPos toPos = (BlockPos)found.getFirst();
            return AdventurerMapsHandler.createStructureMap(serverLevel, toPos, (Holder<Structure>)((Holder)found.getSecond()), zoom, mapMarker, name, color);
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public static ItemStack createStructureMap(ServerLevel level, BlockPos pos, Holder<Structure> structure, int zoom, @Nullable ResourceLocation decoration, @Nullable String name, int color) {
        ItemStack stack = MapItem.m_42886_((Level)level, (int)pos.m_123341_(), (int)pos.m_123343_(), (byte)((byte)zoom), (boolean)true, (boolean)true);
        MapItem.m_42850_((ServerLevel)level, (ItemStack)stack);
        if (decoration == null) {
            Pair<ResourceLocation, Integer> s = AdventurerMapsHandler.getStructureMarker(structure);
            decoration = (ResourceLocation)s.getFirst();
            if (color == 0) {
                color = (Integer)s.getSecond();
            }
        }
        MapHelper.addDecorationToMap((ItemStack)stack, (BlockPos)pos, (ResourceLocation)decoration, (int)color);
        if (name != null) {
            stack.m_41714_((Component)Component.m_237115_((String)name));
        }
        return stack;
    }

    public static ItemStack createCustomMap(Level world, BlockPos pos, ResourceLocation structureName, @Nullable String mapName, int mapColor, @Nullable ResourceLocation mapMarker) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            TagKey destination = TagKey.m_203882_((ResourceKey)Registry.f_235725_, (ResourceLocation)structureName);
            String name = mapName == null ? "filled_map." + structureName.m_135815_().toLowerCase(Locale.ROOT) : mapName;
            return AdventurerMapsHandler.createMapOrQuill(pos, serverLevel, (TagKey<Structure>)destination, 2, mapMarker, name, mapColor);
        }
        return ItemStack.f_41583_;
    }

    static {
        AdventurerMapsHandler.associateStructureMarker((TagKey<Structure>)StructureTags.f_215891_, ModMapMarkers.SHIPWRECK_TYPE, 3416079);
        AdventurerMapsHandler.associateStructureMarker(ModTags.ANCIENT_CITY, ModMapMarkers.ANCIENT_CITY_TYPE, 407920);
        AdventurerMapsHandler.associateStructureMarker(ModTags.IGLOO, ModMapMarkers.IGLOO_TYPE, 10075586);
        AdventurerMapsHandler.associateStructureMarker((TagKey<Structure>)StructureTags.f_215892_, ModMapMarkers.RUINED_PORTAL_TYPE, 6238389);
        AdventurerMapsHandler.associateStructureMarker((TagKey<Structure>)StructureTags.f_215889_, ModMapMarkers.VILLAGE_TYPE, 12224341);
        AdventurerMapsHandler.associateStructureMarker((TagKey<Structure>)StructureTags.f_215893_, ModMapMarkers.OCEAN_RUIN_TYPE, 3828045);
        AdventurerMapsHandler.associateStructureMarker(ModTags.PILLAGER_OUTPOST, ModMapMarkers.PILLAGER_OUTPOST_TYPE, 0x1F1100);
        AdventurerMapsHandler.associateStructureMarker(ModTags.DESERT_PYRAMID, ModMapMarkers.DESERT_PYRAMID_TYPE, 8416575);
        AdventurerMapsHandler.associateStructureMarker(ModTags.JUNGLE_TEMPLE, ModMapMarkers.JUNGLE_TEMPLE_TYPE, 5400120);
        AdventurerMapsHandler.associateStructureMarker(ModTags.BASTION_REMNANT, ModMapMarkers.BASTION_TYPE, 2894127);
        AdventurerMapsHandler.associateStructureMarker(ModTags.END_CITY, ModMapMarkers.END_CITY_TYPE, 10253227);
        AdventurerMapsHandler.associateStructureMarker(ModTags.SWAMP_HUT, ModMapMarkers.SWAMP_HUT_TYPE, 1786143);
        AdventurerMapsHandler.associateStructureMarker(ModTags.NETHER_FORTRESS, ModMapMarkers.NETHER_FORTRESS, 3934219);
        AdventurerMapsHandler.associateStructureMarker((TagKey<Structure>)StructureTags.f_215890_, ModMapMarkers.MINESHAFT_TYPE, 0x808080);
    }

    private static class RandomAdventureMapTrade
    implements VillagerTrades.ItemListing {
        private RandomAdventureMapTrade() {
        }

        public MerchantOffer m_213663_(@NotNull Entity entity, @NotNull RandomSource random) {
            int maxPrice = 11;
            int minPrice = 6;
            int price = random.m_188503_(maxPrice - minPrice + 1) + minPrice;
            ItemStack itemstack = this.createMap(entity.f_19853_, entity.m_20183_());
            if (itemstack.m_41619_()) {
                return null;
            }
            int uses = CommonConfigs.Tweaks.QUILL_MAX_TRADES.get();
            int x = 6;
            int xp = (int)((float)(x * 12) / (float)uses);
            int cost = (int)((double)price * CommonConfigs.Tweaks.QUILL_TRADE_PRICE_MULT.get());
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, cost), new ItemStack((ItemLike)Items.f_42522_), itemstack, uses, xp, 0.2f);
        }

        private ItemStack createMap(Level level, BlockPos pos) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return AdventurerMapsHandler.createMapOrQuill(pos, serverLevel, null, 2, null, "filled_map.adventure", 7869722);
            }
            return ItemStack.f_41583_;
        }
    }
}

