/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.QuiverTooltip;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientBundleTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class QuiverTooltipComponent
implements ClientTooltipComponent {
    public static final ResourceLocation TEXTURE_LOCATION = ClientBundleTooltip.f_169863_;
    private final List<ItemStack> items;
    private final int selectedSlot;

    public QuiverTooltipComponent(QuiverTooltip tooltip) {
        this.items = tooltip.stacks();
        this.selectedSlot = tooltip.selected();
    }

    public int m_142103_() {
        return this.gridSizeY() * 20 + 2 + 4;
    }

    public int m_142069_(Font font) {
        return this.gridSizeX() * 18 + 2;
    }

    public void m_183452_(Font font, int mouseX, int mouseY, PoseStack poseStack, ItemRenderer itemRenderer, int blitOffset) {
        int i = this.gridSizeX();
        int j = this.gridSizeY();
        int k = 0;
        for (int l = 0; l < j; ++l) {
            for (int m = 0; m < i; ++m) {
                int n = mouseX + m * 18 + 1;
                int o = mouseY + l * 20 + 1;
                this.renderSlot(n, o, k++, font, poseStack, itemRenderer, blitOffset);
            }
        }
        this.drawBorder(mouseX, mouseY, i, j, poseStack, blitOffset);
    }

    private void renderSlot(int x, int y, int itemIndex, Font font, PoseStack poseStack, ItemRenderer itemRenderer, int blitOffset) {
        if (itemIndex >= this.items.size()) {
            this.blit(poseStack, x, y, blitOffset, Texture.SLOT);
            return;
        }
        ItemStack itemStack = this.items.get(itemIndex);
        this.blit(poseStack, x, y, blitOffset, Texture.SLOT);
        itemRenderer.m_174253_(itemStack, x + 1, y + 1, itemIndex);
        itemRenderer.m_115169_(font, itemStack, x + 1, y + 1);
        if (itemIndex == this.selectedSlot) {
            AbstractContainerScreen.m_169606_((PoseStack)poseStack, (int)(x + 1), (int)(y + 1), (int)blitOffset);
        }
    }

    private void drawBorder(int x, int y, int slotWidth, int slotHeight, PoseStack poseStack, int blitOffset) {
        int i;
        this.blit(poseStack, x, y, blitOffset, Texture.BORDER_CORNER_TOP);
        this.blit(poseStack, x + slotWidth * 18 + 1, y, blitOffset, Texture.BORDER_CORNER_TOP);
        for (i = 0; i < slotWidth; ++i) {
            this.blit(poseStack, x + 1 + i * 18, y, blitOffset, Texture.BORDER_HORIZONTAL_TOP);
            this.blit(poseStack, x + 1 + i * 18, y + slotHeight * 20, blitOffset, Texture.BORDER_HORIZONTAL_BOTTOM);
        }
        for (i = 0; i < slotHeight; ++i) {
            this.blit(poseStack, x, y + i * 20 + 1, blitOffset, Texture.BORDER_VERTICAL);
            this.blit(poseStack, x + slotWidth * 18 + 1, y + i * 20 + 1, blitOffset, Texture.BORDER_VERTICAL);
        }
        this.blit(poseStack, x, y + slotHeight * 20, blitOffset, Texture.BORDER_CORNER_BOTTOM);
        this.blit(poseStack, x + slotWidth * 18 + 1, y + slotHeight * 20, blitOffset, Texture.BORDER_CORNER_BOTTOM);
    }

    private void blit(PoseStack poseStack, int x, int y, int blitOffset, Texture texture) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_LOCATION);
        GuiComponent.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)blitOffset, (float)texture.x, (float)texture.y, (int)texture.w, (int)texture.h, (int)128, (int)128);
    }

    private int gridSizeX() {
        return this.items.size();
    }

    private int gridSizeY() {
        return 1;
    }

    static enum Texture {
        SLOT(0, 0, 18, 20),
        BLOCKED_SLOT(0, 40, 18, 20),
        BORDER_VERTICAL(0, 18, 1, 20),
        BORDER_HORIZONTAL_TOP(0, 20, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 60, 18, 1),
        BORDER_CORNER_TOP(0, 20, 1, 1),
        BORDER_CORNER_BOTTOM(0, 60, 1, 1);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int j, int k, int l, int m) {
            this.x = j;
            this.y = k;
            this.w = l;
            this.h = m;
        }
    }
}

