/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.MimicBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.RopeKnotBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRopeKnotBlock
extends MimicBlock
implements SimpleWaterloggedBlock,
EntityBlock,
IRotatable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final EnumProperty<ModBlockProperties.PostType> POST_TYPE = ModBlockProperties.POST_TYPE;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    private final Map<BlockState, VoxelShape> shapeMap;
    private final Map<BlockState, VoxelShape> collisionShapesMap;

    protected AbstractRopeKnotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        Pair<Map<BlockState, VoxelShape>, Map<BlockState, VoxelShape>> s = this.makeShapes();
        this.shapeMap = (Map)s.getFirst();
        this.collisionShapesMap = (Map)s.getSecond();
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(POST_TYPE, (Comparable)((Object)ModBlockProperties.PostType.POST))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, POST_TYPE, AXIS, NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new RopeKnotBlockTile(pPos, pState);
    }

    public boolean m_49967_() {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            try {
                return tile.getShape();
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to get block shape for rope knot block at {}", (Object)pos);
            }
        }
        return super.m_5940_(state, world, pos, context);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.shapeMap.getOrDefault(state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), Shapes.m_83144_());
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.shapeMap.getOrDefault(state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), Shapes.m_83144_());
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            try {
                return tile.getCollisionShape();
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to get collision shape for rope knot block at {}", (Object)pos);
            }
        }
        return super.m_5939_(state, world, pos, context);
    }

    protected Pair<Map<BlockState, VoxelShape>, Map<BlockState, VoxelShape>> makeShapes() {
        HashMap<BlockState, VoxelShape> shapesBuilder = new HashMap<BlockState, VoxelShape>();
        HashMap<BlockState, VoxelShape> collisionBuilder = new HashMap<BlockState, VoxelShape>();
        VoxelShape down = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape up = Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape north = this.getSideShape();
        VoxelShape south = Utils.rotateVoxelShape((VoxelShape)north, (Direction)Direction.SOUTH);
        VoxelShape west = Utils.rotateVoxelShape((VoxelShape)north, (Direction)Direction.WEST);
        VoxelShape east = Utils.rotateVoxelShape((VoxelShape)north, (Direction)Direction.EAST);
        for (BlockState state : this.f_49792_.m_61056_()) {
            VoxelShape v;
            if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) continue;
            int w = ((ModBlockProperties.PostType)((Object)state.m_61143_(POST_TYPE))).getWidth();
            double o = (double)(16 - w) / 2.0;
            VoxelShape c = switch ((Direction.Axis)state.m_61143_(AXIS)) {
                default -> {
                    v = Block.m_49796_((double)o, (double)0.0, (double)o, (double)(o + (double)w), (double)16.0, (double)(o + (double)w));
                    yield Block.m_49796_((double)o, (double)0.0, (double)o, (double)(o + (double)w), (double)24.0, (double)(o + (double)w));
                }
                case Direction.Axis.X -> v = Block.m_49796_((double)0.0, (double)o, (double)o, (double)16.0, (double)(o + (double)w), (double)(o + (double)w));
                case Direction.Axis.Z -> v = Block.m_49796_((double)o, (double)o, (double)0.0, (double)(o + (double)w), (double)(o + (double)w), (double)16.0);
            };
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)down);
            }
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)up);
            }
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)north);
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)south);
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)west);
            }
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
                v = Shapes.m_83110_((VoxelShape)v, (VoxelShape)east);
            }
            c = Shapes.m_83110_((VoxelShape)c, (VoxelShape)v);
            c = c.m_83296_();
            v = v.m_83296_();
            boolean flag = true;
            for (VoxelShape existing : shapesBuilder.values()) {
                if (!existing.equals(v)) continue;
                shapesBuilder.put(state, existing);
                flag = false;
                break;
            }
            if (flag) {
                shapesBuilder.put(state, v);
            }
            boolean flag2 = true;
            for (VoxelShape existing : collisionBuilder.values()) {
                if (!existing.equals(c)) continue;
                collisionBuilder.put(state, existing);
                flag2 = false;
                break;
            }
            if (!flag2) continue;
            collisionBuilder.put(state, c);
        }
        return Pair.of((Object)ImmutableMap.copyOf(shapesBuilder), (Object)ImmutableMap.copyOf(collisionBuilder));
    }

    public abstract VoxelShape getSideShape();

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
                break;
            }
            case COUNTERCLOCKWISE_90: {
                BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
                break;
            }
            case CLOCKWISE_90: {
                BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
                break;
            }
            default: {
                BlockState blockState = state = state;
            }
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return state;
        }
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Direction.Axis.X -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
            case Direction.Axis.Z -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
            default -> state;
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            default -> super.m_6943_(state, mirror);
        };
    }

    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        if (axis.m_122434_() == Direction.Axis.Y) {
            return Optional.ofNullable(this.m_6843_(state, rotation));
        }
        return Optional.empty();
    }

    public void onRotated(BlockState newState, BlockState oldState, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        BlockEntity blockEntity;
        if (axis.m_122434_() == Direction.Axis.Y && (blockEntity = world.m_7702_(pos)) instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            BlockState mimic = tile.getHeldBlock();
            BlockState newMimic = tile.getHeldBlock().m_60717_(rotation);
            if (newMimic != mimic) {
                tile.setHeldBlock(newMimic);
                tile.m_6596_();
            }
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_205070_(FluidTags.f_13131_) && fluidstate.m_76186_() == 8;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            BlockState mimic = tile.getHeldBlock();
            return mimic.m_60734_().m_7397_(level, pos, state);
        }
        return super.m_7397_(level, pos, state);
    }

    @Nullable
    public static BlockState convertToRopeKnot(ModBlockProperties.PostType type, BlockState state, Level world, BlockPos pos) {
        Direction.Axis axis = Direction.Axis.Y;
        if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
        }
        BlockState newState = (BlockState)((BlockState)ModRegistry.ROPE_KNOT.get().m_49966_().m_61124_(AXIS, (Comparable)axis)).m_61124_(POST_TYPE, (Comparable)((Object)type));
        if (!world.m_7731_(pos, newState = Block.m_49931_((BlockState)newState, (LevelAccessor)world, (BlockPos)pos), 0)) {
            return null;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof RopeKnotBlockTile) {
            RopeKnotBlockTile tile = (RopeKnotBlockTile)blockEntity;
            tile.setHeldBlock(state);
            tile.m_6596_();
        }
        newState.m_60701_((LevelAccessor)world, pos, 6);
        return newState;
    }
}

