/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.inventories;

import net.mehvahdjukaar.supplementaries.common.block.tiles.SackBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.DelegatingSlot;
import net.mehvahdjukaar.supplementaries.common.inventories.IContainerProvider;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModMenuTypes;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;

public class SackContainerMenu
extends AbstractContainerMenu
implements IContainerProvider {
    public final Container inventory;
    private static final int[][] TARGET_RATIOS = new int[][]{{1, 1}, {2, 2}, {3, 2}, {3, 3}, {4, 2}, {5, 2}, {6, 2}, {7, 2}, {8, 2}, {8, 2}, {9, 2}, {10, 2}, {7, 3}, {8, 3}, {9, 3}};

    @Override
    public Container getContainer() {
        return this.inventory;
    }

    public SackContainerMenu(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory);
    }

    public SackContainerMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, (BaseContainerBlockEntity)ModRegistry.SACK_TILE.get().m_155264_(BlockPos.f_121853_, ModRegistry.SACK.get().m_49966_()));
    }

    public SackContainerMenu(int id, Inventory playerInventory, BaseContainerBlockEntity inventory) {
        super(ModMenuTypes.SACK.get(), id);
        int si;
        this.inventory = inventory;
        SackContainerMenu.m_38869_((Container)inventory, (int)SackBlockTile.getUnlockedSlots());
        inventory.m_5856_(playerInventory.f_35978_);
        int size = CommonConfigs.Functional.SACK_SLOTS.get();
        int[] dims = SackContainerMenu.getRatio(size);
        if (dims[0] > 9) {
            dims[0] = 9;
            dims[1] = (int)Math.ceil((float)size / 9.0f);
        }
        int yp = 44 - 9 * dims[1];
        int dimx = 0;
        for (int h = 0; h < dims[1]; ++h) {
            int dimXPrev = dimx;
            dimx = Math.min(dims[0], size);
            int xp = 89 - dimx * 18 / 2;
            for (int j = 0; j < dimx; ++j) {
                this.m_38897_(new DelegatingSlot(inventory, j + h * dimXPrev, xp + j * 18, yp + 18 * h));
            }
            size -= dims[0];
        }
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.m_38897_(new Slot((Container)playerInventory, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.m_38897_(new Slot((Container)playerInventory, si, 8 + si * 18, 142));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return this.inventory.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack item = slot.m_7993_();
            itemStack = item.m_41777_();
            int activeSlots = CommonConfigs.Functional.SACK_SLOTS.get();
            if (index < activeSlots ? !this.m_38903_(item, activeSlots, this.f_38839_.size(), true) : !this.m_38903_(item, 0, activeSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (item.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStack;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack itemStack;
        Slot slot;
        boolean bl = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                slot = (Slot)this.f_38839_.get(i);
                itemStack = slot.m_7993_();
                if (!itemStack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack)) {
                    int j = itemStack.m_41613_() + stack.m_41613_();
                    if (j <= stack.m_41741_()) {
                        stack.m_41764_(0);
                        itemStack.m_41764_(j);
                        slot.m_6654_();
                        bl = true;
                    } else if (itemStack.m_41613_() < stack.m_41741_()) {
                        stack.m_41774_(stack.m_41741_() - itemStack.m_41613_());
                        itemStack.m_41764_(stack.m_41741_());
                        slot.m_6654_();
                        bl = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            int n = i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                slot = (Slot)this.f_38839_.get(i);
                itemStack = slot.m_7993_();
                if (itemStack.m_41619_() && slot.m_5857_(stack)) {
                    if (stack.m_41613_() > slot.m_6641_()) {
                        slot.m_5852_(stack.m_41620_(slot.m_6641_()));
                    } else {
                        slot.m_5852_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot.m_6654_();
                    bl = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return bl;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.inventory.m_5785_(playerIn);
    }

    public static int[] getRatio(int maxSize) {
        int[] dims = new int[]{Math.min(maxSize, 23), Math.max(maxSize / 23, 1)};
        for (int[] testAgainst : TARGET_RATIOS) {
            if (testAgainst[0] * testAgainst[1] != maxSize) continue;
            dims = testAgainst;
            break;
        }
        return dims;
    }
}

